/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *GUI used to list the ADD or SET rules for a Host
 */


import java.util.*;
import javax.swing.*;
import java.awt.*;

public class PropertyList extends javax.swing.JFrame {
    
    public PropertyList(VirtualHostVisual vH) {
    	this.vH1=vH;
    	addOption=true;
        initComponents();
    }
    
    public PropertyList(VirtualHostVisual vH, boolean add) {
    	this.vH1=vH;
    	addOption=add;
        initComponents();
    }

    private void initComponents() {
    	
        refresh = new javax.swing.JButton();
        filter = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();        
        add = new javax.swing.JButton();
        
        javax.swing.table.AbstractTableModel ta;
        String select="Add";
        
        if(select.compareToIgnoreCase(new String("Add"))==0)
        {
        	ta=new TableAdd(vH1.getAddProp());
    	}
    	else
    	{
    		ta=new TableSet(vH1.getSetProp());
    	}
        table1 = new javax.swing.JTable(ta);
        JScrollPane scrollPane = new JScrollPane(table1);
		table1.setPreferredScrollableViewportSize(new Dimension(600, 70));



        getContentPane().setLayout(null);

        addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                formMouseClicked(evt);
            }
        });

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

		getContentPane().add(scrollPane);
		scrollPane.setBounds(30,60,500,150);
		
        refresh.setText("Refresh");
        getContentPane().add(refresh);
        refresh.setBounds(180, 20, 90, 26);
        refresh.addMouseListener(new java.awt.event.MouseAdapter(){
        	public void mouseClicked(java.awt.event.MouseEvent evt){
        		refreshMouseClicked(evt);
        	}
        });
        
        

        filter.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Add rules", "Set rules"}));
        getContentPane().add(filter);
        filter.setBounds(60, 20, 100, 25);
        filter.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                filterItemStateChanged(evt);
            }
        });

        jLabel1.setText("Filter:");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(20, 20, 31, 16);
		
		add.setText("Add");
		if(addOption==true)
		{
			getContentPane().add(add);
        	add.setBounds(280, 20, 56, 26);
    	}
        add.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                addMouseClicked(evt);
            }
        });

		this.setTitle(vH1.getName());
        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(600, 300));
        setLocation((screenSize.width-400)/2,(screenSize.height-300)/2);
    }
	
	/*****************************************************************/
	/*****************************************************************/
	private void addMouseClicked(java.awt.event.MouseEvent evt) 
	{
        new Honeyd(vH1).show(true);
        this.dispose();
    }
	
	private void refreshMouseClicked(java.awt.event.MouseEvent e)
	{
		int val,nb=0;
		boolean drop=false; 
		javax.swing.table.AbstractTableModel ta=null;
		
		if(((String)filter.getSelectedItem()).compareToIgnoreCase(new String("Add rules"))==0)
			val=0;
		else
			val=1;
		
		nb=table1.getRowCount();
		for(int i=nb-1;i>=0;i--)
		{
			
			if(((Boolean)table1.getValueAt(i,5)).booleanValue()==true)
			{
				if(val==0)
				{
					if(vH1.getAddProp().size()>0)
						vH1.removeAddProps(vH1.getAddProp(i));
					ta=new TableAdd(vH1.getAddProp());
					drop=true;
				}
				else
				{
					if(vH1.getSetProp().size()>0)
						vH1.removeSetProps(vH1.getSetProp(i));
					ta=new TableSet(vH1.getSetProp());
					drop=true;
				}
				nb--;
			}
		}
		if(drop==true)
			table1.setModel(ta);
		repaint();
	}
	
	private void filterItemStateChanged(java.awt.event.ItemEvent e) 
	{
		javax.swing.table.AbstractTableModel ta;
		
		if(((String)filter.getSelectedItem()).compareToIgnoreCase(new String("Add rules"))==0)
		{
			
        	ta=new TableAdd(vH1.getAddProp());
    	}
    	else
    	{
    		ta=new TableSet(vH1.getSetProp());
    	}
        table1.setModel(ta);
        repaint();
	}


    private void formMouseClicked(java.awt.event.MouseEvent evt) {

    }
    
    private void exitForm(java.awt.event.WindowEvent evt) {
        this.dispose();;
    }
    
/**********************************************/
	//GUI component
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton refresh;
    private javax.swing.JComboBox filter;
    private javax.swing.JButton add;
//---------------------------------------------
	//data
    private javax.swing.JTable table1;
    private VirtualHostVisual vH1;
    private boolean addOption=false;
    

    
}
