/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *use to stor and draw the link between the hosts
 */


import java.util.*;
import java.awt.*;
import java.lang.*;

class NetworkLink 
{
	private int x1=0;
	private int y1=0;
	private int x2=0;
	private int y2=0;
	private VirtualHostVisual v1;
	private VirtualHostVisual v2;
	
	private static int linkNumber=0;
	
	private double[][] tabPosition={
		{0.5,0,0.5,1},
		{1,0.5,0,0.5},
		{0.5,1,0.5,0},
		{0,0.5,1,0.5}
	};
	
	/**************************************************/
	/***********Constructor****************************/
	public NetworkLink()
	{
	}
	public NetworkLink(int xa,int ya, int xb, int yb)
	{
		x1=xa;
		y1=ya;
		x2=xb;
		y2=yb;
	}
	 
	public NetworkLink(VirtualHostVisual va,VirtualHostVisual vb)
	{
		v1=va;
		v2=vb;
		x1=va.getX();
		y1=va.getY();
		x2=vb.getX();
		y2=vb.getY();
	}
	
	
	/**************************************************************/
	/******************Internal opperation*************************/
	
	public void paint(Graphics g)
	{
		int i=0;
		if(v1==null || v2==null)
			return;
			
		if(v2.getX()>=1 && v2.getX()<=v1.getX()+v1.getDim().getWidth() &&v2.getY()> v1.getY()+v1.getDim().getHeight())
				i=2;
		else if(v2.getX()>=1 && v2.getX()<=v1.getX()+v1.getDim().getWidth() && v2.getY()< v1.getY())
				i=0;
		else if(v2.getY()>=v1.getY() && v2.getY()<=v1.getY()+v1.getDim().getHeight() && v2.getX()<v1.getX())
				i=3;
		else if(v2.getY()>=v1.getY() && v2.getY()<=v1.getY()+v1.getDim().getHeight() && v2.getX()>v1.getX()+v1.getDim().getWidth())
				i=1;
		else if(v2.getX()>v1.getX()+v1.getDim().getWidth() && v2.getY()<v1.getY())//case A
			i=0;
		else if(v2.getX()>v1.getX()+v1.getDim().getWidth() && v2.getY()>v1.getY()+v1.getDim().getHeight())
			i=1;
		else if(v2.getX()<v1.getX() && v2.getY()<v1.getY()+v1.getDim().getHeight())
			i=2;
		else if(v2.getX()<v1.getX() && v2.getY()<v1.getY())
			i=3;
		
		
		x1=(int)Math.round(v1.getX()+v1.getDim().getWidth()*tabPosition[i][0]);
		y1=(int)Math.round(v1.getY()+v1.getDim().getHeight()*tabPosition[i][1]);		
		x2=(int)Math.round(v2.getX()+v2.getDim().getWidth()*tabPosition[i][2]);
		y2=(int)Math.round(v2.getY()+v2.getDim().getHeight()*tabPosition[i][3]);
		
		g.setColor(new Color(0,0,0));
		g.drawLine(x1,y1,x2,y2);
	}
	
}
