/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *Network class 
 *
 *use to store the routing propriety
 *for the virtual network
 */

import java.util.*;


class Network 
{
	private String property;//value like "entry, link, add net"
	private String ip1;//router ip
	private String ip2;//new router ip
	private String ipRange;//routing table 
	private String extra1;//latency
	private String extra2;//loss
	
	/***************************************************/
	/**************Constructor**************************/
	public Network()
	{
	}
	
	public Network(String property,String ip1,String ip2,String ipRange,String extra1,String extra2)
	{
		this.property=property;
		this.ip1=ip1;
		this.ip2=ip2;
		this.ipRange=ipRange;
		this.extra1=extra1;
		this.extra2=extra2;
	}
	
	/****************************************************/
	/************Internal opperation*********************/
	
	public String getProperty()
	{
		return property;
	}
	
	public String getIP1()
	{
		return ip1;
	}
	
	public String getIP2()
	{
		return ip2;
	}
	
	public String getIPRange()
	{
		return ipRange;
	}
	
	public String getExtra1()
	{
		return extra1;
	}
	
	public String getExtra2()
	{
		return extra2;
	}
	
	//extract the routing rules from the data member
	public String extract()
	{
		if(property.compareTo(new String("entry"))==0)
		{
			return new String("route entry "+ip1);
		}
		else if(property.compareTo(new String("add net"))==0)
		{
			return new String("route "+ip1+" "+property+" "+ipRange+" "+ip2+" latency "+extra1+"ms loss "+extra2);
		}
		else if(property.compareTo(new String("link"))==0)
		{
			return new String("route "+ip1+" "+property+" "+ipRange);
		}
		
		return "";
	}
	
}
