/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *GUI used to configure visualy the network and access to
 *the host and routing property.
 */
 
import java.util.*;
import java.awt.*;
import java.io.*;
 
public class HostNetConf extends javax.swing.JFrame {
    
    /** Creates new form HostNetConf */
    
    
    public HostNetConf() {
        initComponents();
    }

    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        add = new javax.swing.JButton();
        delHost = new javax.swing.JButton();
        writeConf = new javax.swing.JButton();
        route = new javax.swing.JButton();
        vHN=new VirtualHostNetwork(this,10,150,this.getWidth()-20,this.getHeight()-150);
		cf=new ConfigFile(vHN);
        getContentPane().setLayout(null);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                //exitForm(evt);
                dispose();
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 1, 18));
        jLabel1.setText("Virtual host and network configuration");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(10, 20, 350, 24);

        getContentPane().add(jSeparator1);
        jSeparator1.setBounds(10, 50, 480, 2);


        add.setText("Add virtual host");
        getContentPane().add(add);
        add.setBounds(10, 70, 150, 26);
        add.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                addMouseClicked(evt);
            }
        });

        writeConf.setText("Write config file");
        getContentPane().add(writeConf);
        writeConf.setBounds(340, 70, 140, 26);
        writeConf.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                writeConfActionPerformed(evt);
            }
        });
        
		delHost.setText("Delete host");
		getContentPane().add(delHost);
		delHost.setBounds(500, 70, 140, 26);
		delHost.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                delHostActionPerformed(evt);
            }
        });
		
		
        route.setText("Routing setup");
        getContentPane().add(route);
        route.setBounds(170, 70, 150, 26);
        route.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                routeActionPerformed(evt);
            }
        });

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(650, 419));
        setLocation((screenSize.width-650)/2,(screenSize.height-419)/2);
    }
    /******************************************************************************/
    /******************************************************************************/
    private void delHostActionPerformed(java.awt.event.ActionEvent evt) {
    	if(vHN==null)
    		return;
    	new HostList(vHN).show();
    	repaint();
    }
    	
    	
    private void writeConfActionPerformed(java.awt.event.ActionEvent evt) {
    	if(vHN==null)
    		return;
        try
        {
        	cf.save();
        }
        catch(Exception e)
        {
        	javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        	jop.showMessageDialog(null, e.getMessage(),"Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        }
    }
    
    private void routeActionPerformed(java.awt.event.ActionEvent evt) {
        new RouteConf(vHN).show();
    }
    
    private void addMouseClicked(java.awt.event.MouseEvent evt) {
        new Honeyd(this).show(true);
    }
    
    
    public void addVirtHost(VirtualHostVisual v)
    {
    	vHN.addHost(v);
    	repaint();
    	
    }
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        //System.exit(0);
        dispose();
       
    }
    
    public void paint(Graphics g)
    {
    	add.repaint();
    	route.repaint();
    	writeConf.repaint();
    	delHost.repaint();
    	jSeparator1.repaint();
    	jLabel1.repaint();
    	g.setColor(new Color(255,255,255));
    	g.fillRect(10,150,this.getWidth()-20,this.getHeight()-150);
    	vHN.setRestictZone(10,150,this.getWidth()-20,this.getHeight()-150);
    	vHN.repaint(g);
    }
    
   
    
    // Variables declaration - do not modify
    private javax.swing.JButton delHost;
    private javax.swing.JButton writeConf;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton add;
    private javax.swing.JButton route;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration
    private VirtualHostNetwork vHN;
    private ConfigFile cf;
    
}
