/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *Used to list and delete the virtual host
 */


import java.util.*;
import javax.swing.*;
import java.awt.*;

class HostList extends javax.swing.JFrame {
    
    public HostList(VirtualHostNetwork vH) {
    	this.vhn=vH;
        initComponents();
    }
    
    private void initComponents() {
    	
        refresh = new javax.swing.JButton();
        
        javax.swing.table.AbstractTableModel ta;

    	ta=new TableHost(vhn.getHost());
        table1 = new javax.swing.JTable(ta);
        JScrollPane scrollPane = new JScrollPane(table1);
		table1.setPreferredScrollableViewportSize(new Dimension(300, 70));



        getContentPane().setLayout(null);

        addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                formMouseClicked(evt);
            }
        });

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

		getContentPane().add(scrollPane);
		scrollPane.setBounds(30,60,300,150);
		
        refresh.setText("Refresh");
        getContentPane().add(refresh);
        refresh.setBounds(30, 20, 90, 26);
        refresh.addMouseListener(new java.awt.event.MouseAdapter(){
        	public void mouseClicked(java.awt.event.MouseEvent evt){
        		refreshMouseClicked(evt);
        	}
        });

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(400, 300));
        setLocation((screenSize.width-400)/2,(screenSize.height-300)/2);
    }
	/******************************************************************************/
	/******************************************************************************/
	
	//delete all checked object
	private void refreshMouseClicked(java.awt.event.MouseEvent e)
	{
		int val,nb=0;
		boolean drop=false; 
		javax.swing.table.AbstractTableModel ta=null;
		
		nb=table1.getRowCount();
		for(int i=nb-1;i>=0;i--)
		{
			if(((Boolean)table1.getValueAt(i,2)).booleanValue()==true)
			{
					if(vhn.getHost().size()>0)
						vhn.removeHost(i);
					ta=new TableHost(vhn.getHost());
					drop=true;
				nb--;
			}
		}
		if(drop==true)
			table1.setModel(ta);
		repaint();
	}
	


    private void formMouseClicked(java.awt.event.MouseEvent evt) {

    }
    
    private void exitForm(java.awt.event.WindowEvent evt) {
        this.dispose();
    }
    
	/********************************************************/
    private javax.swing.JButton refresh;
    private javax.swing.JTable table1;
    private VirtualHostNetwork vhn;
    

    
}

