/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/**
 *central GUI used to access to all configuration 
 * 
 */
public class HostFrame extends javax.swing.JFrame {
    
    /** Creates new form HostFrame */
    public HostFrame() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        runningOpt = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        configOpt = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        configPath = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();

        getContentPane().setLayout(null);

        setTitle("Honeyd GUI");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 1, 18));
        jLabel1.setText("Honeyd configuration GUI");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(10, 20, 300, 24);

        getContentPane().add(jSeparator1);
        jSeparator1.setBounds(10, 50, 410, 2);

        runningOpt.setText("Running Option");
        runningOpt.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                runningOptMouseClicked(evt);
            }
        });

        getContentPane().add(runningOpt);
        runningOpt.setBounds(10, 70, 140, 26);

        jLabel2.setText("You can chouse the starting options for honeyd");
        getContentPane().add(jLabel2);
        jLabel2.setBounds(160, 80, 300, 16);

        configOpt.setText("Config File");
        configOpt.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                configOptMouseClicked(evt);
            }
        });

        getContentPane().add(configOpt);
        configOpt.setBounds(10, 120, 140, 26);

        jLabel3.setText("virtual network topology for honeyd");
        getContentPane().add(jLabel3);
        jLabel3.setBounds(160, 140, 300, 16);

        jLabel4.setText("You can configure virtual hosts and ");
        getContentPane().add(jLabel4);
        jLabel4.setBounds(160, 120, 300, 16);

        configPath.setText("Config Path");
        configPath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                configPathActionPerformed(evt);
            }
        });

        getContentPane().add(configPath);
        configPath.setBounds(10, 170, 140, 26);

        jLabel5.setText("Configure Path & File name");
        getContentPane().add(jLabel5);
        jLabel5.setBounds(160, 170, 300, 16);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(500, 240));
        setLocation((screenSize.width-500)/2,(screenSize.height-240)/2);
    }
/********************************************************************************************/
/********************************************************************************************/
    private void configPathActionPerformed(java.awt.event.ActionEvent evt) {
        new FilePathSetup().show();
    }

    private void runningOptMouseClicked(java.awt.event.MouseEvent evt) {
        new StartConf().show();
    }

    private void configOptMouseClicked(java.awt.event.MouseEvent evt) {
        new HostNetConf().show();
    }

    private void formWindowOpened(java.awt.event.WindowEvent evt) {
        // Add your handling code here:
    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        System.exit(0);
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new HostFrame().show();
    }
    
    
    // Variables declaration - do not modify
    private javax.swing.JLabel jLabel4;
    private javax.swing.JButton configPath;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JButton runningOpt;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JButton configOpt;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel jLabel5;
    // End of variables declaration
    
}
