/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *GUI used to configure the virtual host:
 *Adding SET and ADD rules
 *IP binding
 *name...
 */
import java.util.*;
 
public class Honeyd extends javax.swing.JFrame {
    
    /****************************************/
    /**********Constructor*******************/
    public Honeyd() {
        initComponents();
    }
    
    public Honeyd(VirtualHostVisual v)
    {
    	vH1=v;
    	initComponents();
    	name.setText(vH1.getName());
    	ipAddress.setText(vH1.getIP());
    }
    
    public Honeyd(HostNetConf p)
    {
    	parent=p;
    	initComponents();
    }
    
    
    /*****************************************/
    /*********Internal operations************/
    private void initComponents() {
        addHost = new javax.swing.JButton();
        name = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        portNum = new javax.swing.JTextField();
        proto = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        add = new javax.swing.JButton();
        showProp = new javax.swing.JButton();
        cancel = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();
        ipAddress = new javax.swing.JTextField();
        addProp = new javax.swing.JComboBox();
        setProp = new javax.swing.JComboBox();
        personality= new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        set = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        jSeparator2 = new javax.swing.JSeparator();
        setCmd1 = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        addCmd = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        jSeparator3 = new javax.swing.JSeparator();
        jLabel10 = new javax.swing.JLabel();
        setProto = new javax.swing.JComboBox();
        jLabel11 = new javax.swing.JLabel();
        setCmd2 = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        setAction = new javax.swing.JComboBox();
        optDefault = new javax.swing.JCheckBox();
        fName=new FileName();
        //extracting the personnality from the fingerprint file
        try
        {
        	pf= new ParseFingerprint(fName.getFingerFile());
    	}
    	catch(Exception e){System.out.println("expt: "+e.getMessage());}
		//-----------------------------------------------------
		
        getContentPane().setLayout(null);

        setTitle("honeyd GUI");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        addHost.setText("Add virtual host");
        addHost.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                addHostMouseClicked(evt);
            }
        });

        getContentPane().add(addHost);
        addHost.setBounds(210, 350, 130, 26);

        getContentPane().add(name);
        name.setBounds(120, 20, 210, 20);

        jLabel1.setText("Template Name");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(20, 20, 95, 16);

        portNum.setText("80");
        getContentPane().add(portNum);
        portNum.setBounds(230, 80, 90, 20);

        proto.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "TCP", "UDP", "ICMP" }));
        getContentPane().add(proto);
        proto.setBounds(80, 80, 90, 25);
		//****************************
		String str[]=new String[pf.getNumber()];
		for(int i=0;i<pf.getNumber();i++)
		{
			str[i]=pf.getFingerPrint(i);
		}
		personality.setModel(new javax.swing.DefaultComboBoxModel(str));
        getContentPane().add(personality);
        personality.setBounds(80, 230, 350, 20);
        personality.show(false);
		//****************************
        jLabel2.setText("Protocol:");
        getContentPane().add(jLabel2);
        jLabel2.setBounds(20, 80, 65, 16);

        jLabel3.setText("Port:");
        getContentPane().add(jLabel3);
        jLabel3.setBounds(180, 80, 40, 16);

        jLabel4.setText("Action:");
        getContentPane().add(jLabel4);
        jLabel4.setBounds(20, 110, 60, 16);

        add.setText("Add");
        add.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                addMouseClicked(evt);
            }
        });

        getContentPane().add(add);
        add.setBounds(20, 140, 70, 26);

        showProp.setText("Show all proprieties");
        showProp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showPropActionPerformed(evt);
            }
        });

        showProp.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                showPropMouseClicked(evt);
            }
        });

        getContentPane().add(showProp);
        showProp.setBounds(40, 350, 160, 26);

        cancel.setText("Cancel");
        cancel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cancelMouseClicked(evt);
            }
        });

        getContentPane().add(cancel);
        cancel.setBounds(340, 350, 90, 26);

        jLabel5.setText("IP address:");
        getContentPane().add(jLabel5);
        jLabel5.setBounds(20, 320, 80, 16);

        ipAddress.setText("255.255.255.255");
        getContentPane().add(ipAddress);
        ipAddress.setBounds(110, 320, 100, 20);

        addProp.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "cmd-string", "block", "open", "reset", "proxy" }));
        getContentPane().add(addProp);
        addProp.setBounds(80, 110, 90, 25);
        addProp.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                addPropItemStateChanged(evt);
            }
        });

        setProp.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "default", "personality", "personality random", "subsystem", "uptime", "droprate in", "uid gid", "ip-uptime" }));
        setProp.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                setPropMouseClicked(evt);
            }
        });
        setProp.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                setPropItemStateChanged(evt);
            }
        });

        getContentPane().add(setProp);
        setProp.setBounds(20, 200, 90, 25);
        

        jLabel6.setText("Add");
        getContentPane().add(jLabel6);
        jLabel6.setBounds(20, 60, 40, 16);

        jLabel7.setText("Set");
        getContentPane().add(jLabel7);
        jLabel7.setBounds(20, 180, 40, 16);

        set.setText("Set");
        set.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                setMouseClicked(evt);
            }
        });

        getContentPane().add(set);
        set.setBounds(20, 260, 53, 26);

        getContentPane().add(jSeparator1);
        jSeparator1.setBounds(20, 170, 380, 2);

        getContentPane().add(jSeparator2);
        jSeparator2.setBounds(20, 50, 380, 2);

        getContentPane().add(setCmd1);
        setCmd1.setBounds(80, 230, 120, 20);

        jLabel8.setText("Action:");
        getContentPane().add(jLabel8);
        jLabel8.setBounds(25, 230, 60, 16);

        getContentPane().add(addCmd);
        addCmd.setBounds(220, 110, 170, 20);

        jLabel9.setText("Cmd:");
        getContentPane().add(jLabel9);
        jLabel9.setBounds(180, 110, 40, 16);

        getContentPane().add(jSeparator3);
        jSeparator3.setBounds(20, 290, 380, 2);

        jLabel10.setText("Binding");
        getContentPane().add(jLabel10);
        jLabel10.setBounds(20, 300, 55, 16);

        setProto.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "TCP", "UDP", "ICMP" }));
        getContentPane().add(setProto);
        setProto.setBounds(180, 200, 90, 25);

        jLabel11.setText("Protocol:");
        getContentPane().add(jLabel11);
        jLabel11.setBounds(120, 200, 60, 16);

        getContentPane().add(setCmd2);
        setCmd2.setBounds(280, 230, 120, 20);
        setCmd2.show(false);

        jLabel12.setText("Cmd2:");
        getContentPane().add(jLabel12);
        jLabel12.setBounds(230, 230, 55, 16);
        jLabel12.show(false);
	
		jLabel13.setText("Action:");
        getContentPane().add(jLabel13);
        jLabel13.setBounds(280, 200, 50, 16);

        setAction.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "cmd-string","block", "open", "reset", "proxy" }));
        getContentPane().add(setAction);
        setAction.setBounds(320, 200, 90, 25);
        setAction.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                setActionItemStateChanged(evt);
            }
        });
        
        optDefault.setText("default");
        getContentPane().add(optDefault);
        optDefault.setBounds(340, 20, 93, 24);
        optDefault.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                optDefaultItemStateChanged(evt);
            }
        });
        
        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(500, 415));
        setLocation((screenSize.width-500)/2,(screenSize.height-415)/2);
    }
	/*****************************************************************/
	/******************Internal operation*****************************/
    private void cancelMouseClicked(java.awt.event.MouseEvent evt) {
        this.dispose();
    }
    
    
     private void optDefaultItemStateChanged(java.awt.event.ItemEvent e) {
    	if (e.getStateChange() == java.awt.event.ItemEvent.SELECTED)
    	{
        	name.setText("default");
        	name.enable(false);
        }
        else if (e.getStateChange() == java.awt.event.ItemEvent.DESELECTED)
        {
        	name.setText("");
        	name.enable(true);
        }
        
	}
    
    

    private void addHostMouseClicked(java.awt.event.MouseEvent evt) 
    {
    	{
    		if(vH1==null)
    		{
    			javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        		jop.showMessageDialog(null, "You must give ADD or SET rules","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        		return;
        	}
    			
    		if(name.getText().compareToIgnoreCase(new String(""))==0)
    		{
    			javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        		jop.showMessageDialog(null, "You must give a template name","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        		return;
        	}
        	
        	if(ipAddress.getText().compareToIgnoreCase(new String("255.255.255.255"))==0 || ipAddress.getText().compareToIgnoreCase(new String(""))==0)
    		{
    			javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        		jop.showMessageDialog(null, "You must give a correct IP Address","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        		return;
        	}
        	
        	StringTokenizer st=new StringTokenizer(ipAddress.getText(),".");
        	if(st.countTokens()!=4)
        	{
        		javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        		jop.showMessageDialog(null, "You must give a correct IP Address","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        		return;
        	}
        	
        	while(st.hasMoreTokens())
        	{
        		try
        		{
        			Integer.parseInt(st.nextToken());
        			
        		}
        		catch(NumberFormatException e)
        		{
        			javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        			jop.showMessageDialog(null, "You must give a correct IP Address","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        			return;
        		}
        	}
        	
        	
        	if(vH1!=null)
        	{
        		if(parent!=null)
        		{
        			vH1.setIP(this.ipAddress.getText());
        			parent.addVirtHost(vH1);
        			this.dispose();
        		}
        	}
     	}

    }

    private void showPropMouseClicked(java.awt.event.MouseEvent evt) {
        // Add your handling code here:
    }
    
	private void setPropMouseClicked(java.awt.event.MouseEvent evt) {}
	
	private void addPropItemStateChanged(java.awt.event.ItemEvent evt)
	{
		if(((String)addProp.getSelectedItem()).compareTo(new String("cmd-string"))==0)
		{
			addCmd.show(true);
			jLabel9.show(true);
			repaint();
			
		}
		else if(((String)addProp.getSelectedItem()).compareTo(new String("proxy"))==0)
		{
			addCmd.show(true);
			jLabel9.show(true);
			repaint();
		}
		else
		{
			addCmd.show(false);
			jLabel9.show(false);
			repaint();
		}
	
	}
	
	private void setActionItemStateChanged(java.awt.event.ItemEvent evt)
	{
		if(((String)setAction.getSelectedItem()).compareTo(new String("cmd-string"))==0)
		{
			setCmd1.show(true);
			jLabel8.show(true);
			repaint();
			
		}
		else if(((String)setAction.getSelectedItem()).compareTo(new String("proxy"))==0)
		{
			setCmd1.show(true);
			jLabel8.show(true);
			repaint();
		}
		else
		{
			setCmd1.show(false);
			jLabel8.show(false);
			repaint();
		}
	}
	
	private void setPropItemStateChanged(java.awt.event.ItemEvent evt){
        if(((String)setProp.getSelectedItem()).compareTo(new String("default"))==0)
        {
        	jLabel11.show(true);
        	setProto.show(true);
        	setCmd1.show(true);
        	personality.show(false);
        	setCmd2.show(false);
        	jLabel8.setText("Action:");
        	jLabel12.show(false);
        	jLabel13.show(true);
        	setAction.show(true);
        	repaint();
        	
        }
        else if(((String)setProp.getSelectedItem()).compareTo(new String("personality"))==0)
        {
        	jLabel11.show(false);
        	setProto.show(false);
        	setCmd1.show(false);
        	personality.show(true);
        	setCmd2.show(false);
        	jLabel8.setText("Name:");
        	jLabel12.show(false);
        	jLabel13.show(false);
        	setAction.show(false);
        	repaint();
        	
        }
        else if(((String)setProp.getSelectedItem()).compareTo(new String("personality random"))==0)
        {
        	jLabel11.show(false);
        	setProto.show(false);
        	setCmd1.show(false);
        	setCmd2.show(false);
        	jLabel8.setText("Name:");
        	jLabel8.show(false);
        	jLabel12.show(false);
        	personality.show(false);
        	jLabel13.show(false);
        	setAction.show(false);
        	repaint();
        	
        }
        else if(((String)setProp.getSelectedItem()).compareTo(new String("subsystem"))==0)
        {
        	jLabel11.show(false);
        	setProto.show(false);
        	setCmd1.show(true);
        	setCmd2.show(false);
        	jLabel8.setText("Cmd:");
        	personality.show(false);
        	jLabel8.show(true);
        	jLabel12.show(false);
        	jLabel13.show(false);
        	setAction.show(false);
        	repaint();;
        	
        }
        else if(((String)setProp.getSelectedItem()).compareTo(new String("uptime"))==0)
        {
        	jLabel11.show(false);
        	setProto.show(false);
        	personality.show(false);
        	setCmd1.show(true);
        	setCmd2.show(false);
        	jLabel8.setText("Second:");
        	jLabel12.show(false);
        	jLabel13.show(false);
        	setAction.show(false);
        	repaint();
        	
        }
	    else if(((String)setProp.getSelectedItem()).compareTo(new String("droprate in"))==0)
        {
        	jLabel11.show(false);
        	setProto.show(false);
        	setCmd1.show(true);
        	personality.show(false);
        	setCmd2.show(false);
        	jLabel8.setText("Percent:");
        	jLabel12.show(false);
        	jLabel13.show(false);
        	setAction.show(false);
        	repaint();
        	
        }
        else if(((String)setProp.getSelectedItem()).compareTo(new String("uid gid"))==0)
        {
        	jLabel11.show(false);
        	setProto.show(false);
        	setCmd1.show(true);
        	setCmd2.show(true);
        	jLabel8.setText("uid:");
        	jLabel12.setText("gid:");
        	jLabel12.show(true);
        	personality.show(false);
        	jLabel13.show(false);
        	setAction.show(false);
        	repaint();
        	
        }
        else if(((String)setProp.getSelectedItem()).compareTo(new String("ip-uptime"))==0)
        {
        	jLabel11.show(false);
        	setProto.show(false);
        	setCmd1.show(true);
        	setCmd2.show(false);
        	personality.show(false);
        	jLabel8.setText("Second:");
        	jLabel12.setText("gid:");
        	jLabel12.show(false);
        	jLabel13.show(false);
        	setAction.show(false);
        	repaint();
        	
        }
    }
    
    private void setMouseClicked(java.awt.event.MouseEvent evt) {
        if(vH1==null)
        {
        	if( name.getText().compareTo(new String(""))==0)
        	{
        		javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        		jop.showMessageDialog(null, "You dont have set the template name","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        		return;
        	}
        	
        	vH1= new VirtualHostVisual(name.getText());
        	if(((String)setProp.getSelectedItem()).compareToIgnoreCase(new String("personality"))==0)
        	{
        		vH1.addSetProps(new SetProp((String)setProp.getSelectedItem(),(String)setProto.getSelectedItem(),(String)personality.getSelectedItem(),setCmd2.getText()));
        	}
        	else
        	{
        		vH1.addSetProps(new SetProp((String)setProp.getSelectedItem(),(String)setProto.getSelectedItem(),setCmd1.getText(),setCmd2.getText()));
        	}
        }
        else
        {
        	if(((String)setProp.getSelectedItem()).compareToIgnoreCase(new String("personality"))==0)
        	{
        		vH1.addSetProps(new SetProp((String)setProp.getSelectedItem(),(String)setProto.getSelectedItem(),(String)personality.getSelectedItem(),setCmd2.getText()));
        	}
        	else
        	{
        		vH1.addSetProps(new SetProp((String)setProp.getSelectedItem(),(String)setProto.getSelectedItem(),setCmd1.getText(),setCmd2.getText()));
        	}
        }
    }

    private void addMouseClicked(java.awt.event.MouseEvent evt) {
        if(vH1==null)
        {
        	if( name.getText().compareTo(new String(""))==0)
        	{
        		javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        		jop.showMessageDialog(null, "You dont have set the template name","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        		return;
        	}
        	
        	vH1= new VirtualHostVisual(name.getText());
        	vH1.addAddProps(new AddProp((String)proto.getSelectedItem(),portNum.getText(),(String)addProp.getSelectedItem(),addCmd.getText()));
        }
        else
        {
        	vH1.addAddProps(new AddProp((String)proto.getSelectedItem(),portNum.getText(),(String)addProp.getSelectedItem(),addCmd.getText()));
        }
        
    }

    private void showPropActionPerformed(java.awt.event.ActionEvent evt) {
    	if(vH1==null)
    	{
    		javax.swing.JOptionPane jop = new javax.swing.JOptionPane();
        	jop.showMessageDialog(null, "You dont have set any rules","Error", javax.swing.JOptionPane.ERROR_MESSAGE);
        	return;
    	}
        new PropertyList(vH1,false).show(true);
        
    }

    private void formWindowOpened(java.awt.event.WindowEvent evt) {

    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
       // System.exit(0);
       dispose();
    }

    
    //GUI component
    // Variables declaration - do not modify
    private javax.swing.JCheckBox optDefault;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField portNum;
    private javax.swing.JComboBox setProto;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JTextField addCmd;
    private javax.swing.JComboBox setAction;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JButton showProp;
    private javax.swing.JTextField name;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JButton cancel;
    private javax.swing.JButton addHost;
    private javax.swing.JTextField setCmd1;
    private javax.swing.JButton add;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JTextField ipAddress;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JTextField setCmd2;
    private javax.swing.JComboBox addProp;
    private javax.swing.JComboBox proto;
    private javax.swing.JButton set;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JComboBox setProp;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JComboBox personality;
    // End of variables declaration
    //data
    private VirtualHostVisual vH1;
    private PropertyList pList;
    private HostNetConf parent;
    private ParseFingerprint pf;
    private FileName fName;
}
