/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 *GUI used to the path and filename configuration
 *
 */
 
public class FilePathSetup extends javax.swing.JFrame {
    
    /** Creates new form FilePathSetup */
    public FilePathSetup() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
	 */
	 
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        confFileName = new javax.swing.JTextField();
        fPrintFileName = new javax.swing.JTextField();
        ok = new javax.swing.JButton();
        cancel = new javax.swing.JButton();
        jLabel4 = new javax.swing.JLabel();
        execPath = new javax.swing.JTextField();
	
		fName=new FileName();
        getContentPane().setLayout(null);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 1, 18));
        jLabel1.setText("File & Path setup");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(10, 10, 230, 20);

        getContentPane().add(jSeparator1);
        jSeparator1.setBounds(10, 40, 500, 2);

        jLabel2.setText("Configuration file Path & Name:");
        getContentPane().add(jLabel2);
        jLabel2.setBounds(10, 60, 220, 16);

        jLabel3.setText("Fingerprint file Path & Name:");
        getContentPane().add(jLabel3);
        jLabel3.setBounds(10, 100, 220, 16);

        confFileName.setText("/root/honeyd.conf");
        getContentPane().add(confFileName);
        confFileName.setBounds(230, 60, 290, 20);

        fPrintFileName.setText("/usr/share/nmap/nmap-os-fingerprints");
        getContentPane().add(fPrintFileName);
        fPrintFileName.setBounds(230, 100, 290, 20);

        ok.setText("OK");
        ok.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okActionPerformed(evt);
            }
        });

        getContentPane().add(ok);
        ok.setBounds(330, 190, 80, 26);

        cancel.setText("Cancel");
        cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelActionPerformed(evt);
            }
        });

        getContentPane().add(cancel);
        cancel.setBounds(420, 190, 90, 26);

        jLabel4.setText("honeyd exec path:");
        getContentPane().add(jLabel4);
        jLabel4.setBounds(10, 140, 140, 16);

        execPath.setText("/usr/local/bin/honeyd");
        getContentPane().add(execPath);
        execPath.setBounds(230, 140, 290, 20);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(550, 265));
        setLocation((screenSize.width-550)/2,(screenSize.height-265)/2);
    }

    private void cancelActionPerformed(java.awt.event.ActionEvent evt) {
       dispose();
    }

    private void okActionPerformed(java.awt.event.ActionEvent evt) {
        fName.setConfigFile(this.confFileName.getText());
        fName.setFingerFile(this.fPrintFileName.getText());
        fName.setExecPath(this.execPath.getText());
        dispose();
    }
    
    private void exitForm(java.awt.event.WindowEvent evt) {
        dispose();
    }
	//GUI component
    // Variables declaration - do not modify
    private javax.swing.JLabel jLabel4;
    private javax.swing.JButton ok;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JButton cancel;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField fPrintFileName;
    private javax.swing.JTextField execPath;
    private javax.swing.JTextField confFileName;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration
    
    //data
    private FileName fName;
}
