/*
 * Copyright 2003 Thomas KIEFFER <tomkif@hotmail.lu>
 * All rights reserved.
 *
 * Copyright 2003 CSRRT-LU (http://www.csrrt.org.lu)
 * All right reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*
 *class used to write the config file 
 *with extracting the data from  a VistualHostNetwork
 */
 
import java.io.*;
import java.util.*;



public class ConfigFile
{
	
	private VirtualHostNetwork virtHost;
	private FileName fName;
	
	/**********************************************/
	/*********Constructor**************************/
	public ConfigFile()
	{
		fName=new FileName();
	}

	
	public ConfigFile(VirtualHostNetwork vhn)
	{
		virtHost=vhn;
		fName=new FileName();
	}
	
	/***********************************************/
	/********Internal operation*********************/
	public void setVirtualHostNetwork(VirtualHostNetwork vh)
	{
		virtHost=vh;
	}

	public String getFileName()
	{
		return fName.getConfigFile();
		
	}
	
	//extract all property from a virtual host network to 
	//write the config file
	private void extract(FileWriter fw) throws IOException
	{
		for(int i=0;i<virtHost.getNbHost();i++)
		{
			if(virtHost.getVirtualHost(i).getName().compareTo(virtHost.getVirtualHost(i).getIP())==0)
				continue;
				
			fw.write("create "+virtHost.getVirtualHost(i).getName()+"\n");
			for(int j=0;j<virtHost.getVirtualHost(i).nbrAddRules();j++)
			{
				fw.write(virtHost.getVirtualHost(i).extractAddRules(j)+"\n");
			}
			for(int j=0;j<virtHost.getVirtualHost(i).nbrAddRules();j++)
			{
				fw.write(virtHost.getVirtualHost(i).extractSetRules(j)+"\n");
			}
			fw.write(virtHost.getVirtualHost(i).bind());
		}
		for(int i=0;i<virtHost.getNbNetwork();i++)
		{
			fw.write(virtHost.getNetwork(i).extract()+"\n");
		}
	}
	
	//public access to the save action
	public void save() throws IOException
	{
		FileWriter fw=new FileWriter(fName.getConfigFile());
		extract(fw);
		fw.close();
	}
}

	
