<?php

require('parser_functions.inc');
require('paramClass.inc');
require('constants.inc');
include('arrayDebug.inc');

$ERROR_PRINT = false;
$form_values = array();
$form_errors= array();

/* Extract requested program type */
$dataSource = "_".$SUBMIT_METHOD;
$dataArray = $$dataSource;
if($dataArray['grid_webface_submit'])
{
	$searchProg=trim($dataArray['prog']);
	$formSubmitted = true;
}
else
{
	$searchProg=trim($_GET['prog']);
	$formSubmitted = false;
}

if(!$searchProg)
{
	/* If we weren't passed a program type, state this and then error */
?>
<br>No program type selected. Aborting.
<?php
	return;
}

$paramFileName = getParamFileName($searchProg);

$paramfile = file($paramFileName);
$USE_TABLES = true;

$optionArray = collectOptions($paramfile);
$mainArray = getMain($optionArray);
$mainArray['nick'] = $searchProg;

$USE_TABLES = intval($mainArray['useTables']);

$RSLNamesArray = array();
$paramArray = array();
for($line = 0; $line < sizeof($optionArray); $line++)
{
	$tempParam = new paramClass;
	$success = $tempParam->load($optionArray[$line]);
	if($success === true)
	{

		$RSL_name = $tempParam->RSL_name;
		$RSLNamesArray[] = $RSL_name;
		$paramArray[$RSL_name] = $tempParam;
	}
	else
	{
		if($success !== false)
		{
			echo "<br>".$success;
		}
	}
}


if($mainArray['html_head'])
{
	if($mainArray['html_head'][0] == "/")
	{
		include($mainArray['html_head']);
	}
	else
	{
		include($WEB_PREFIX."/".$mainArray['html_head']);
	}
}
else
{
	include($WEB_PREFIX."/".$DEFAULT_HTML_HEAD);
}

if($formSubmitted)
{
	processForm($RSLNamesArray, $paramArray, $mainArray);
}
else
{
	$dummy = array();
	$ERROR_PRINT = false;
	printForm($RSLNamesArray, $paramArray, $searchProg, $dummy, $dummy);
}

if($mainArray['html_foot'])
{
	if($mainArray['html_foot'][0] == "/") 
	{
		include($mainArray['html_foot']);
	}
	else
	{
		include($WEB_PREFIX."/".$mainArray['html_foot']);
	}
}
else
{
	include($WEB_PREFIX."/".$DEFAULT_HTML_FOOT);
}
?>
