<?php

function collectOptions($file)
{
	include('constants.inc');
	
	$optionCount = 0;
	$optionArray = array();
	
	for($row = 0; $row<sizeof($file); $row++)
	{
		$file[$row]=trim($file[$row]);
		$line = $file[$row];
		if(strtoupper(substr($line,0,strlen($OPTION_HEADER))) == strtoupper($OPTION_HEADER) ||
		strtoupper(substr($line,0,strlen($MAIN_HEADER))) == strtoupper($MAIN_HEADER))
		{
			$optionCount++;
		}
	}
	
	
	$fileRow = 0;
	
	while((strtoupper(substr($file[$fileRow],0,strlen($OPTION_HEADER))) != strtoupper($OPTION_HEADER) &&
		strtoupper(substr($file[$fileRow],0,strlen($MAIN_HEADER))) != strtoupper($MAIN_HEADER)) && $fileRow < sizeof($file))
	{
		$fileRow++;
	}
	
	for($row=0; $row < $optionCount; $row++)
	{
		$optionArray[$row] = $file[$fileRow];
		$fileRow++;
		while((strtoupper(substr($file[$fileRow],0,strlen($OPTION_HEADER))) != strtoupper($OPTION_HEADER) &&
		strtoupper(substr($file[$fileRow],0,strlen($MAIN_HEADER))) != strtoupper($MAIN_HEADER)) && $fileRow < sizeof($file))
		{
			$optionArray[$row] = $optionArray[$row].$file[$fileRow];
			$fileRow++;
		}
	}

	return $optionArray;
}


function printForm($RSLNamesArray, $paramArray, $prog, $form_errors, $form_values)
{
	include('constants.inc');
	/*include('arrayDebug.inc');*/
	

	global $USE_TABLES;
	global $ERROR_PRINT;

	?>
<form method=<?php echo $SUBMIT_METHOD;?> action=<?php echo $_SERVER['PHP_SELF'];?>>
<?php

	if($USE_TABLES)
	{
    	?>
<table class=form_table>
<?php
	}

	for($option = 0; $option < sizeof($RSLNamesArray); $option++)
	{
    	$paramArray[$RSLNamesArray[$option]]->printParam($form_errors, $form_values);
    	/* $paramArray[$RSLNamesArray[$option]]->rawPrint(); */
	}
	if($USE_TABLES)
	{
    	?>
</table>
<?php
	}



	?>

<input type=hidden name=prog value=<?php echo $prog;?>>
<br>
<input type=submit name=grid_webface_submit value=Submit><input type=reset>
</form>
<?php
	
	return;
}


function getParamFileName($nickname)
{
	include('constants.inc');
	/* Open the program-file and search for the specified program */
	$programFile=file("program-file.conf");
	$foundProg=0;
	$lineNo=0;
	
	while($foundProg == 0 && $fileLine = $programFile[$lineNo])
	{
    	$lineArray = explode(":", $fileLine);
    	if(trim($lineArray[0]) == $nickname)
        	$foundProg = 1;
    	$lineNo++;
	}
	
	/* If we didn't find the specified program entry, then state this and abort */
	if($foundProg == 0)
	{
    	?>
	Requested program not found in the listings. Aborting.
	<?php
    	return false;
	}
	else
	{
		return $PARAM_PREFIX."/".trim($lineArray[1]);
	}
}


function getMain($fileArray)
{
	include('constants.inc');

	$foundLine = false;

	for($line=0; $line < sizeof($fileArray); $line++)
	{
		if(substr($fileArray[$line], 0, strlen($MAIN_HEADER)) == $MAIN_HEADER)
		{
			$foundLine = $fileArray[$line];
			$line = sizeof($fileArray);
		}
	}

	if($foundLine !== false)
	{
		$mainLine = substr($foundLine, strlen($MAIN_HEADER) + 1);
		$mainLine = substr($mainLine, 0, strlen($mainLine) - 1);

		$tempArray = explode(";", $mainLine);
		$mainArray = array();

		for($x = 0; $x < sizeof($tempArray); $x++)
		{
			$key = trim(substr($tempArray[$x], 0, strpos($tempArray[$x], "=")));
			$value = trim(substr($tempArray[$x],strpos($tempArray[$x], "=") + 1));
			$mainArray[$key] = $value;
		}
			
	}

	return $mainArray;
}


function processForm($RSLNames, $parameterObjects, $mainArray)
{
	global $ERROR_PRINT;

	global $form_values;
	global $form_errors;

	$errors = 0;

	for($x = 0; $x < sizeof($RSLNames); $x++)
	{
		$parameterObjects[$RSLNames[$x]]->process($form_values, $form_errors);

		if($form_errors[$RSLNames[$x]])
		{
			$errors++;
			echo "<br>Error in:".$RSLNames[$x];
		}
	}

	if($errors > 0)
	{
		$ERROR_PRINT = true;
		printForm($RSLNames, $parameterObjects, $mainArray['nick'], $form_errors, $form_values);
		$results = false;
	}
	else
	{
		$optionStrings = array();
		$optionStrings[] = packStrings($RSLNames, $parameterObjects, $mainArray['node1_options'], 1);
		if(intval($mainArray['nodes']) == 2)
		{
			$optionStrings[] = packStrings($RSLNames, $parameterObjects, $mainArray['node2_options'], 2);
		}  
	
		$rsl = compileRSL($RSLNames, $parameterObjects, $mainArray, $optionStrings);

		if($rsl === false)
		{
			echo "<br>RSL compilation failed.  Lacking required parameters.";
		}
		else
		{
			$results = passRSL($rsl);
		}
	}

	return $results;
}



function packStrings($RSLNames, $parameterObjects, $ostring, $node)
{
	$parseArray = array();
	$optString = "";

	$firstPos = findFirst($ostring, $RSLNames);
	
	while($firstPos !== false)
	{
		$parseArray[] = substr($ostring, 0, strpos($ostring, $RSLNames[$firstPos]) - 1);
		$parseArray[] = $RSLNames[$firstPos];
		$ostring = substr($ostring, strpos($ostring, $RSLNames[$firstPos])+strlen($RSLNames[$firstPos])+1);
		$firstPos = findFirst($ostring, $RSLNames);
	}

	$parseArray[] = $ostring;

	for($x = 1; $x < sizeof($parseArray); $x += 2)
	{
		if($node == 1)
		{
			$parseArray[$x] = $parameterObjects[$parseArray[$x]]->optionValue;
		}
		else
		{
			$parseArray[$x] = $parameterObjects[$parseArray[$x]]->optionValue2;
		}
	}

	for($x = 0; $x < sizeof($parseArray); $x++)
	{
		$optString = $optString.$parseArray[$x];
	}

	return $optString;
}


function findFirst($optString, $rslNames)
{
	/* echo "<br>Searching in string:".$optString.":"; */
	$currentFirst = strlen($optString);
	$firstIndex = 0;
	$foundSomething = false;

	for($x = 0; $x < sizeof($rslNames); $x++)
	{
		$place = strpos($optString, $rslNames[$x]);
		if($place !== false)
		{
			if($place < $currentFirst)
			{
				$currentFirst = $place;
				$firstIndex = $x;
			}
			$foundSomething = true;
		}
	}
	
	if($foundSomething && $optString)
	{
		return $firstIndex;
	}
	else
	{
		return false;
	}
}

	

function compileRSL($RSLNames, $parameterObjects, $mainArray, $oStrings)
{
	if(	isset($parameterObjects['reservation-type'])
	&&	isset($parameterObjects['bandwidth'])
	&&	isset($parameterObjects['protocol'])
	&&	isset($parameterObjects['duration'])
	&&	isset($parameterObjects['start-time'])
	&&	isset($parameterObjects['port'])
	&&	isset($parameterObjects['endpoint-a'])
	&&	isset($parameterObjects['request-type'])
	&&	(intval($mainArray['nodes']) == 1
	  || isset($parameterObjects['endpoint-b'])))
	{
		include('constants.inc');
	
		global $dataArray;

		$rsl = "&";
	
		$rsl = $rsl."(reservation-type=".$parameterObjects['reservation-type']->RSL_value.")";
		$rsl = $rsl." (protocol=".$parameterObjects['protocol']->RSL_value.")";
		$rsl = $rsl." (endpoint-a=".$parameterObjects['endpoint-a']->RSL_value.")";
		if(isset($parameterObjects['endpoint-b']))
		{
			$rsl = $rsl." (endpoint-b=".$parameterObjects['endpoint-b']->RSL_value.")";
		}
	
		$rsl = $rsl." (port=".$parameterObjects['port']->RSL_value.")";
		$rsl = $rsl." (start-time=".$parameterObjects['start-time']->RSL_value.")";
		$rsl = $rsl." (duration=".$parameterObjects['duration']->RSL_value.")";
		$rsl = $rsl." (bandwidth=".$parameterObjects['bandwidth']->RSL_value.")";
	
		$subrsl = "";
	
		for($x = 0; $x < sizeof($RSLNames); $x++)
		{
			$subrsl = $subrsl." (".$RSLNames[$x]."=".$parameterObjects[$RSLNames[$x]]->RSL_value.")";
		}
	
		$subrsl = substr($subrsl,1);
		$subrsl = $subrsl." (option-string-a=".$oStrings[0].")";
		if(intval($mainArray['nodes']) == 2)
		{
			$subrsl = $subrsl." (option-string-b=".$oStrings[1].")";
		}

		$subrsl = $subrsl." (exec-name=".$dataArray['prog'].")";
		$subrsl = "(rsl=\"&".$subrsl."\")";
	
		$rsl = $rsl." ".$subrsl;
		$rsl = "'".$rsl."' ".$parameterObjects['request-type']->RSL_value;
		
		return $rsl;
	}
	else
	{
		return false;
	}
}


function passRSL($RSL_string)
{
	include('constants.inc');

	 echo "<br>RSL:".$RSL_string; 

	$x_cert_dir=getenv("X509_CERT_DIR");
	$x_cert_file=getenv("X509_CERT_FILE");
	$x_usr_cert=getenv("X509_USER_CERT");
	$x_usr_key=getenv("X509_USER_KEY");
	$x_usr_proxy=getenv("X509_USER_PROXY");

	$commandstr=$RSL_string;

	$output = shell_exec("$SHELL_COMMAND $x_cert_dir $x_cert_file $x_usr_cert $x_usr_key $x_usr_proxy $commandstr");

	return $output;
}
	
