<?php

class paramClass
{
	var $RSL_name;
	var $type;
	var $description;
	var $context;
	var $value;
	var $antivalue;
	var $IVals;
	var $EVals;
	var $numVals;
	var $required;
	var $default;
	var $flag;
	var $anti_flag;
	var $flag2;
	var $anti_flag2;
	var $splitflags;
	var $format;
	var $size;
	var $allowSpaces;
	var $allowNonAlphNum;
	var $DNSLookup;
	var $epochSeconds;
	var $emptyVal;

	var $RSL_value;
	var $optionValue;
	var $optionValue2;


	function rawPrint()
	{
		?>
<br>
<pre>
Object: <?php echo $this->RSL_name;?>

Type: <?php echo $this->type;?>

Description: <?php echo $this->description;?>

Context: <?php echo $this->context;?>

Value: <?php echo $this->value;?>

Anti-value: <?php echo $this->antivalue;?>

IVals: <?php echo $this->IVals;?>

EVals: <?php echo $this->EVals;?>

numVals: <?php echo $this->numVals;?>

Required: <?php echo $this->required;?>

Default: <?php echo $this->default;?>

Flag: <?php echo $this->flag;?>

Anti_flag: <?php echo $this->anti_flag;?>

Flag2: <?php echo $this->flag2;?>

Anti_flag2: <?php echo $this->anti_flag2;?>

Splitflags: <?php echo $this->splitflags;?>

Format: <?php echo $this->format;?>

Size: <?php echo $this->size;?>

AllowSpaces: <?php echo $this->allowSpaces;?>

AllowNonAlphNum: <?php echo $this->allowNonAlphNum;?>

DNSLookup: <?php echo $this->DNSLookup;?>

EpochSeconds: <?php echo $this->epochSeconds;?>
</pre>

<br>

<?php
	
		return;
	}

	function setFormat($formatString)
	{
		include('constants.inc');

		$formatString = strtoupper($formatString);
		switch($formatString)
		{
			case $INPUT_DATATYPE_BYTE:
				$this->format = $INPUT_DATATYPE_BYTE;
				break;
			case $INPUT_DATATYPE_KBYTE:
				$this->format = $INPUT_DATATYPE_KBYTE;
				break;
			case $INPUT_DATATYPE_MBYTE:
				$this->format = $INPUT_DATATYPE_MBYTE;
				break;
			case $INPUT_DATATYPE_GBYTE:
				$this->format = $INPUT_DATATYPE_GBYTE;
				break;
			default:
				$this->format = $DEFAULT_DATA_FORMAT;
				break;
		}

		return;
	}


	function setContext($contextString)
	{
		require("constants.inc");
		
		$error = false;

		$contextString = strtoupper($contextString);

		switch($contextString)
		{
			case "BOTH":
				$this->context = $INPUT_CONTEXT_BOTH;
				break;
			case "CLIENT":
				$this->context = $INPUT_CONTEXT_CLIENT;
				break;
			case "SERVER":
				$this->context = $INPUT_CONTEXT_SERVER;
				break;
			default:
				$error = $WEBFACE_ERROR_BAD_CONTEXT.$this->RSL_name.":".$contextString;
				break;
		}

		return $error;
	}

	function setType($typeString)
	{
		require("constants.inc");

		$error = false;
		
		$typeString = strtoupper($typeString);

		switch($typeString)
		{
			case "CHECKBOX":
				$this->type = $INPUTTYPE_CHECKBOX;
				break;
			case "COMBOBOX":
				$this->type = $INPUTTYPE_COMBOBOX;
				break;
			case "TEXTBOX":
				$this->type = $INPUTTYPE_TEXTBOX;
				break;
			case "RADIO":
				$this->type = $INPUTTYPE_RADIOBUT;
				break;
			case "NUMERIC":
				$this->type = $INPUTTYPE_NUMERICBOX;
				break;
			case "IPADDR":
				$this->type = $INPUTTYPE_IP_ADDR;
				break;
			case "TIME":
				$this->type = $INPUTTYPE_TIME;
				break;
			case "DATA":
				$this->type = $INPUTTYPE_DATA;
				break;
			case "HIDDEN":
				$this->type = $INPUTTYPE_HIDDEN;
				break;
			default:
				$error = $WEBFACE_ERROR_BAD_TYPE.$typeString;
				break;
		}

		return $error;
	}
	
		

	function findOpt(&$optionArray, $findOption)
	{

		$optionValue = false;

		for($row = 0; $row < sizeof($optionArray); $row++)
		{
			if(strpos($optionArray[$row],"=") === false)
			{
				$LHS = $optionArray[$row];
				if(strtoupper($LHS) == strtoupper($findOption))
				{
					$optionValue = true;
				}
			}
			else
			{
				$LHS = trim(substr($optionArray[$row], 0, strpos($optionArray[$row], "=")));
				if(strtoupper($LHS) == strtoupper($findOption))
				{
					/* We found the option, so now swap the current cell
						with the last cell so we can pop this off the array */
					$lastCell = sizeof($optionArray) - 1;
					$tempCell = $optionArray[$lastCell];
					$optionArray[$lastCell] = $optionArray[$row];
					$optionArray[$row] = $tempCell;

					$optionString = array_pop($optionArray);

					$optionValue = trim(substr($optionString, strpos($optionString, "=") + 1));
				}
			}
		}

		return $optionValue;
	}

					
	function load($line)
	{
		/* Take a line (see array produced by collectOptions()) and load
			all parameters specified into the class object */

		/* If the line is not an option specification, then destroy this
			object and return false */

		include('constants.inc');


		if(strtoupper(substr($line,0,strlen($OPTION_HEADER))) != strtoupper($OPTION_HEADER))
		{
			$this=NULL;
			return false;
		}

		$error = false;
		

		$line = substr($line,strlen($OPTION_HEADER));
		$line = trim($line);

		$this->RSL_name = trim(substr($line, 0, strpos($line, ")")));

		$line = substr($line,strpos($line, ")") + 1);
		/* remove first bracket */
		$line = substr($line,1);
		/* remove last bracket */
		$line = substr($line,0,strlen($line) - 1);

		$lineArray = explode(";", $line);

		for($row = 0; $row < sizeof($lineArray); $row++)
			$lineArray[$row] = trim($lineArray[$row]);


		/* CRITICAL EXCLUSIVE OPTIONS */
		$paramVal = $this->findOpt($lineArray, "type");
		$error = $this->setType($paramVal);

		if($error === false)
		{
			$paramVal = $this->findOpt($lineArray, "description");
			if($paramVal === false)
			{
				$this->description = null;
			}
			else
			{
				$this->description = $paramVal;
			}
		}

		if($error === false)
		{
			$paramVal = $this->findOpt($lineArray, "context");
			$error = $this->setContext($paramVal);
		}

		if($error === false)
		{
			$splitFlags = $this->findOpt($lineArray, "splitflags");
			$flag = $this->findOpt($lineArray, "flag");
			$aflag = $this->findOpt($lineArray, "anti-flag");
			$flag2 = $this->findOpt($lineArray, "flag2");
			$aflag2 = $this->findOpt($lineArray, "anti-flag2");

			if($flag === false && $aflag === false)
			{
				$noPrimaryFlags = true;
			}
			else
			{
				$noPrimaryFlags = false;
			}

			if($flag === false && $aflag === false)
			{
				$noSecondaryFlags = true;
			}
			else
			{
				$noSecondaryFlags = false;
			}

			if(($noPrimaryFlags === true && $$splitFlags === false) ||
				($noSecondaryFlags === true && $splitFlags === true && $noPrimaryFlags === true))
			{
				$error = $WEBFACE_ERROR_NO_FLAGS_SPECIFIED;
			}
			else
			{
				if($flag !== false)
				{
					$this->flag = $flag;
				}
				else
				{
					$this->flag = "";
				}
				if($aflag !== false)
				{
					$this->anti_flag = $aflag;
				}
				else
				{
					$this->anti_flag = "";
				}
				if($splitFlags !== false)
				{
					if($flag2 !== false)
					{
						$this->flag2 = $flag2;
					}
					else
					{
						$this->flag2 = "";
					}
					if($aflag2 !== false)
					{
						$this->anti_flag2 = $aflag2;
					}
					else
					{
						$this->anti_flag2 = "";
					}
				}
				else
				{
					$this->flag2 = "";
					$this->anti_flag2 = "";
				}
			}
		}


		/* NON-CRITICAL EXCLUSIVE OPTIONS */
		if($error === false)
		{
			if($this->type != $INPUTTYPE_HIDDEN && $this->type != $INPUTTYPE_CHECKBOX)
			{
				$paramVal = $this->findOpt($lineArray, "required");
				$this->required = $paramVal;
			}
			else
			{
				$this->required = false;
			}
		

			if($this->type != $INPUTTYPE_HIDDEN)
			{
				$paramVal = $this->findOpt($lineArray, "default");
				if($paramVal === false)
				{
					$this->default = "";
				}
				else
				{
					$this->default = $paramVal;
				}
			}
			else
			{
				$this->default = "";
			}
		}


		/* CRITICAL INCLUSIVE OPTIONS */

		if($error === false)
		{
			if($this->type == $INPUTTYPE_COMBOBOX || $this->type == $INPUTTYPE_RADIOBUT)
			{
				$paramVal = $this->findOpt($lineArray, "IVals");
				if($paramVal === false)
				{
					$error = $WEBFACE_ERROR_MISSING_IVALS;
				}
				else
				{
					$this->IVals = explode(",", $paramVal);
					for($x = 0; $x < sizeof($this->IVals); $x++)
					{
						$this->IVals[$x] = trim($this->IVals[$x]);
					}
					$this->numVals = sizeof($this->IVals);
				}

				$paramVal = $this->findOpt($lineArray, "EVals");
				if($paramVal === false)
				{
					$error = $WEBFACE_ERROR_MISSING_EVALS;
				}
				else
				{
					$this->EVals = explode(",", $paramVal);
					for($x = 0; $x < sizeof($this->EVals); $x++)
					{
						$this->EVals[$x] = trim($this->EVals[$x]);
					}
				}
			}
		}

		if($error === false)
		{
			if($this->type == $INPUTTYPE_CHECKBOX || $this->type == $INPUTTYPE_HIDDEN)
			{
				$paramVal = $this->findOpt($lineArray, "value");
				if($paramVal === false)
				{
					$error = $WEBFACE_ERROR_MISSING_VALUE;
				}
				else
				{
					$this->value = $paramVal;
				}
			}
			else
			{
				$this->value = "";
			}
		}

		if($error === false)
		{
			if($this->type == $INPUTTYPE_CHECKBOX)
			{
				$paramVal = $this->findOpt($lineArray, "anti-value");
				if($paramVal === false)
				{
					$error = $WEBFACE_ERROR_MISSING_ANTIVALUE;
				}
				else
				{
					$this->antivalue = $paramVal;
				}
			}
			else
			{
				$this->antivalue = "";
			}
		}


		/* NON-CRITICAL INCLUSIVE OPTIONS */

		if($error === false)
		{
			if($this->type == $INPUTTYPE_COMBOBOX
			|| $this->type == $INPUTTYPE_TEXTBOX
			|| $this->type == $INPUTTYPE_RADIOBUT
			|| $this->type == $INPUTTYPE_NUMERICBOX
			|| $this->type == $INPUTTYPE_IP_ADDR
			|| $this->type == $INPUTTYPE_DATA)
			{
				$paramVal = $this->findOpt($lineArray, "emptyVal");
				if($paramVal === false)
				{
					$this->emptyVal = $EMPTY_FLAG;
				}
				else
				{
					$this->emptyVal = $paramVal;
				}
			}
			
			if($this->type == $INPUTTYPE_DATA)
			{
				$paramVal = $this->findOpt($lineArray, "format");
				$this->setFormat($paramVal);
			}
			else
			{
				$this->format = null;
			}


			if($this->type == $INPUTTYPE_TEXTBOX)
			{
				$size = $this->findOpt($lineArray, "size");
				$allowSpaces = $this->findOpt($lineArray, "allowspaces");
				$allowNonAlphNum = $this->findOpt($lineArray, "allownonalphnum");

				if($size === false)
				{
					$this->size = $DEFAULT_TEXTBOX_SIZE;
				}
				else
				{
					$this->size = intval($size);
				}

				$this->allowSpaces = $allowSpaces;
				$this->allowNonAlphNum = $allowNonAlphNum;
			}

			if($this->type == $INPUTTYPE_NUMERIC)
			{
				$size = $this->findOpt($lineArray, "size");
				if($size === false)
				{
					$this->size = $DEFAULT_NUMERIC_SIZE;
				}
				else
				{
					$this->size = intval($size);
				}
			}

			if($this->type == $INPUTTYPE_IP_ADDR)
			{
				$size = $this->findOpt($lineArray, "size");
				if($size === false)
				{
					$this->size = $DEFAULT_IP_SIZE;
				}
				else
				{
					$this->size = intval($size);
				}
				

				$paramVal = $this->findOpt($lineArray, "dnslookup");
				$this->DNSLookup = $paramVal;
			}
			else
			{
				$this->dnslookup = false;
			}


			if($this->type == $INPUTTYPE_TIME)
			{
				$paramVal = $this->findOpt($lineArray, "epochseconds");
				$this->epochSeconds = $paramVal;
			}

		}

		if($error == false)
		{
			return true;
		}
		else
		{
			return $error;
		}
	}



	function printParam($form_errors, $form_values)
	{
		require("constants.inc");

		global $USE_TABLES;
		global $ERROR_PRINT;

		switch($this->type)
		{
			case $INPUTTYPE_CHECKBOX:
				$this->printCheckbox();
				break;
			case $INPUTTYPE_COMBOBOX:
				$this->printCombobox();
				break;
			case $INPUTTYPE_TEXTBOX:
				$this->printTextbox();
				break;
			case $INPUTTYPE_RADIOBUT:
				$this->printRadio();
				break;
			case $INPUTTYPE_NUMERICBOX:
				$this->printNumeric();
				break;
			case $INPUTTYPE_IP_ADDR:
				$this->printIP();
				break;
			case $INPUTTYPE_TIME:
				$this->printTime();
				break;
			case $INPUTTYPE_DATA:
				$this->printData();
				break;
			case $INPUTTYPE_HIDDEN:
				$this->printHidden();
				break;
		}

		return;
	}

	function printCheckbox()
	{
		global $USE_TABLES;
		global $ERROR_PRINT;
		if($ERROR_PRINT)
		{
			global $form_values;
			global $form_errors;
		}
		
		if($USE_TABLES)
		{?>
<tr>
 <td><?php
		}
		else
		{?>
<br>
<?php
		}

		if($ERROR_PRINT && $form_errors[$this->RSL_name])
		{
			?>
<span class=option_desc_error><?php
		}
		else
		{
			?>
<span class=option_desc><?php
		}

		echo $this->description.": ";
		
		?>
</span><?php

		if($USE_TABLES)
		{
			?></td><td><?php
		}

		?><input type=checkbox name=<?php echo $this->RSL_name;?> value=<?php echo $this->value;?> <?php

		if($ERROR_PRINT)
		{
			if($form_values[$this->RSL_name] == $this->value)
			{
				echo "CHECKED";
			}
		}
		else
		{
			if($this->default == $this->value)
			{
				echo "CHECKED";
			}
		}
		?>><?php

		if($USE_TABLES)
		{
			?></td>
</tr>
<?php
		}

		return;
	}


	function printComboBox()
	{
		global $USE_TABLES;
		global $ERROR_PRINT;

		if($ERROR_PRINT)
		{
			global $form_values;
			global $form_errors;
		}

		
		if($USE_TABLES)
		{?>
<tr>
 <td><?php
		}
		else
		{
		?>
<br>
<?php
		}

		if($ERROR_PRINT && $form_errors[$this->RSL_name])
		{
			?>
<span class=option_desc_error><?php
		}
		else
		{
			?>
<span class=option_desc><?php
		}

		echo $this->description.": ";
		
		?>
</span><?php

		if($USE_TABLES)
		{
			?></td><td><?php
		}

		?><select name=<?php echo $this->RSL_name;?>>
<?php
		for($options = 0; $options < $this->numVals; $options++)
		{
			?>
	<option value=<?php echo $this->IVals[$options];
			
			if($ERROR_PRINT)
			{
				if($form_values[$this->RSL_name] == $this->IVals[$options])
				{
					echo " SELECTED";
				}
			}
			else
			{
				if($this->default == $this->IVals[$options])
				{
					echo " SELECTED";
				}
			}
			?>><?php echo $this->EVals[$options];?><?php
		}

		if($USE_TABLES)
		{
			?></td>
</tr>
<?php
		}

		return;
	}

	function printTextBox()
	{
		
		global $USE_TABLES;
		global $ERROR_PRINT;

		if($ERROR_PRINT)
		{
			global $form_values;
			global $form_errors;
		}

		
		if($USE_TABLES)
		{?>
<tr>
 <td><?php
		}
		else
		{
			?>
<br>
<?php
		}

		if($ERROR_PRINT && $form_errors[$this->RSL_name])
		{
			?>
<span class=option_desc_error><?php
		}
		else
		{
			?>
<span class=option_desc><?php
		}

		echo $this->description.": ";
		
		?>
</span><?php

		if($USE_TABLES)
		{
			?></td><td><?php
		}

		?><input type=textbox name=<?php echo $this->RSL_name;?> <?php

		if($ERROR_PRINT)
		{
			echo " value=\"".$form_values[$this->RSL_name]."\"";
		}
		else
		{
			if(strlen(trim($this->default)) > 0)
			{
				echo " value=\"".$this->default."\"";
			}

		}
			?> size=<?php echo $this->size;?>><?php

		if($USE_TABLES)
		{
			?></td>
</tr>
<?php
		}

		return;
	}


	function printRadio()
	{
		
		global $USE_TABLES;
		global $ERROR_PRINT;

		if($ERROR_PRINT)
		{
			global $form_values;
			global $form_errors;
		}

		
		if($USE_TABLES)
		{?>
<tr>
 <td valign=top><?php
		}
		else
		{
			?>
<br>
<?php
		}

		if($ERROR_PRINT && $form_errors[$this->RSL_name])
		{
			?>
<span class=option_desc_error><?php
		}
		else
		{
			?>
<span class=option_desc><?php
		}

		echo $this->description.": ";
		
		?>
</span><?php

		if($USE_TABLES)
		{
			?></td><td>
<?php
		}

		?>
<table>
<?php
		for($options = 0; $options < $this->numVals; $options++)
		{
			?><tr><td>
	<input type=radio name=<?php echo $this->RSL_name;?> value=<?php echo $this->IVals[$options];
			
			if($ERROR_PRINT)
			{
				if($form_values[$this->RSL_name] == $this->IVals[$options])
				{
					echo " CHECKED";
				}
			}
			else
			{
				if($this->default == $this->IVals[$options])
				{
					echo " CHECKED";
				}
			}
			?>></td>
			<td><?php echo $this->EVals[$options];?></td>
			</tr>
			<?php
		}
		?>	
</table>
<?php

		if($USE_TABLES)
		{
			?></td>
</tr>
<?php
		}

		return;
	}

	function printNumeric()
	{
		$this->printTextbox();
		return;
	}

	function printIP()
	{
		$this->printTextbox();
		return;
	}

	function printTime()
	{
		global $USE_TABLES;
		global $ERROR_PRINT;

		if($ERROR_PRINT)
		{
			global $form_values;
			global $form_errors;
		}

		
		if($USE_TABLES)
		{?>
<tr>
 <td><?php
		}
		else
		{
			?>
<br>
<?php
		}

		if($ERROR_PRINT && $form_errors[$this->RSL_name])
		{
			?>
<span class=option_desc_error><?php
		}
		else
		{
			?>
<span class=option_desc><?php
		}

		echo $this->description.": ";
		
		?>
</span><?php

		if($USE_TABLES)
		{
			?></td><td>
<?php
		}


		$today=getdate();
		$months = array("January","February","March","April","May","June","July","August","September","October","November","December");
		$years = array(strval($today['year']), strval($today['year'] + 1));
		$days = array();
		for($x=1; $x <=31; $x++)
		{
			$days[]=$x;
		}
		
		?>
  <select name=<?php echo $this->RSL_name; ?>_m>
<?php
		for($x = 0; $x < sizeof($months); $x++)
		{
?>
   <option value=<?php echo $months[$x];
		if($ERROR_PRINT)
		{
			if($months[$x] == trim($form_values[($this->RSL_name)."_m"]))
			{
				echo " SELECTED";
			}
		}
		else
		{
			if($today['month'] == $months[$x])
			{
				echo " SELECTED";
			}
		}
		?>><?php echo $months[$x];?>

<?php
		}

		?>
  </select>

  <select name=<?php echo $this->RSL_name; ?>_d>
<?php
		for($x = 0; $x < sizeof($days); $x++)
		{

			?>
   <option value=<?php echo $days[$x];
			if($ERROR_PRINT)
			{
				if($days[$x] == $form_values[($this->RSL_name)."_d"])
				{
					echo " SELECTED";
				}
			}
			else
			{
				if($today['mday'] == $days[$x])
				{
					echo " SELECTED";
				}
			}
			?>><?php echo $days[$x];?>

<?php
		}

?>
  </select>

  <select name=<?php echo $this->RSL_name; ?>_y>
<?php
		for($x = 0; $x < sizeof($years); $x++)
		{
			?>
   <option value=<?php echo $years[$x];
			if($ERROR_PRINT)
			{
				if($years[$x] == $form_values[($this->RSL_name)."_y"])
				{
					echo " SELECTED";
				}
			}
			else
			{
				if($today['year'] == $years[$x])
				{
					echo " SELECTED";
				}
			}
			?>><?php echo $years[$x];?>

<?php
		}
?>
  </select>
<?php

		?>
  <input type=textbox name=<?php echo $this->RSL_name; ?>_h size=2 value="<?php 
		if($ERROR_PRINT)
		{
			echo $form_values[($this->RSL_name)."_h"];
		}
		else
		{
			echo strval($today['hours']);
		}
		?>">  :
  <input type=textbox name=<?php echo $this->RSL_name; ?>_mn size=2 value="<?php
		if($ERROR_PRINT)
		{
			echo $form_values[($this->RSL_name)."_mn"];
		}
		else
		{
			echo strval($today['minutes']);
		}
		?>">  :
  <input type=textbox name=<?php echo $this->RSL_name; ?>_s size=2 value="<?php 
		if($ERROR_PRINT)
		{
			echo $form_values[($this->RSL_name)."_s"];
		}
		else
		{
			echo strval($today['seconds']);
		}
		?>">
<?php
		return;
	}

	function printData()
	{
		include('constants.inc');

		global $USE_TABLES;
		global $ERROR_PRINT;

		if($ERROR_PRINT)
		{
			global $form_values;
			global $form_errors;
		}

		
		if($USE_TABLES)
		{?>
<tr>
 <td><?php
		}
		else
		{
			?>
<br>
<?php
		}

		if($ERROR_PRINT && $form_errors[$this->RSL_name])
		{
			?>
<span class=option_desc_error><?php
		}
		else
		{
			?>
<span class=option_desc><?php
		}

		echo $this->description.": ";
		
		?>
</span><?php

		if($USE_TABLES)
		{
			?></td><td>
<?php
		}

		?><input type=textbox name=<?php echo $this->RSL_name;?>_n <?php

		if($ERROR_PRINT)
		{
			echo " value=\"".$form_values[($this->RSL_name)."_n"]."\"";
		}
		else
		{
			if(strlen(trim($this->default)) > 0)
			{
				echo " value=\"".$this->default."\"";
			}

		}
			?> size=<?php echo $this->size;?>><select name=<?php echo $this->RSL_name;?>_s><?php

		$Edtypes = array("Bytes", "KBytes", "MBytes", "GBytes");
		$Idtypes = array($INPUT_DATATYPE_BYTE, $INPUT_DATATYPE_KBYTE, $INPUT_DATATYPE_MBYTE, $INPUT_DATATYPE_GBYTE);

		for($x = 0; $x < sizeof($Idtypes); $x++)
		{
			?>

<option value=<?php echo $Idtypes[$x];

			if($ERROR_PRINT)
			{
				if($Idtypes[$x]==$form_values[($this->RSL_name)."_s"])
				{
					echo " SELECTED";
				}
			}
			else
			{
				if($Idtypes[$x]==$this->format)
				{
					echo " SELECTED";
				}
			}
			?>><?php echo $Edtypes[$x];
		}

		?>
</select>
<?php

		if($USE_TABLES)
		{
			?></td>
</tr>
<?php
		}

		return;
	}

	function printHidden()
	{
		/* We don't print the hidden form types for security reasons.
			The values are simply passed along during processing */
		return;
	}


	function process(&$form_values, &$form_errors)
	{	
		include('constants.inc');

		switch($this->type)
		{
			case $INPUTTYPE_CHECKBOX:
				$this->processCheckbox($form_values, $form_errors);
				break;
			case $INPUTTYPE_COMBOBOX:
				$this->processCombobox($form_values, $form_errors);
				break;
			case $INPUTTYPE_TEXTBOX:
				$this->processTextbox($form_values, $form_errors);
				break;
			case $INPUTTYPE_RADIOBUT:
				$this->processRadio($form_values, $form_errors);
				break;
			case $INPUTTYPE_NUMERICBOX:
				$this->processNumeric($form_values, $form_errors);
				break;
			case $INPUTTYPE_IP_ADDR:
				$this->processIP($form_values, $form_errors);
				break;
			case $INPUTTYPE_TIME:
				$this->processTime($form_values, $form_errors);
				break;
			case $INPUTTYPE_DATA:
				$this->processData($form_values, $form_errors);
				break;
			case $INPUTTYPE_HIDDEN:
				$this->processHidden($form_values, $form_errors);
				break;
		}

		return;
	}


	function processCheckbox(&$formVal, &$formErr)
	{
		include('constants.inc');

		global $dataArray;
		
		$value = trim($dataArray[$this->RSL_name]);

		$formVal[$this->RSL_name] = $value;
		$formErr[$this->RSL_name] = false;
		
		if($value == $this->value)
		{
			$this->RSL_value = $this->value;
			$this->setFlags();
		}
		else
		{
			$this->RSL_value = $this->antivalue;
			$this->setaFlags();
		}

		return;
	}


	function processCombobox(&$formVal, &$formErr)
	{
		include('constants.inc');

		global $dataArray;

		$value = trim($dataArray[$this->RSL_name]);

		$formVal[$this->RSL_name] = $value;
		$formErr[$this->RSL_name] = false;

		$foundVal = false;

		for($x = 0; $x < $this->numVals; $x++)
		{
			if($this->IVals[$x] == $value)
			{
				$foundVal = $x;
				$x = $this->numVals;
			}
		}
		
		if($foundVal !== false)
		{
			$this->RSL_value = $this->IVals[$foundVal];
			$this->setFlags();
		}
		else
		{
			$this->RSL_value = $this->emptyVal;
			$this->setaFlags();
			if($this->required)
			{
				$formErr[$this->RSL_name] = true;
			}
		}

		return;
	}

	
	function processTextbox(&$formVal, &$formErr)
	{
		include('constants.inc');

		global $dataArray;

		$value = trim($dataArray[$this->RSL_name]);

		$formVal[$this->RSL_name] = $value;
		$formErr[$this->RSL_name] = false;

		if($value)
		{
			if(!$this->allowSpaces)
			{
				$value = str_replace(" ", "", $value);
			}
			if(!$this->allowNonAlphNum)
			{
				$value = preg_replace("/[^0-9a-z -' ']/i",'', $value);
			}
			$this->RSL_value = $value;
			$this->setFlags();
		}
		else
		{
			$this->RSL_value = $this->emptyVal;
			$this->setaFlags();
			if($this->required)
			{
				$formErr[$this->RSL_name] = true;
			}
		}

		return;
	}


	function processRadio(&$formVal, &$formErr)
	{
		$this->processCombobox($formVal);

		return;
	}


	function processNumeric(&$formVal, &$formErr)
	{
		include('constants.inc');

		global $dataArray;

		$value = trim($dataArray[$this->RSL_name]);

		$formVal[$this->RSL_name] = $value;
		$formErr[$this->RSL_name] = false;

		if($value)
		{
			$value = strVal(intVal($value));

			$this->RSL_value = $value;
			$this->setFlags();
		}
		else
		{
			$this->RSL_value = $this->emptyVal;
			$this->setaFlags();
			if($this->required)
			{
				$formErr[$this->RSL_name] = true;
			}
		}

		return;
	}


	function processIP(&$formVal, &$formErr)
	{
		include('constants.inc');

		global $dataArray;

		$value = trim($dataArray[$this->RSL_name]);

		$formVal[$this->RSL_name] = $value;
		$formErr[$this->RSL_name] = false;

		$validIP = false;

		if($value)
		{
			$ip = ip2long($value);
			$ip_r = long2ip($ip);
			if($value == $ip_r)
			{
				$validIP = $ip_r;
			}
			else
			{
				if($this->DNSLookup)
				{
					$ip=gethostbyname($value);
					if($ip != $value)
					{
						$validIP = $ip;
					}
				}
			}
		}

		if($validIP)
		{
			$this->RSL_value = $validIP;
			$this->setFlags();
		}
		else
		{
			$this->RSL_value = $this->emptyVal;
			$this->setaFlags();
			if($this->required)
			{
				$formErr[$this->RSL_name] = true;
			}
		}

		return;
	}


	function processTime(&$formVal, &$formErr)
	{
		include('constants.inc');
		
		global $dataArray;

		$day = trim($dataArray[($this->RSL_name)."_d"]);
		$month = trim($dataArray[($this->RSL_name)."_m"]);
		$year = trim($dataArray[($this->RSL_name)."_y"]);
		$hour = trim($dataArray[($this->RSL_name)."_h"]);
		$minute = trim($dataArray[($this->RSL_name)."_mn"]);
		$second = trim($dataArray[($this->RSL_name)."_s"]);

		$formVal[($this->RSL_name)."_d"] = $day;
		$formVal[($this->RSL_name)."_m"] = $month;
		$formVal[($this->RSL_name)."_y"] = $year;
		$formVal[($this->RSL_name)."_h"] = $hour;
		$formVal[($this->RSL_name)."_mn"] = $minute;
		$formVal[($this->RSL_name)."_s"] = $second;
		$formErr[$this->RSL_name] = false;

		$dateString = $day." ".$month." ".$year." ".$hour.":".$minute.":".$second;
		$time = strtotime($dateString);
		
		if($time == -1)
		{
			$this->RSL_value = localtime();
			$this->setaFlags();
			if($this->required)
			{
				$formErr[$this->RSL_name] = true;
			}
		}
		else
		{
			$this->RSL_value = $time;
			$this->setFlags();
		}

		return;
	}


	function processData(&$formVal, &$formErr)
	{
		include('constants.inc');

		global $dataArray;

		$value = trim($dataArray[($this->RSL_name)."_n"]);
		$suffix = trim($dataArray[($this->RSL_name)."_s"]);

		$formVal[($this->RSL_name)."_n"] = $value;
		$formVal[($this->RSL_name)."_s"] = $suffix;
		$formErr[$this->RSL_name] = false;

		$conversionArray = array($INPUT_DATATYPE_BYTE  => 1, 
								 $INPUT_DATATYPE_KBYTE => 1024,
								 $INPUT_DATATYPE_MBYTE => 1048576,
								 $INPUT_DATATYPE_GBYTE => 1073741824);

		if($value)
		{
			$num = strval(intval($value));
			$formatSize = $conversionArray[$this->format];
			if($suffix)
			{
				$currentSize = $conversionArray[$suffix];
			}
			else
			{
				$currentSize = $conversionArray[$INPUT_DATATYPE_BYTE];
			}

			$ratio = $currentSize / $formatSize;
			$this->RSL_value = $num * $ratio;
			$this->setFlags();
		}
		else
		{
			$this->RSL_value = $this->emptyVal;
			$this->setaFlags();
			if($this->required)
			{
				$formErr[$this->RSL_name] = true;
			}
		}

		return;
	}


	function processHidden(&$formVal, &$formErr)
	{
		include('constants.inc');

		$this->RSL_value = $this->value;
		$this->setFlags();

		return;
	}
		
	
	function setFlags()
	{
		include('constants.inc');

		$this->optionValue = "";
		$this->optionValue2 = "";

		switch($this->context)
		{
			case $INPUT_CONTEXT_BOTH:
				if($this->splitflags)
				{
					$this->optionValue = str_replace($SEARCH_STR, 
						$this->RSL_value, $this->flag);
					$this->optionValue2 = str_replace($SEARCH_STR, 
						$this->RSL_value, $this->flag2);
				}
				else
				{
					$this->optionValue = str_replace($SEARCH_STR,
						$this->RSL_value, $this->flag);
					$this->optionValue2 = str_replace($SEARCH_STR,
						$this->RSL_value, $this->flag);
				}
				break;
			case $INPUT_CONTEXT_CLIENT:
				$this->optionValue2 = str_replace($SEARCH_STR, $this->RSL_value,
					$this->flag);
				break;
			case $INPUT_CONTEXT_SERVER:
				$this->optionValue = str_replace($SEARCH_STR, $this->RSL_value,
					$this->flag);
				break;
		}

		return;
	}


	function setaFlags()
	{
		include('constants.inc');

		$this->optionValue = "";
		$this->optionValue2 = "";

		switch($this->context)
		{
			case $INPUT_CONTEXT_BOTH:
				if($this->splitflags)
				{
					$this->optionValue = str_replace($SEARCH_STR, 
						$this->RSL_value, $this->aflag);
					$this->optionValue2 = str_replace($SEARCH_STR, 
						$this->RSL_value, $this->aflag2);
				}
				else
				{
					$this->optionValue = str_replace($SEARCH_STR,
						$this->RSL_value, $this->aflag);
					$this->optionValue2 = str_replace($SEARCH_STR,
						$this->RSL_value, $this->aflag);
				}
				break;
			case $INPUT_CONTEXT_CLIENT:
				$this->optionValue2 = str_replace($SEARCH_STR, $this->RSL_value,
					$this->aflag);
				break;
			case $INPUT_CONTEXT_SERVER:
				$this->optionValue = str_replace($SEARCH_STR, $this->RSL_value,
					$this->aflag);
				break;
		}

		return;
	}

}



