#!/bin/sh

KERBEROS_ROOT=/usr/local/bin

KX509=/usr/local/bin/kx509
KXLIST=/usr/local/bin/kxlist
OPENSSL=/usr/bin/openssl

# **** Nothing should need modifying beyond this point ****

CWD=`pwd`

KDESTROY=${KERBEROS_ROOT}/kdestroy
KINIT=${KERBEROS_ROOT}/kinit
JAVA=${JAVA_HOME}/bin/java

JXPREFIX=${CWD}
jxkeys="${JXPREFIX}/jxplorer/security"
caks="${jxkeys}/cacerts"
clientks="${jxkeys}/clientcerts"
cacert="${CWD}/ca-bundle.crt"

# Shall we destroy the current cache?
if [ $# -gt 0 ]
then
	if [ "${1}" = "-d" ] 
	then
		echo "Destroying current krb cache: ${KDESTROY}"
		${KDESTROY}
		echo "Fetching kerberos tickets: ${KINIT}"
		${KINIT}
	else
		if [ "${1}" = "-i" ]
		then
			echo "Fetching kerberos tickets: ${KINIT}"
			${KINIT}
		else
			echo "Useage: keygen [-d | -i]"
			echo " -d: destroy current krb5 cache and init fresh"
			echo " -i: just init a fresh krb5 cache"
			exit 0;
		fi
	fi
	if [ $? -ne 0 ]
	then
		echo "Error in conversion. Aborting"
		exit 1
	fi
fi
		

#Convert kerberos tickets to kx509 certs
echo
echo "Converting kerberos tickets: ${KX509}"
${KX509}
if [ $? -ne 0 ]
then
	echo "Error in conversion. Aborting"
	exit 1
fi


#Convert kx509 certs to kx509 proxy certs
cmd="${KXLIST} -p"

echo
echo "Converting kx509 key: ${cmd}"
${cmd}
if [ $? -ne 0 ]
then
	echo "Error in conversion. Aborting"
	exit 1
fi

# Convert the x509 proxy key to pkcs8 format
X509_proxy_file="/tmp/x509up_u${UID-`id -u`}"

cmd="${OPENSSL} pkcs8 -in ${X509_proxy_file} -topk8 -nocrypt -out ${X509_proxy_file}.pkcs8key.pem"

echo
echo "Converting proxy key: ${cmd}"
${cmd}
if [ $? -ne 0 ]
then
	echo "Error in conversion. Aborting"
	exit 1
fi

#Hokay, so, here's the key. "Damn, that is a sweet key!" you might say. Wrong!
#We need to store things in the java keystores.

echo
echo "Loading key/cert into keystore..."
cmd="${JAVA} -jar keygen.jar ${clientks} ${X509_proxy_file} ${X509_proxy_file}.pkcs8key.pem ${cacert}"
${cmd}

exit 0
