/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBErrorWin;
import com.ca.commons.cbutil.CBFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class CBUtility {
    private static Cursor savedCursor;
    private static FileWriter logfile;
    private static int loggingStyle;
    private static int debugLevel;
    private static Frame displayFrame;
    private static final int NOLOG = 0;
    private static final int CONSOLE = 1;
    private static final int FILE = 2;
    private static final int CONSOLEANDFILE = 3;

    private CBUtility() {
    }

    public static StringBuffer readURLText(URL uRL) {
        return CBUtility.readURLText(uRL, new StringBuffer("error: can't read URL " + uRL.toString()));
    }

    public static StringBuffer readURLText(URL uRL, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer("");
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer2.append(string + "\n");
            }
            return stringBuffer2;
        }
        catch (Exception exception) {
            return stringBuffer;
        }
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        byte[] byArray2 = new byte[16384];
        int n = 0;
        int n2 = 0;
        while ((n = inputStream.read(byArray2)) != -1) {
            byte[] byArray3 = new byte[n2 + n];
            if (n2 != 0) {
                System.arraycopy(byArray, 0, byArray3, 0, n2);
            }
            System.arraycopy(byArray2, 0, byArray3, n2, n);
            byArray = byArray3;
            n2 += n;
        }
        return byArray;
    }

    public static String readTextFile(File file) throws IOException {
        if (!Locale.getDefault().getLanguage().equals("en")) {
            return CBUtility.readI18NFile(file);
        }
        FileReader fileReader = new FileReader(file);
        int n = (int)file.length();
        char[] cArray = new char[n];
        for (int i = 0; i < n; i += fileReader.read(cArray, i, n - i)) {
        }
        return new String(cArray);
    }

    public static String readI18NFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += fileInputStream.read(byArray, i, n - i)) {
        }
        return CBUtility.readI18NByteArray(byArray);
    }

    public static String readI18NByteArray(byte[] byArray) {
        try {
            if (CBUtility.isUnicode(byArray)) {
                CBUtility.log("reading unicode 16 bit text", 7);
                String string = new String(byArray, "UTF-16");
                if (string.length() > 0) {
                    return string;
                }
                return new String(byArray);
            }
            byte[] byArray2 = new byte[250];
            if (byArray.length < 250) {
                byArray2 = byArray;
            } else {
                System.arraycopy(byArray, 0, byArray2, 0, 250);
            }
            if (CBUtility.isNonAsciiUTF8(byArray2)) {
                CBUtility.log("reading utf8 text", 7);
                String string = new String(byArray, "UTF-8");
                if (string.length() > 0) {
                    return string;
                }
                return new String(byArray);
            }
            CBUtility.log("reading local encoding text", 7);
            String string = new String(byArray);
            if (string.indexOf("\\u") == -1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n + 6 < stringBuffer.length()) {
                if (stringBuffer.charAt(n) != '\\') {
                    ++n;
                    continue;
                }
                if (stringBuffer.charAt(n + 1) != 'u') {
                    n += 2;
                    continue;
                }
                String string2 = stringBuffer.substring(n + 2, n + 6);
                int n2 = Integer.parseInt(string2, 16);
                stringBuffer = stringBuffer.delete(n, n + 6);
                stringBuffer = stringBuffer.insert(n, (char)n2);
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            CBUtility.log("Confused Reading File: " + exception.toString() + "\n -> reverting to default encoding");
            return new String(byArray);
        }
    }

    public static String[] readStringArrayFile(String string) {
        Properties properties = CBUtility.readPropertyFile(string);
        String[] stringArray = new String[properties.size()];
        Enumeration<Object> enumeration = properties.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = enumeration.nextElement().toString();
        }
        return stringArray;
    }

    public static Properties readPropertyFile(String string) {
        Properties properties = new Properties();
        try {
            File file = new File(string);
            if (file == null || !file.exists()) {
                CBUtility.log("No property list:\n" + string, 1);
                return properties;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            return properties;
        }
        catch (Exception exception) {
            CBUtility.log("Can't read property list:\n" + string + "\n" + exception);
            return properties;
        }
    }

    public static void writeStringArrayFile(String string, String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            properties.put(stringArray[i], stringArray[i]);
        }
        CBUtility.writePropertyFile(string, properties, "generated string array list");
    }

    public static void writePropertyFile(String string, Properties properties, String string2) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "Generated Property List " + string + "\n" + (string2 != null ? string2 : ""));
        }
        catch (Exception exception) {
            CBUtility.log("Can't write property list:\n" + string + "\n" + exception);
        }
    }

    public static String toHTML(String string) {
        String string2 = string.length() > 14 ? string.substring(0, 14).toLowerCase() : string.toLowerCase();
        if (string2.startsWith("<html>") || string2.startsWith("<!doctype html>")) {
            if (string2.startsWith("<html>")) {
                string = string.substring(6);
            } else if (string2.startsWith("<!doctype html>")) {
                string = string.substring(15);
            }
            if (string.toLowerCase().endsWith("</html>")) {
                string = string.substring(0, string.length() - 7);
            }
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        block6: for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case '<': {
                    CBUtility.replaceChar(stringBuffer, i, "&lt;");
                    continue block6;
                }
                case '>': {
                    CBUtility.replaceChar(stringBuffer, i, "&gt;");
                    continue block6;
                }
                case '&': {
                    CBUtility.replaceChar(stringBuffer, i, "&amp;");
                    continue block6;
                }
                case '\"': {
                    CBUtility.replaceChar(stringBuffer, i, "&quot;");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static int replaceChar(StringBuffer stringBuffer, int n, String string) {
        stringBuffer.deleteCharAt(n);
        stringBuffer.insert(n, string);
        return n + string.length();
    }

    public static String replaceAllChar(StringBuffer stringBuffer, char c, String string) {
        return CBUtility.replaceAllBufferChar(stringBuffer, c, string).toString();
    }

    public static StringBuffer replaceAllBufferChar(StringBuffer stringBuffer, char c, String string) {
        int n = 0;
        while (n != -1) {
            n = stringBuffer.toString().indexOf(c, n);
            if (n == -1) continue;
            n = CBUtility.replaceChar(stringBuffer, n, string);
        }
        return stringBuffer;
    }

    public static int replaceString(StringBuffer stringBuffer, int n, int n2, String string) {
        stringBuffer.replace(n, n + n2, string);
        return n + string.length();
    }

    public static String replaceAllString(StringBuffer stringBuffer, String string, String string2) {
        return CBUtility.replaceAllBufferString(stringBuffer, string, string2).toString();
    }

    public static StringBuffer replaceAllBufferString(StringBuffer stringBuffer, String string, String string2) {
        int n = 0;
        while (n != -1) {
            n = stringBuffer.toString().indexOf(string, n);
            if (n == -1) continue;
            n = CBUtility.replaceString(stringBuffer, n, string.length(), string2);
        }
        return stringBuffer;
    }

    public static int nextCharIn(int n, String string, String string2, boolean bl) {
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (string2.indexOf(c) != -1 == bl) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static String[] readFilteredDirectory(String string, String string2) {
        String[] stringArray = new String[]{string2};
        return CBUtility.readFilteredDirectory(string, stringArray);
    }

    public static String[] readFilteredDirectory(String string, String[] stringArray) {
        String[] stringArray2 = stringArray;
        File file = new File(string);
        String[] stringArray3 = file.list((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        return stringArray3;
    }

    public static void setWaitCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setNormalCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void setHandCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(12));
    }

    public static void saveCursor(Component component) {
        savedCursor = component.getCursor();
    }

    public static void restoreCursor(Component component) {
        if (savedCursor != null) {
            component.setCursor(savedCursor);
        } else {
            CBUtility.log("can't restore cursor; no cursor saved...", 1);
        }
    }

    public static void setLogDebugLevel(int n) {
        debugLevel = n;
    }

    public static int getLogDebugLevel() {
        return debugLevel;
    }

    public static void setLogType(String string) {
        CBUtility.setLogType(string, null);
    }

    public static void setLogType(String string, String string2) {
        block9: {
            if (string.equalsIgnoreCase("none")) {
                loggingStyle = 0;
            } else if (string.equalsIgnoreCase("console")) {
                loggingStyle = 1;
            } else if (string.equalsIgnoreCase("file") || string.equalsIgnoreCase("both")) {
                String string3 = string2 == null ? "jxplorer.log" : string2;
                try {
                    logfile = new FileWriter(string3);
                    if (string.equalsIgnoreCase("both")) {
                        loggingStyle = 3;
                        break block9;
                    }
                    loggingStyle = 2;
                }
                catch (Exception exception) {
                    CBUtility.log("unable to open log file " + string3 + "\nreverting to console logging");
                    loggingStyle = 1;
                }
            } else {
                loggingStyle = 1;
            }
        }
        CBUtility.log("Logging Initialised to " + string, 1);
    }

    public static void closeLog() {
        try {
            if (logfile != null) {
                logfile.close();
            }
        }
        catch (Exception exception) {
            CBUtility.log("error shutting log file " + exception.toString());
        }
    }

    public static void log(String string, int n) {
        if (debugLevel >= n) {
            CBUtility.log(string);
        }
    }

    public static void log(String string) {
        string = new Date(System.currentTimeMillis()).toString() + ": " + string;
        switch (loggingStyle) {
            case 0: {
                break;
            }
            case 2: 
            case 3: {
                try {
                    logfile.write(string + "\n");
                    logfile.flush();
                }
                catch (Exception exception) {
                    CBUtility.log("unable to write to log file\nreverting to console\n" + exception + "\n" + string);
                    loggingStyle = 1;
                }
                if (loggingStyle == 2) break;
            }
            default: {
                System.out.println(string);
            }
        }
    }

    public static void initDefaultDisplay(Frame frame) {
        displayFrame = frame;
    }

    public static Frame getDefaultDisplay() {
        return displayFrame;
    }

    public static boolean error(Component component, String string) {
        return CBUtility.error(CBUtility.getParentFrame(component), string, null);
    }

    public static boolean error(Frame frame, String string) {
        if (displayFrame == null) {
            CBUtility.log("error display not initialised! (error was: " + string + ")", 0);
            return false;
        }
        return CBUtility.error(frame, string, null);
    }

    public static boolean error(String string) {
        if (displayFrame == null) {
            CBUtility.log("error display not initialised! (error was: " + string + ")", 0);
            return false;
        }
        return CBUtility.error(displayFrame, string, null);
    }

    public static boolean error(String string, Exception exception) {
        return CBUtility.error(displayFrame, string, exception);
    }

    public static boolean error(Component component, String string, Exception exception) {
        return CBUtility.error(CBUtility.getParentFrame(component), string, exception);
    }

    public static boolean error(Frame frame, String string, Exception exception) {
        if (frame == null) {
            if (displayFrame == null) {
                CBUtility.log("error display not initialised! (error was: " + string + ")", 0);
                return false;
            }
            frame = displayFrame;
        }
        CBErrorWin cBErrorWin = new CBErrorWin(frame, string, exception);
        CBUtility.log("error " + string + "\n" + (exception == null ? "" : exception.toString()));
        if (debugLevel > 8 && exception != null) {
            System.out.println("printing stack trace");
            exception.printStackTrace();
        }
        return false;
    }

    public static void confirm(String string) {
        if (displayFrame == null) {
            System.out.println("error display not initialised! (error was: " + string + ")");
            return;
        }
        CBErrorWin cBErrorWin = new CBErrorWin(displayFrame, string, "Confirmation Message");
    }

    public static boolean warning(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string, string2, 2);
        return false;
    }

    public static boolean warning(String string) {
        if (displayFrame == null) {
            System.out.println("warning display not initialised! (error was: " + string + ")");
            return false;
        }
        return CBUtility.warning(displayFrame, string, "Warning");
    }

    public static void printEnumeration(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = e == null ? "*null*" : e.toString();
            System.out.println("    " + string);
        }
    }

    public static Frame getParentFrame(Component component) {
        Container container;
        if (component == null) {
            return null;
        }
        for (container = component.getParent(); !(container instanceof Frame) && container != null; container = container.getParent()) {
        }
        return container == null ? null : (Frame)container;
    }

    public static String convertPathToUnix(String string) {
        String string2 = string.replace('\\', '/');
        return string2;
    }

    public static void center(Component component, Component component2) {
        if (component == null) {
            return;
        }
        if (component2 != null && component2.isShowing()) {
            Rectangle rectangle = component2.getBounds();
            Point point = component2.getLocationOnScreen();
            int n = point.x + rectangle.width / 2;
            int n2 = point.y + rectangle.height / 2;
            rectangle = component.getBounds();
            int n3 = 0;
            int n4 = 0;
            if (component.isShowing()) {
                point = component.getLocationOnScreen();
                int n5 = point.x + rectangle.width / 2;
                int n6 = point.y + rectangle.height / 2;
                int n7 = n - n5;
                int n8 = n2 - n6;
                n3 = rectangle.x + n7;
                n4 = rectangle.y + n8;
            } else {
                n3 = n - rectangle.width / 2;
                n4 = n2 - rectangle.height / 2;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (n3 - 100 < 0 || n3 + 100 > toolkit.getScreenSize().width || n4 - 100 < 0 || n4 + 100 > toolkit.getScreenSize().height) {
                CBUtility.centerOnScreen(component);
            } else {
                component.setLocation(n3, n4);
            }
        } else {
            CBUtility.centerOnScreen(component);
        }
    }

    private static void centerOnScreen(Component component) {
        Dimension dimension = component.getToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        component.setLocation((int)(dimension.getWidth() - dimension2.getWidth()) / 2, (int)(dimension.getHeight() - dimension2.getHeight()) / 2);
    }

    public static String bytes2Hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(CBUtility.byte2Hex(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String string2Hex(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            stringBuffer.append(CBUtility.char2Hex(cArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String byte2Hex(byte by) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[by >> 4 & 0xF], cArray[by & 0xF]};
        return new String(cArray2);
    }

    public static String char2Hex(char c) {
        byte by = (byte)(c >>> 8);
        byte by2 = (byte)(c & 0xFF);
        return CBUtility.byte2Hex(by) + CBUtility.byte2Hex(by2);
    }

    public static byte hex2Byte(char c, char c2) {
        byte by = CBUtility.hexChar2Byte(c);
        byte by2 = CBUtility.hexChar2Byte(c2);
        return (byte)((by << 4) + by2);
    }

    public static byte hexChar2Byte(char c) {
        if (c <= '9') {
            return (byte)(c - 48);
        }
        if (c <= 'F') {
            return (byte)(c - 55);
        }
        return (byte)(c - 87);
    }

    public static String bytes2HexSplit(byte[] byArray, int n) {
        String string = CBUtility.bytes2Hex(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(string.charAt(i));
            if ((i + 1) % n != 0) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String bytes2HexSplit(byte[] byArray, int n, int n2) {
        String string = CBUtility.bytes2Hex(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(string.charAt(i));
            if ((i + 1) % n == 0) {
                stringBuffer.append(" ");
            }
            if ((i + 1) % n2 != 0) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static boolean isUTF8(byte[] byArray) {
        boolean bl = false;
        if (bl) {
            System.out.println("\n\n Starting UTF8 Check\n\n");
        }
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (bl) {
                System.out.println("testing byte: " + CBUtility.byte2Hex(by));
            }
            if ((by >> 6 & 3) == 2) {
                if (bl) {
                    System.out.println("start byte is invalid utf8 - has 10... start");
                }
                return false;
            }
            byte by2 = by;
            int n = 0;
            while ((by2 & 0x80) > 0) {
                by2 = (byte)(by2 << 1);
                ++n;
            }
            if (n <= true) continue;
            for (int j = 1; j < n; ++j) {
                if (i + j >= byArray.length) {
                    if (bl) {
                        System.out.println("following byte length is invalid - overruns end... ");
                    }
                    return false;
                }
                if (bl) {
                    System.out.println("testing byte: " + CBUtility.byte2Hex(byArray[i + j]));
                }
                if ((byArray[i + j] >> 6 & 3) == 2) continue;
                if (bl) {
                    System.out.println("following byte is invalid utf8 - does *not* have 10... start");
                }
                return false;
            }
            i += n - 1;
        }
        return true;
    }

    public static boolean isNonAsciiUTF8(byte[] byArray) {
        CBUtility.log("testing sequence for utf8: " + CBUtility.bytes2Hex(byArray) + "\n", 8);
        boolean bl = false;
        for (int i = 0; i < byArray.length - 3; ++i) {
            byte by = byArray[i];
            if ((by >> 6 & 3) == 2) {
                return false;
            }
            byte by2 = by;
            int n = 0;
            while ((by2 & 0x80) > 0) {
                by2 = (byte)(by2 << 1);
                ++n;
            }
            if (n <= true) continue;
            bl = true;
            for (int j = 1; j < n; ++j) {
                if ((byArray[i + j] >> 6 & 3) == 2) continue;
                return false;
            }
            i += n - 1;
        }
        return bl;
    }

    public static boolean isUnicode(byte[] byArray) {
        if (byArray.length >= 2) {
            if (byArray[0] == -1 && byArray[1] == -2) {
                return true;
            }
            if (byArray[0] == -2 && byArray[1] == -1) {
                return true;
            }
        }
        return false;
    }

    public static String chooseFileToSave(Component component, String string, String[] stringArray, String string2) {
        int n;
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("PKIHOME"));
        jFileChooser.setToolTipText(string);
        jFileChooser.setDialogTitle(string);
        if (stringArray != null && string2 != null) {
            CBFileFilter cBFileFilter = new CBFileFilter(stringArray, string2);
            jFileChooser.setFileFilter(cBFileFilter);
        }
        if ((n = jFileChooser.showSaveDialog(component)) == 0 && jFileChooser.getSelectedFile() != null) {
            return jFileChooser.getSelectedFile().toString();
        }
        return null;
    }

    public static boolean okToWriteFile(Frame frame, String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(frame, string + " is a directory.", "Error!", 0);
            return false;
        }
        if (file.exists()) {
            int n = JOptionPane.showConfirmDialog(frame, "File " + string + " already exists.\nDo you want to overwrite?", "Question", 2);
            return n == 0;
        }
        return true;
    }

    static {
        loggingStyle = -1;
        debugLevel = 0;
        displayFrame = null;
    }
}

