/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBBase64;

public class CBSecurity {
    public static final byte[] PEM_BEGIN = new String("-----BEGIN").getBytes();
    public static final byte[] PEM_END = new String("-----END").getBytes();
    public static final byte[] PEM_CERT_HEADER = new String("-----BEGIN CERTIFICATE-----").getBytes();
    public static final byte[] PEM_CERT_FOOTER = new String("-----END CERTIFICATE-----").getBytes();
    public static final byte[] PEM_ENC_KEY_HEADER = new String("-----BEGIN ENCRYPTED PRIVATE KEY-----").getBytes();
    public static final byte[] PEM_KEY_HEADER = new String("-----BEGIN PRIVATE KEY-----").getBytes();
    public static final byte[] PEM_ENC_KEY_FOOTER = new String("-----END ENCRYPTED PRIVATE KEY-----").getBytes();
    public static final byte[] PEM_KEY_FOOTER = new String("-----END PRIVATE KEY-----").getBytes();
    public static final byte[] PEM_RSA_KEY_HEADER = new String("-----BEGIN RSA PRIVATE KEY-----").getBytes();
    public static final byte[] PEM_RSA_KEY_FOOTER = new String("-----END RSA PRIVATE KEY-----").getBytes();

    public static int indexOf(byte[] byArray, byte by) {
        return CBSecurity.indexOf(byArray, by, 0);
    }

    public static int indexOf(byte[] byArray, byte by, int n) {
        int n2 = byArray.length;
        if (n < 0) {
            n = 0;
        } else if (n >= n2) {
            return -1;
        }
        for (int i = n; i < n2; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        return CBSecurity.indexOf(byArray, byArray2, 0);
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        int n2 = byArray.length;
        if (n >= n2) {
            if (byArray.length == 0 && n == 0 && byArray2.length == 0) {
                return 0;
            }
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (byArray2.length == 0) {
            return n;
        }
        byte by = byArray4[0];
        int n3 = n;
        block0: while (true) {
            if (n3 < n2 && byArray3[n3] != by) {
                ++n3;
                continue;
            }
            if (n3 >= n2) {
                return -1;
            }
            int n4 = n3 + 1;
            int n5 = n4 + byArray2.length - 1;
            int n6 = 1;
            while (n4 < n5) {
                if (byArray3[n4++] == byArray4[n6++]) continue;
                ++n3;
                continue block0;
            }
            break;
        }
        return n3;
    }

    public static boolean isPEM(byte[] byArray) {
        if (CBSecurity.indexOf(byArray, PEM_BEGIN) == -1) {
            return false;
        }
        return CBSecurity.indexOf(byArray, PEM_END) != -1;
    }

    public static byte[] convertFromPEM(byte[] byArray) {
        return CBSecurity.convertFromPEM(byArray, PEM_BEGIN, PEM_END);
    }

    public static byte[] convertFromPEM(byte[] byArray, byte[] byArray2) {
        return CBSecurity.convertFromPEM(byArray, byArray2, PEM_END);
    }

    public static byte[] convertFromPEMCertificate(byte[] byArray) {
        return CBSecurity.convertFromPEM(byArray, PEM_CERT_HEADER, PEM_END);
    }

    public static byte[] convertFromPEM(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        int n2 = CBSecurity.indexOf(byArray, byArray2);
        int n3 = CBSecurity.indexOf(byArray, byArray3);
        if (n2 == -1 || n3 == -1) {
            return null;
        }
        n2 = CBSecurity.indexOf(byArray, (byte)10, n2) + 1;
        while ((n = CBSecurity.indexOf(byArray, (byte)10, n2)) < n2 + 64 && n != -1) {
            n2 = n + 1;
        }
        if (n2 == -1) {
            return null;
        }
        int n4 = n3 - n2;
        byte[] byArray4 = new byte[n4];
        System.arraycopy(byArray, n2, byArray4, 0, n4);
        return CBBase64.decode(byArray4);
    }

    public static byte[] convertToPEMCertificate(byte[] byArray) {
        return CBSecurity.convertToPEM(byArray, PEM_CERT_HEADER, PEM_CERT_FOOTER);
    }

    public static byte[] convertToPEMRSAPrivateKey(byte[] byArray) {
        return CBSecurity.convertToPEM(byArray, PEM_RSA_KEY_HEADER, PEM_RSA_KEY_FOOTER);
    }

    public static byte[] convertToPEMEncryptedPrivateKey(byte[] byArray) {
        return CBSecurity.convertToPEM(byArray, PEM_ENC_KEY_HEADER, PEM_ENC_KEY_FOOTER);
    }

    public static byte[] convertToPEMPrivateKey(byte[] byArray) {
        return CBSecurity.convertToPEM(byArray, PEM_KEY_HEADER, PEM_KEY_FOOTER);
    }

    protected static byte[] convertToPEM(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            byte[] byArray4 = CBBase64.encodeFormatted(byArray, 0, 64);
            int n = byArray2.length + 1 + byArray4.length + byArray3.length + 1;
            byte[] byArray5 = new byte[n];
            int n2 = 0;
            System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
            n2 += byArray2.length;
            byArray5[n2++] = 10;
            System.arraycopy(byArray4, 0, byArray5, n2, byArray4.length);
            System.arraycopy(byArray3, 0, byArray5, n2 += byArray4.length, byArray3.length);
            byArray5[n2 += byArray3.length] = 10;
            byArray4 = null;
            byArray = null;
            return byArray5;
        }
        catch (Exception exception) {
            System.err.println("error decoding pem file: " + exception);
            return null;
        }
    }
}

