/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBUtility;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class CBResourceBundle {
    Hashtable translations = new Hashtable();

    public CBResourceBundle(String string) {
        this.loadBundle(string, Locale.getDefault(), ClassLoader.getSystemClassLoader());
    }

    public CBResourceBundle(String string, Locale locale) {
        this.loadBundle(string, locale, ClassLoader.getSystemClassLoader());
    }

    public CBResourceBundle(String string, Locale locale, ClassLoader classLoader) {
        this.loadBundle(string, locale, classLoader);
    }

    protected void loadBundle(String string, Locale locale, ClassLoader classLoader) {
        Vector vector = CBResourceBundle.getBundleNames(string, locale);
        for (int i = vector.size() - 1; i >= 0; --i) {
            URL uRL = classLoader.getResource(vector.get(i).toString());
            if (!this.loadData(uRL)) continue;
            return;
        }
        CBUtility.log("unable to load resource bundle '" + string + "'");
    }

    protected static Vector getBundleNames(String string, Locale locale) {
        Vector<String> vector = new Vector<String>(8);
        String string2 = locale.getLanguage();
        int n = string2.length();
        String string3 = locale.getCountry();
        int n2 = string3.length();
        String string4 = locale.getVariant();
        int n3 = string4.length();
        if (string.toLowerCase().endsWith(".properties")) {
            string = string.substring(string.length() - 11);
        }
        string = string.replace('.', '/');
        StringBuffer stringBuffer = new StringBuffer(string);
        vector.addElement(stringBuffer.toString() + ".properties");
        vector.addElement(stringBuffer.toString());
        if (n + n2 + n3 == 0) {
            return vector;
        }
        stringBuffer.append('_');
        stringBuffer.append(string2);
        vector.addElement(stringBuffer.toString() + ".properties");
        vector.addElement(stringBuffer.toString());
        if (n2 + n3 == 0) {
            return vector;
        }
        stringBuffer.append('_');
        stringBuffer.append(string3);
        vector.addElement(stringBuffer.toString() + ".properties");
        vector.addElement(stringBuffer.toString());
        if (n3 == 0) {
            return vector;
        }
        stringBuffer.append('_');
        stringBuffer.append(string4);
        vector.addElement(stringBuffer.toString() + ".properties");
        vector.addElement(stringBuffer.toString());
        return vector;
    }

    protected boolean loadData(URL uRL) {
        if (uRL == null) {
            return false;
        }
        CBUtility.log("Resource Bundle Reading data from " + (uRL == null ? "null url" : uRL.toString()), 6);
        try {
            byte[] byArray = CBUtility.readStream(uRL.openStream());
            String string = CBUtility.readI18NByteArray(byArray);
            return this.parseData(string);
        }
        catch (Exception exception) {
            CBUtility.log("Unable to read data from url: " + (uRL == null ? "(null url)" : uRL.toString()) + " \n  -> exception was " + exception, 7);
            return false;
        }
    }

    protected boolean parseData(String string) {
        boolean bl;
        int n = this.translations.size();
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(10, n2)) != -1) {
            String string2 = string.substring(n2, n3);
            if ((string2 = string2.trim()).length() != 0 && string2.charAt(0) != '#') {
                try {
                    int n4 = 0;
                    while (string2.charAt((n4 = string2.indexOf(61, n4 + 1)) - 1) == '\\') {
                    }
                    String string3 = this.unescape(string2.substring(0, n4)).trim();
                    String string4 = string2.substring(n4 + 1).trim();
                    this.translations.put(string3, string4);
                }
                catch (Exception exception) {
                    CBUtility.log("Exception parsing data line '" + string2 + "' -> " + exception, 8);
                }
            }
            n2 = n3 + 1;
        }
        boolean bl2 = bl = n < this.translations.size();
        if (!bl) {
            CBUtility.log("ParseData unsuccessfull - no new data found", 8);
        }
        return bl;
    }

    protected String unescape(String string) {
        int n = 0;
        while ((n = string.indexOf(92, n)) >= 0) {
            string = string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    public Enumeration keys() {
        return this.translations.keys();
    }

    public Enumeration getKeys() {
        return this.translations.keys();
    }

    public Object get(Object object) {
        return this.translations.get(object);
    }

    public Object getObject(Object object) {
        return this.translations.get(object);
    }

    public String getString(String string) {
        if (string == null) {
            return "";
        }
        Object v = this.translations.get(string);
        if (v == null) {
            return "";
        }
        return v instanceof String ? (String)v : v.toString();
    }
}

