/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBResourceBundle;
import com.ca.commons.cbutil.CBUtility;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;

public class CBIntText {
    static Locale locale = null;
    static MessageFormat messageFormatter = null;
    static Hashtable translations;
    private static boolean errorGiven;
    private static boolean english;

    public static void init(String string, ClassLoader classLoader) {
        locale = Locale.getDefault();
        Locale locale = Locale.getDefault();
        CBUtility.log("Default Locale is: " + locale.getDisplayName(), 1);
        CBUtility.log("Using Locale: " + CBIntText.locale.getDisplayName() + " for " + CBIntText.locale.getDisplayCountry(), 4);
        CBUtility.log("language, localized for default locale is: " + locale.getDisplayLanguage(CBIntText.locale), 4);
        CBUtility.log("country name, localized for default locale: " + locale.getDisplayCountry(CBIntText.locale), 4);
        CBUtility.log("Default language, localized for your locale is: " + CBIntText.locale.getDisplayLanguage(locale), 4);
        CBUtility.log("Default country name, localized for your locale is: " + CBIntText.locale.getDisplayCountry(locale), 4);
        translations = new Hashtable(500);
        CBIntText.addBundle(string, classLoader);
        if (!locale.getLanguage().equals("en")) {
            english = false;
        }
        messageFormatter = new MessageFormat("");
        messageFormatter.setLocale(CBIntText.locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addBundle(String string, ClassLoader classLoader) {
        block10: {
            CBUtility.log("adding resource bundle: " + string + " using loader: " + classLoader.toString(), 4);
            int n = translations.size();
            if (locale == null) {
                CBUtility.log(" ERROR: - CBIntText.addBundle() has been called before CBIntText was initialised! - ignoring call.");
                return;
            }
            try {
                try {
                    CBResourceBundle cBResourceBundle = new CBResourceBundle(string, locale);
                    String string2 = cBResourceBundle.getString("name");
                    CBUtility.log(" added language localizaton set: " + (string2 == null ? "(not named)" : string2), 1);
                    Enumeration enumeration = cBResourceBundle.getKeys();
                    while (enumeration.hasMoreElements()) {
                        boolean bl;
                        Object e = enumeration.nextElement();
                        boolean bl2 = bl = CBUtility.getLogDebugLevel() >= 8;
                        if (translations.containsKey(e)) continue;
                        if (bl) {
                            CBUtility.log("adding key: " + e + " trans: " + cBResourceBundle.getString((String)e));
                        }
                        translations.put(e, cBResourceBundle.getString((String)e));
                    }
                    Object var9_9 = null;
                }
                catch (MissingResourceException missingResourceException) {
                    CBUtility.log("unable to load resource bundle for " + locale.getDisplayLanguage(locale) + " in country " + locale.getDisplayCountry(locale), 1);
                    Object var9_10 = null;
                    if (n < translations.size()) {
                        CBUtility.log(" locale language is " + locale.getDisplayLanguage(locale) + " in country " + locale.getDisplayCountry(locale), 1);
                        return;
                    }
                    CBUtility.log("Unable to load language resource bundle (couldn't even find default 'JX.properties' file)!", 1);
                    return;
                }
                if (n >= translations.size()) break block10;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (n < translations.size()) {
                    CBUtility.log(" locale language is " + locale.getDisplayLanguage(locale) + " in country " + locale.getDisplayCountry(locale), 1);
                    throw throwable;
                }
                CBUtility.log("Unable to load language resource bundle (couldn't even find default 'JX.properties' file)!", 1);
                throw throwable;
            }
            CBUtility.log(" locale language is " + locale.getDisplayLanguage(locale) + " in country " + locale.getDisplayCountry(locale), 1);
            return;
        }
        CBUtility.log("Unable to load language resource bundle (couldn't even find default 'JX.properties' file)!", 1);
    }

    public static String get(String string) {
        if (string == null) {
            return "null key";
        }
        if (translations == null || translations.size() == 0) {
            if (!errorGiven) {
                if (!english) {
                    CBUtility.log("Unable to translate (" + string + ") - can't find language resource bundle.");
                }
                errorGiven = true;
            }
            return string;
        }
        try {
            String string2 = (String)translations.get(string);
            if (string2 == null) {
                if (!english) {
                    CBUtility.log("Can't find translation for (" + string + ") - returning unchanged.", 3);
                }
                return string;
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static String get(String string, Object[] objectArray) {
        if (string == null) {
            return "null key";
        }
        String string2 = string;
        if (translations == null || translations.size() == 0) {
            if (!errorGiven) {
                if (!english) {
                    CBUtility.log("Unable to translate (" + string + ") - can't find language resource bundle.");
                }
                errorGiven = true;
            }
        } else {
            try {
                string2 = (String)translations.get(string);
                if (string2 == null) {
                    if (!english) {
                        CBUtility.log("Can't find translation for (" + string + ") - returning unchanged.", 3);
                    }
                    string2 = string;
                }
            }
            catch (MissingResourceException missingResourceException) {
                string2 = string;
            }
        }
        return MessageFormat.format(string, objectArray);
    }

    static {
        errorGiven = false;
        english = true;
    }
}

