/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBErrorWin;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class CBErrorWin
extends JDialog {
    String msg;
    String error;
    String title;
    boolean haveErrorMsg;
    CBButton OK;
    CBButton Details;
    CBPanel display;
    Exception exception;

    public CBErrorWin(Dialog dialog, String string, Exception exception) {
        super(dialog);
        this.title = CBIntText.get("Error Encountered");
        this.commonConstructor(string, exception);
    }

    public CBErrorWin(Frame frame, String string, Exception exception) {
        super(frame);
        this.title = CBIntText.get("Error Encountered");
        this.commonConstructor(string, exception);
    }

    public CBErrorWin(Frame frame, String string, String string2) {
        super(frame);
        this.title = string2;
        this.commonConstructor(string, null);
    }

    public void commonConstructor(String string, Exception exception) {
        this.setModal(true);
        this.exception = exception;
        this.setTitle(CBIntText.get(this.title));
        this.msg = string == null ? CBIntText.get("No Message Given") : string;
        this.haveErrorMsg = exception != null;
        this.error = this.haveErrorMsg ? exception.toString() : CBIntText.get("No specific information");
        JScrollPane jScrollPane = new JScrollPane(this.makeTextArea(this.msg));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.display = new CBPanel();
        this.display.makeHeavy();
        this.display.addLine(jScrollPane);
        this.display.makeLight();
        JPanel jPanel = new JPanel();
        this.OK = new CBButton(CBIntText.get("OK"), CBIntText.get("Click to close error window."));
        jPanel.add(this.OK);
        if (this.haveErrorMsg) {
            this.Details = new CBButton(CBIntText.get("Details"), CBIntText.get("Click to display the full error message."));
            jPanel.add(this.Details);
        }
        this.display.add(jPanel);
        this.OK.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.haveErrorMsg) {
            this.Details.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        this.display.getActionMap().put("enter", (Action)new MyAction(this, 10));
        this.display.getActionMap().put("escape", (Action)new MyAction(this, 27));
        this.setContentPane(this.display);
        this.setSize(new Dimension(400, 150));
        CBUtility.center(this, this.getOwner());
        this.setVisible(true);
    }

    protected JTextArea makeTextArea(String string) {
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setBackground(this.getBackground());
        jTextArea.setEnabled(false);
        jTextArea.setDisabledTextColor(Color.black);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        return jTextArea;
    }
}

