/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBUtility;
import java.io.UnsupportedEncodingException;

public class CBBase64 {
    private CBBase64() {
    }

    public static String binaryToString(byte[] byArray) {
        return CBBase64.binaryToString(byArray, 0);
    }

    public static String binaryToString(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length;
        int n3 = n2 / 3;
        byte[] byArray2 = CBBase64.encode(byArray);
        if (byArray2 == null) {
            return null;
        }
        return CBBase64.format(byArray2, n);
    }

    public static String format(byte[] byArray, int n) {
        String string;
        try {
            string = new String(byArray, "US-ASCII");
        }
        catch (Exception exception) {
            string = new String(byArray);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 76 - n; i < byArray.length; i += 78) {
            stringBuffer.insert(i, "\r\n ");
        }
        return stringBuffer.toString();
    }

    public static byte[] encode(byte[] byArray) {
        try {
            int n = byArray.length;
            int n2 = n % 3 == 0 ? n / 3 * 4 : (n / 3 + 1) * 4;
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            for (int i = 0; i <= n - 3; i += 3) {
                CBBase64.convertTriplet(byArray[i], byArray[i + 1], byArray[i + 2], 3, byArray2, n3);
                n3 += 4;
            }
            switch (n % 3) {
                case 0: {
                    break;
                }
                case 1: {
                    CBBase64.convertTriplet(byArray[n - 1], (byte)0, (byte)0, 1, byArray2, n3);
                    break;
                }
                case 2: {
                    CBBase64.convertTriplet(byArray[n - 2], byArray[n - 1], (byte)0, 2, byArray2, n3);
                }
            }
            return byArray2;
        }
        catch (Base64EncodingException base64EncodingException) {
            return null;
        }
    }

    public static byte[] encodeFormatted(byte[] byArray, int n, int n2) throws Base64EncodingException {
        try {
            int n3;
            if (n2 % 4 != 0) {
                throw new Base64EncodingException("error in encodeFormatted - colSize not a multiple of 4.");
            }
            if (n >= n2) {
                throw new Base64EncodingException("error in encodeFormatted - start is not less than colSize.");
            }
            int n4 = byArray.length;
            int n5 = n + (n4 % 3 == 0 ? n4 / 3 * 4 : (n4 / 3 + 1) * 4);
            n5 += n5 / n2 + 1;
            byte[] byArray2 = new byte[n5];
            for (n3 = 0; n3 < n; ++n3) {
                byArray2[n3] = 32;
            }
            n3 = n;
            for (int i = 0; i <= n4 - 3; i += 3) {
                CBBase64.convertTriplet(byArray[i], byArray[i + 1], byArray[i + 2], 3, byArray2, n3);
                if ((n3 += 4) % (n2 + 1) != n2) continue;
                byArray2[n3++] = 10;
            }
            switch (n4 % 3) {
                case 0: {
                    break;
                }
                case 1: {
                    CBBase64.convertTriplet(byArray[n4 - 1], (byte)0, (byte)0, 1, byArray2, n3);
                    n3 += 4;
                    break;
                }
                case 2: {
                    CBBase64.convertTriplet(byArray[n4 - 2], byArray[n4 - 1], (byte)0, 2, byArray2, n3);
                    n3 += 4;
                }
            }
            if (n3 < n5) {
                byArray2[n3++] = 10;
            } else {
                System.err.println("wierdness in formatted base 64 : bufferlength (" + n3 + ") != 1 + outputsize (" + n5 + ")");
            }
            return byArray2;
        }
        catch (Base64EncodingException base64EncodingException) {
            return null;
        }
        catch (Exception exception) {
            System.err.println("unexpected error in base 64 encoding");
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] stringToBinary(String string) {
        byte[] byArray;
        if (string == null) {
            return null;
        }
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return CBBase64.decode(byArray);
    }

    public static byte[] decode(byte[] byArray) {
        try {
            int n = (int)((double)byArray.length * 0.75);
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            int n3 = 0;
            byte[] byArray3 = new byte[4];
            int n4 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                if (by >= 65 && by <= 90 || by >= 97 && by <= 122 || by >= 48 && by <= 57 || by == 43 || by == 47 || by == 61) {
                    byArray3[n4++] = by;
                    ++n3;
                } else if (" \r\n\t\f".indexOf((char)by) == -1) {
                    CBUtility.log("error... bad character (" + (char)by + ") read from base64 encoded string", 6);
                    return null;
                }
                if (n4 != 4) continue;
                int n5 = CBBase64.convertQuad(byArray3);
                byArray2[n2++] = (byte)((n5 & 0xFF0000) >> 16);
                if (by != 61) {
                    byArray2[n2++] = (byte)((n5 & 0xFF00) >> 8);
                    byArray2[n2++] = (byte)(n5 & 0xFF);
                } else if (byArray[i - 1] != 61) {
                    byArray2[n2++] = (byte)((n5 & 0xFF00) >> 8);
                    if ((n5 & 0xFF) > 0) {
                        CBUtility.log("Warning: Corrupt base64 Encoded File - contains trailing bits after file end.", 6);
                        return null;
                    }
                } else if ((n5 & 0xFF00) > 0) {
                    CBUtility.log("Warning: Corrupt base64 Encoded File  - contains trailing bits after file end.", 6);
                    return null;
                }
                n4 = 0;
            }
            if (n3 % 4 != 0) {
                CBUtility.log("Warning: Corrupt base64 Encoded File - Length (" + n3 + ") of valid characters not divisible by 4.", 6);
                return null;
            }
            byte[] byArray4 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray4, 0, n2);
            return byArray4;
        }
        catch (Exception exception) {
            CBUtility.log("unable to create final decoded byte array from base64 bytes: " + exception, 6);
            return null;
        }
    }

    private static void convertTriplet(byte by, byte by2, byte by3, int n, byte[] byArray, int n2) throws Base64EncodingException {
        int n3 = by << 16 | by2 << 8 & 0xFF00 | by3 & 0xFF;
        byte by4 = (byte)((n3 & 0xFC0000) >> 18);
        byte by5 = (byte)((n3 & 0x3F000) >> 12);
        byte by6 = (byte)((n3 & 0xFC0) >> 6);
        byte by7 = (byte)(n3 & 0x3F);
        byArray[n2] = CBBase64.convertFrom6Bit(by4);
        byArray[n2 + 1] = CBBase64.convertFrom6Bit(by5);
        if (n == 1) {
            byArray[n2 + 2] = 61;
            byArray[n2 + 3] = 61;
        } else {
            byArray[n2 + 2] = CBBase64.convertFrom6Bit(by6);
            byArray[n2 + 3] = n == 2 ? 61 : CBBase64.convertFrom6Bit(by7);
        }
    }

    private static byte convertFrom6Bit(byte by) throws Base64EncodingException {
        if (by < 26) {
            return (byte)(65 + by);
        }
        if (by < 52) {
            return (byte)(71 + by);
        }
        if (by < 62) {
            return (byte)(-4 + by);
        }
        if (by == 62) {
            return 43;
        }
        if (by == 63) {
            return 47;
        }
        throw new Base64EncodingException("erroroneous value " + (char)by + " passed in convertFrom6bit");
    }

    private static byte convertTo6Bit(byte by) throws Base64EncodingException {
        if (by == 43) {
            return 62;
        }
        if (by == 47) {
            return 63;
        }
        if (by == 61) {
            return 0;
        }
        if (by <= 57) {
            return (byte)(by - 48 + 52);
        }
        if (by <= 90) {
            return (byte)(by - 65);
        }
        if (by <= 122) {
            return (byte)(by - 97 + 26);
        }
        throw new Base64EncodingException("erroroneous value " + (char)by + " passed in convertTo6bit");
    }

    private static int convertQuad(byte[] byArray) throws Base64EncodingException {
        byte by = CBBase64.convertTo6Bit(byArray[0]);
        byte by2 = CBBase64.convertTo6Bit(byArray[1]);
        byte by3 = CBBase64.convertTo6Bit(byArray[2]);
        byte by4 = CBBase64.convertTo6Bit(byArray[3]);
        int n = (by << 18) + (by2 << 12) + (by3 << 6) + by4;
        return n;
    }

    protected static class Base64EncodingException
    extends Exception {
        public Base64EncodingException(String string) {
            super(string);
        }
    }
}

