#!/bin/sh
# loads ssh keys into smartcard for use with ssh-1.2.27
#
# Usage: sshinit.sh

HOSTNAME=
PAY=/afs/citi.umich.edu/projects/sinciti/smartcards/src/sc7816/i386_obsd26/pay
SSH=
SSH_KEYFILE=73.68

choose_key()
{
    # use ~/.ssh/identity.pub
    # enter new filename to use
    # generate new keys (runs ssh-keygen)
}

get_keys()
{
    $SSH -K $HOSTNAME
    # parse
    PRIVATE_KEY=
    PUBLIC_KEY=
}

load_keys()
{
    echo "loading keys."
    $PAY <<- EOF
    jR $PRIVATE_KEY
    f 3f.00
    ic f0 e0 00 00 10
    01 00 73 68 02 01 00 00 ff 00 00 00 00 00 00 00
    f $SSH_KEYFILE
    ic f0 d6 00 00 80 $PUBLIC_KEY
    EOF
}

load_applet()
{
    echo "loading applet."
    $PAY <<- EOF
    $PORT
    jl card-side/Ssh.bin
    jq
    f 3f.0
    f $SSH_KEYFILE
    q
    EOF
}

# call procedures
choose_key
get_keys
load_keys
load_applet

echo "done."
exit 0

