//
//
// Ssh.java
// SSH / smartcard integration project, smartcard side 
//
// Tomoko Fukuzawa, created, Feb., 2000
//
// Naomaru Itoi, modified, Apr., 2000
//
// "CITI-krb5"
// jl -p 55.55 -c 55.56 -a 434954492d737368 Ssh.bin

import javacard.framework.*;
import javacardx.framework.*;
import javacardx.crypto.*;

public class Ssh extends javacard.framework.Applet
{ 
    /* constants declaration */ 
    // code of CLA byte in the command APDU header 
    private final byte Ssh_CLA =(byte)0x05;
    
    // codes of INS byte in the command APDU header
    private final byte DECRYPT = (byte) 0x10;
    private final byte GET_KEYLENGTH = (byte) 0x20;
    private final byte GET_PUBKEY = (byte) 0x30;
    private final byte GET_RESPONSE = (byte) 0xc0;

    /* instance variables declaration */
    private final short keysize = 1024;

    //RSA_CRT_PrivateKey rsakey;
    AsymKey rsakey;
    CyberflexFile file;
    CyberflexOS os;
    
    byte buffer[];
    //byte pubkey[];

    static byte[] keyHdr = {(byte)0xC2, (byte)0x01, (byte)0x05};

    private Ssh()
    {
	file = new CyberflexFile();
	os = new CyberflexOS();
	
	rsakey = new RSA_CRT_PrivateKey (keysize);
	rsakey.setKeyInstance ((short)0xc8, (short)0x10);

	if ( ! rsakey.isSupportedLength (keysize) )
	    ISOException.throwIt (ISO.SW_WRONG_LENGTH);

	/*
	pubkey = new byte[keysize/8];
	file.selectFile((short)(0x3f<<8)); // select root
	file.selectFile((short)(('s'<<8)|'h')); // select public key file
	os.readBinaryFile (pubkey, (short)0, (short)0, (short)(keysize/8));
	*/
	register(); 
    } // end of the constructor 

    public static void install(APDU apdu)
    {
	new Ssh();	// create a Ssh applet instance (card) 
    } // end of install method

    public void process(APDU apdu)
    { 
	// APDU object carries a byte array (buffer) to 
	// transfer incoming and outgoing APDU header 
	// and data bytes between card and CAD
	buffer = apdu.getBuffer(); 

	// verify that if the applet can accept this
	// APDU message 
	// NI: change suggested by Wayne Dyksen, Purdue
	if (buffer[ISO.OFFSET_INS] == ISO.INS_SELECT)
	    ISOException.throwIt(ISO.SW_NO_ERROR);
		
	switch (buffer[ISO.OFFSET_INS]) {
	case DECRYPT:
	    if (buffer[ISO.OFFSET_CLA] != Ssh_CLA)
		ISOException.throwIt(ISO.SW_CLA_NOT_SUPPORTED);
	    //decrypt (apdu);
	    short size = (short) (buffer[ISO.OFFSET_LC] & 0x00FF);
	    
	    if (apdu.setIncomingAndReceive() != size)
		ISOException.throwIt (ISO.SW_WRONG_LENGTH);
	    
	    rsakey.cryptoUpdate (buffer, (short) ISO.OFFSET_CDATA, size,
				 buffer, (short) ISO.OFFSET_CDATA);
	    apdu.setOutgoingAndSend ((short) ISO.OFFSET_CDATA, size);
	    return;
	case GET_PUBKEY:
	    file.selectFile((short)(0x3f<<8)); // select root
	    file.selectFile((short)(('s'<<8)|'h')); // select public key file
	    os.readBinaryFile (buffer, (short)0, (short)0, (short)(keysize/8));
	    apdu.setOutgoingAndSend((short)0, (short)(keysize/8)); 
	    /*
	    apdu.setOutgoing();
	    apdu.setOutgoingLength((short)(keysize/8)); 
	    apdu.sendBytesLong(pubkey, (short)0, (short)(keysize/8));
	    */
	    return;
	case GET_KEYLENGTH:
	    buffer[0] = (byte)((keysize >> 8) & 0xff);
	    buffer[1] = (byte)(keysize & 0xff);
	    apdu.setOutgoingAndSend ((short)0, (short)2);
	    return;
	case GET_RESPONSE:
	    return;
	default:
	    ISOException.throwIt (ISO.SW_INS_NOT_SUPPORTED); 
	} 

    } // end of process method

    /*
    private void decrypt (APDU apdu)
    {
 	short size = (short) (buffer[ISO.OFFSET_LC] & 0x00FF);

	if (apdu.setIncomingAndReceive() != size)
	    ISOException.throwIt (ISO.SW_WRONG_LENGTH);

	//short offset = (short) ISO.OFFSET_CDATA;

	rsakey.cryptoUpdate (buffer, (short) ISO.OFFSET_CDATA, size, buffer,
			     (short) ISO.OFFSET_CDATA);
	apdu.setOutgoingAndSend ((short) ISO.OFFSET_CDATA, size);
    }
    */
} // end of class Ssh 
