/*
 * SK - card applet for Skey OTP calculator
 *
 * Anna Khizhnyak, University of Michigan, July 2001
 */
import javacard.framework.*;
import javacardx.crypto.*;
import javacardx.framework.*;

public class SK extends Applet
{
    final short FileID = 0x7077;//pw
    static final byte Skey_CLA =(byte)0x03;//CLA
    private final byte Hash_no_cache = (byte) 0x10;//INS - calculate new hash
    private final byte Hash_cache = (byte) 0x20;//INS - use cached value
    final short SW_PROBLEM_WRITING_FILE = (short) 0x2020;//exception
    byte outhashlen = 0x08;//resulting hash length
    
    byte buffer[];//APDU buffer
    byte data[];//hash buffer
    byte inhashlen[];//lenght of passwd|seed
    byte datalen;// lenght of data=seed+2 
    short iter;//short version of input number in bytes
    MessageDigest sha;//crypto object
    CyberflexFile file;//Cyberflex file obj
    CyberflexOS os;//Cyberflex framework obj
    Util ut;//javacard framework obj
    
    private SK() {
	data = new byte[0x100];
	inhashlen = new byte[0x01];
	os = new CyberflexOS();
	file = new CyberflexFile();
	sha = new Sha1MessageDigest();
	ut = new Util();
	register();
    }  
    
    public static void install(APDU apdu) {
	new SK();
    } 
    
    public void process(APDU apdu) {
	byte i;
	buffer = apdu.getBuffer(); 
	switch(buffer[ISO.OFFSET_INS]) {
	case Hash_no_cache:
	    if(buffer[ISO.OFFSET_CLA] == Skey_CLA) 
		HashIt_no_cache(apdu);
	    return;
	case Hash_cache:
	    if(buffer[ISO.OFFSET_CLA] == Skey_CLA) 
		HashIt_cache(apdu);
	    return;
	default:
	    return;
	}
    }
    
    private int start(APDU apdu) {
	byte i;
	datalen = (byte)(apdu.setIncomingAndReceive());//obtained seed len+2
	if ( datalen != buffer[ISO.OFFSET_LC])
	    ISOException.throwIt (ISO.SW_WRONG_LENGTH);
	iter = (short)(( buffer[ISO.OFFSET_CDATA] * 0x100) + buffer[(ISO.OFFSET_CDATA + 0x1)]);
	file.selectRoot();
	if((file.selectFile(FileID)) == ST.NOT_FOUND) {
	    for(i = 0; i < outhashlen; i++)
		data[i] = (byte)0x00;
	    return 0;
	}
	return 1;
    }
    
    private void HashIt_no_cache (APDU apdu) {//hashit
	if(start(apdu) == 1)
	    compute(apdu);
	output(apdu);
	return;
    }//end of HashIt
    
    private void HashIt_cache (APDU apdu) {//hashit
	byte i;
	short number;//used to compare seed numbers
	byte cache[];//pswd length
	cache = new byte[0x2];
	if(start(apdu) == 1) {
	    os.readBinaryFile(cache,(short) 0,(short) 0x0,(short) 0x2);
	    number = (short)((cache[0] * 0x100) + cache[0x1]);
	    if((number == iter)&& (number != 0x0)) {//info cached
		os.readBinaryFile( data,(short) 0,(short) 0x2,(short) outhashlen);//read cached info
		output(apdu);
	    }
	    else
		for(i = 0; i < outhashlen; i++)
		    data[i] = (byte)0xff;
	    output(apdu);
	}
	return;
    }//end of HashIt
    
    private void output(APDU apdu) {
	apdu.setOutgoing(); 
	apdu.setOutgoingLength((byte)(outhashlen)); 
	apdu.sendBytesLong(data, (short) 0, (short) outhashlen);
    }//output


    private void compute(APDU apdu) {
	short i,j,l;
	byte num[];
	num = new byte[0x02];
	//read seed	
	ut.arrayCopy(buffer, (short)(ISO.OFFSET_CDATA+0x2), data, (short) 0x0, (short) (datalen-0x2));
	if(os.readBinaryFile(inhashlen,(short) 0,(short) 0x0a,(short) 0x1) == ST.SUCCESS) {//read pswd length
	    //read password
	    if ((os.readBinaryFile(data,(short) (datalen-0x2),(short) 0x0b,(short) inhashlen[0])) == ST.SUCCESS) {//pswd
		//set length of seed|password
		datalen += (byte)(inhashlen[0]-0x02);
		//run sha1 iteratively for skey
		for (i = 0; i <= iter ; i++ ) {
		    apdu.waitExtension();
		    sha.generateDigest(data, (short) 0, (short) datalen, data,(short) 0);
		    for( l = 0x0; l < 0x3; l++) {//first for
			for( j = 0x0; j < 0x4; j++) {//second for
			    if(l==0x00) data[j] ^= data[(j+0x08)];
			    if(l==0x01) data[(j+0x04)] ^= data[(j+0x0c)];
			    if(l==0x02) data[j] ^= data[(j+0x10)];
			}
		    }
		    datalen = outhashlen;
		    //cache next hash   
		    if(i == (iter - 0x01)) {//cache new passord hash
			num[0] = (byte)(i / 0x100);
			num[1] = (byte)(i % 0x100);
			if((os.writeBinaryFile(data, (short) 0, (short) 0x02, (short) outhashlen)) == ST.SUCCESS) {
			    if((os.writeBinaryFile(num, (short) 0x00, (short) 0x00, (short) 0x02)) != ST.SUCCESS)
				ISOException.throwIt (SW_PROBLEM_WRITING_FILE);
			}
			//else - finish calculations normally
		    }
		}
	    }
	}
    }//compute
    
}/*end of Skey class*/


/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
