/*
 * calc.c - Palm OS Specific Functions for Skey OTP calculator
 *
 * Anna Khizhnyak, University of Michigan, July 2001
 */

#include "header.h"
#include "dict.c"
#include "calc.c"

static Err StartApplication();
static void EventLoop(void);
static Boolean ApplicationHandleEvent(EventPtr event);
static Boolean MyFormHandleEvent(EventPtr event);
DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags);
static Err StopApplication();

///////////////////////////////Palm OS Specific functions/////////////////////////////////
static void EventLoop(void)
{
  EventType	event;
  Word	error;
  do {
    EvtGetEvent(&event, evtWaitForever);
    if (! SysHandleEvent(&event))
      if (! MenuHandleEvent(0, &event, &error))
	if (! ApplicationHandleEvent(&event))
	  FrmDispatchEvent(&event);
  } while (event.eType != appStopEvent);
}

static Boolean ApplicationHandleEvent(EventPtr event)
{
  FormPtr	frm;
  Int		formId;
  Boolean	handled = false;
  if (event->eType == frmLoadEvent) {
    formId = event->data.frmLoad.formID;
    frm = FrmInitForm(formId);
    FrmSetActiveForm(frm);
    switch (formId) {
    case MainForm:
      FrmSetEventHandler(frm, MyFormHandleEvent);
      break;
    }
    handled = true;
  }
  return handled;
}

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
  Err err = 0;		
  if (cmd == sysAppLaunchCmdNormalLaunch){ 
    if ((err = StartApplication()) == 0) {
      EventLoop();
      StopApplication();
    }
    else return err;
  }
  else return sysErrParamErr;
}

static Err StopApplication()
{
  if(hpacked)
    MemHandleFree(hpacked);
  FrmCloseAllForms();
  return 0;
}

static Err StartApplication()
{
  if(!(gDB = DmOpenDatabaseByTypeCreator('Str', 'anna', dmModeReadWrite)))
  {
    strNum = 1;
    StrCopy(MyStringList, "None ");    
    SaveInDatabase();
  }
  else 
  {
    strNum = DmNumRecords(gDB);
    Record();
  }
  FrmGotoForm( MainForm );
  return 0;
}

static Boolean MyFormHandleEvent(EventPtr event)
{
  Boolean		handled;
  FormPtr		frm = FrmGetActiveForm();
  Word i;
  FieldPtr fld;

#ifdef __GNUC__
  CALLBACK_PROLOGUE
#endif __GNUC__
    handled = false;
  switch (event->eType) 
    {
    case ctlEnterEvent:
      if(event->data.ctlSelect.controlID == popuptriggerID_cmd)
      {
	ListAllocate();
	handled = true;
      }
      break;
    case frmOpenEvent:
      for(i = 0; i < 3; i++)
      {
	if(i == 0) {
	  fld =  getObject( frm, Reply);
	  fld->attr.singleLine = false;
	}
	if(i == 1)
	  fld =  getObject( frm, Hex);
	fld->attr.editable = false;
      }
      FrmDrawForm(frm);
      handled = true;
      break;
    case ctlSelectEvent:  	
      switch ( event->data.ctlSelect.controlID ) 
      {
      case Save:
	buttons_off_on(0, frm);
	if(!scOTP_save())
	  FrmCustomAlert(Error,"Please, make sure your card reader is attached properly","","");
	buttons_off_on(1, frm);
	closeReader();
	handled = true;
	break;
      case Compute:
	buttons_off_on(0, frm);
	if(!scOTP_compute()) {
	  FrmCustomAlert(Error,"Please, make sure your card reader is attached properly","","");
	  buttons_off_on(1, frm);
	}
	closeReader();
	handled = true;
	break; 
      case Clear:	
	scOTP_clear(Seed);
	scOTP_clear(Pswd);
	scOTP_clear(Number);
	scOTP_clear(Hex);
	scOTP_clear(Reply);
	handled = true;
	break; 
      }
    case menuEvent:				       
      switch ( event->data.menu.itemID ) {
      case Help:					
	FrmHelp(HelpText);
	break;
      case About:
	FrmHelp(AboutText);
	break;
      }
      handled = true;
      FrmDrawForm(frm);
      break;
    }  
#ifdef __GNUC__
  CALLBACK_EPILOGUE
#endif
    return(handled);
}

/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
