/*
 * calc.c - Skey OTP calculations related functions 
 *
 * Anna Khizhnyak, University of Michigan, July 2001
 */

////////////////////////Calculator specific functions/////////////////////

/*
 * buttons_off_on draws or erases buttons depending on "on" value
 * within frm form
 */
void buttons_off_on(Boolean on, FormPtr frm) {
  ControlPtr cp;
  int i;
  for(i = 0; i < 3; i++) {
    if(!i)
      cp = getObject (frm, Save);
    if(i == 1)
      cp = getObject (frm, Compute);
    if(i == 2)
      cp = getObject (frm, Clear);
    if(!on)
      CtlEraseControl(cp);
    if(on)
      CtlDrawControl(cp);
  }
}

/*
 * SpaceElim eliminates spaces before and after character string in
 * string
 * Returns:
 *        false - empty resulting string
 *        true - non-empty resulting string
 */
Boolean SpaceElim(CharPtr string)
{
  Word i = 0;
  CharPtr tmp;
  char helper[(StrLen(string)+1)];
  //eliminate spaces before input
  while((i < StrLen(string)) && ((i == ' ') || (i == '\n')))
    i++;
  //eliminate spaces after input
  StrCopy(helper, &string[i]);
  if((tmp = StrChr(helper,' ')) != NULL)
    *tmp = '\0';
  if(StrLen(helper) == 0)
    return false;
  StrCopy(string,helper);
  return true;
}

/*
 * HexToAscii changes hex value in i'th location of engout 
 * and concatenates it to the end of string built after 8'th 
 * position in engout
 * Used for printing of Hex output in scOTP_compute function
 */ 
void HexToAscii(CharPtr engout, Word i)
{
  char buf[9];
  StrIToH(buf, engout[i]);
  StrCat(&engout[8],&buf[6]);
  StrCat(&engout[8]," ");
}

/* 
 * helper reads string from fld and stores it at ptr location
 */
void helper( FieldPtr fld, CharPtr ptr)
{
  CharPtr s;
  s = FldGetTextPtr(fld);
  if( s && (s[0] != '\0') )
    StrCopy(ptr,s);
  else
    StrCopy(ptr,"\0");
}

/*
 * Store reads Host name using "helper" function,
 * checks if it is in the seed list "MyStringList"
 *  if it is and it is not at the first location - moves it and
 *                                 changes INS to 0x10 (no use 
 *                                 of cached on the card pswd)
 *           and it is at the first location - changes INS to 0x20
 *                                 (using cached on the card pswd)
 *  if it is not - adds to the list and changes INS to 0x10 (no use
 *                                 of cached on the card pswd)
 * Also, if checks for the list overflow - 
 *                               no more that 10 host names saved
 */

Boolean Store(CharPtr s)
{  
  Word i, j = 0, k = 0, l = 0;
  FieldPtr fld;
  char MSL1[(11*MaxNumStr)];
  VoidHand h;
  FormPtr frm = FrmGetActiveForm();
  fld =  getObject( frm, Seed);
  helper(fld, s);

  //check for empty input string      
  if((s) && ((s[0] == '\0') || (!SpaceElim(s)))) {
    FrmCustomAlert( Error, "Please, enter Host Name","","" );
    return false;
  }

  //check if input is already in the list
  StrCopy(MSL1, MyStringList);
  for( i = 0; i < (StrLen(MyStringList)+1); i++) {
    if((MSL1[i] == ' ')||(MSL1[i] == '\0')) {
      MSL1[i] = '\0';
      if(!StrCompare(&MSL1[j],s)) {
	if(l == 1)
	  return true;
	strNum--;
	k = j + StrLen(s) + 1;
	MemMove(&MyStringList[j], &MyStringList[k], StrLen(&MyStringList[k]));
	if(gDB = DmOpenDatabaseByTypeCreator('Str', 'anna', dmModeReadWrite)) {
	  DmRemoveRecord(gDB, l);
	  DmCloseDatabase(gDB);
	}
	break;
      }
      j = i + 1;
      l++;
    }
  }

  //control overflow
  if(strNum >= MaxNumStr) {
    MyStringList[ Scrol(MaxNumStr - 1) ] = '\0';
    if(gDB = DmOpenDatabaseByTypeCreator('Str', 'anna', dmModeReadWrite)) {
      DmRemoveRecord(gDB, (MaxNumStr-1));
      DmCloseDatabase(gDB);
    }
    strNum--;
  }

  //add input string to the list
  StrCopy(MSL1, MyStringList);
  i = Scrol(1);
  StrCopy(&MSL1[i], s);
  StrCat( MSL1, " ");
  StrCat( MSL1, &MyStringList[Scrol(1)]);
  StrCopy(MyStringList, MSL1);
  strNum++;
  SaveInDatabase();
  INS = 0x10;
  return true;
}

/*
 * Record reads host names database using ReadRecord function 
 * and stores data in MyStringList string
 */
void Record()
{
  Word cursor;
  *MyStringList = '\0';
  for(cursor = 0; cursor < strNum; cursor++)
    ReadRecord(cursor, MyStringList);
  DmCloseDatabase(gDB);
}

/*
 * SaveInDatabase saves data from MyStringList in MSList DB
 */
Boolean SaveInDatabase()
{
  Word i,j,k;

  //open database is exists or create a new one
  if(!DmFindDatabase( 0, "MSList")) {
    if(DmCreateDatabase(0,"MSList", 'anna', 'Str', false)) {
      FrmCustomAlert(Error,"Failed to create database","","");
      return 0;
    }
    //save all strings from MyStringList into database
    //(in case of data loss, MyStringList is a backup at run-time)
    for(i = 0; i < strNum; i++) {
      j = Scrol(i);
      k = Scrol(i+1);
      SaveRec( j, (k-j), i);
    }
  }
  //save the host name from MyStringList at first position
  else {
    j = Scrol(1);
    k = Scrol(2);
    if(strNum >= 2) 
      SaveRec( j, (k-j), 1);
    else 
      SaveRec( j, (k-j), (strNum - 1));
  }
}

/*
 * SaveRec saves name with length "len from MyStringList at 
 * "offet" into database at "number"
 */
void SaveRec(Word offset, Word len, Word number)
{
  char tempStr[len];
  VoidPtr p;
  VoidHand h;
  if(gDB = DmOpenDatabaseByTypeCreator('Str', 'anna', dmModeReadWrite))
  {
    if(number == (strNum-1))
      StrCopy(tempStr, &MyStringList[offset]);
    else {
      StrNCopy(tempStr, &MyStringList[offset], len);
      tempStr[(len-1)] = '\0';
    }
    h = DmNewRecord( gDB, &number, (StrLen(tempStr)+1));
    if(h) {
      if(p = MemHandleLock(h)) {
	if(!DmSet(p,0,(StrLen(tempStr)+1),0))
	  if(DmWrite(p, 0, tempStr, (StrLen(tempStr)+1)))
	    FrmCustomAlert(Error,"DmWrite","failed","");
	MemHandleUnlock(h);
      }
      else 
	FrmCustomAlert(Error,"didn't lock","","");
      DmReleaseRecord(gDB, number, true);
    }
    DmCloseDatabase(gDB);
  }
  else 
    FrmCustomAlert(Error,"","","Couldn't open database");
}

/*
 * ReadRecord reads a recors at cursor number and concatenates it 
 * to MSL preceeded by space
 */
void ReadRecord(Word cursor,CharPtr MSL)
{  
  VoidPtr p;
  VoidHand h;
  CharPtr s;
  if((h = DmGetRecord( gDB, cursor)) == NULL)
    FrmCustomAlert(Error,"locked record","","");
  s = MemHandleLock(h);
  DmReleaseRecord( gDB, cursor,true);
  if( cursor >= 2)
    StrCat(MSL, " ");
  StrCat(MSL, s);
  MemHandleUnlock(h);
}

/*
 * select outputs host name from MyStringList that corresponds to
 * "choice" number in Host Name (seed) field
 */
void select(Word choice)
{
  FieldPtr fld; 
  VoidHand h;
  CharPtr s, tmp;
  char MSL[(11*MaxNumStr)];
  if(!choice)
    scOTP_clear(Seed);
  else if(choice != -1) {
    FormPtr frm = FrmGetActiveForm();
    choice = Scrol(choice);
    StrCopy(MSL, &MyStringList[choice]);
    tmp = StrChr(MSL, ' ');		
    *tmp = '\0';
    fld = getObject( frm, Seed);
    Output(MSL, fld, false);
  }
}

/*
 * Output writes string in the field "fld" or
 * clears the field's contents if "erase" is set
 */
void Output(CharPtr string, FieldPtr fld, Boolean erase)
{
  CharPtr s;
  VoidHand h, old;
  h = MemHandleNew(StrLen(string) + 1);
  if(h) {
    s = MemHandleLock(h);
    if(s) {
      StrCopy(s, string);
      MemHandleUnlock(h);
      if(erase) {
	(Handle)old = FldGetTextHandle(fld);
	if(old) {
	  FldSetTextHandle(fld, (Handle)h);
	  FldDrawField(fld);
	  MemHandleFree(old);
	}
	else 
	  MemHandleFree(h);
      }
      else {
	FldSetTextHandle(fld, (Handle)h);
	FldDrawField(fld);
      }
    }
  }
  else 
    FrmCustomAlert(Error,"did not allocate new handle","","");
}

/*
 * Scrol return offset within MyStringList that corresponds to
 * the "choice" word count
 */
Word Scrol(Word choice)
{
  Word i=0;
  Word j;
  for(j = 0; j < choice; j++) {
    for( i; i < StrLen(MyStringList); i++) {
      if(MyStringList[i] == ' ') {
	i++;
	break; 
      } 
    }
  }
  return i;
}

/*
 * getObject returns object pointer that corresponds to objID 
 * within the "frm" form
 */
VoidPtr getObject (FormPtr frm, Word objID)
{
  Word index  = FrmGetObjectIndex( frm, objID);
  return FrmGetObjectPtr (frm, index);
}

/*
 * scOTP_clear clears out the contents of the field at objID
 */
Int scOTP_clear(Word objID)
{
  FormPtr frm = FrmGetActiveForm();
  Output( "\0", getObject( frm, objID), true);
  return( 0 );
}

/*
 * ListAllocate fills in the Host Name drop-down menu contents
 * and get's user's selection
 */
void ListAllocate()
{
  Word i;
  CharPtr ppacked;
  VoidPtr pp;
  FormPtr frm = FrmGetActiveForm();
  //allocate space for the list
  if(hpacked == 0) {
    if((hpacked = MemHandleNew(StrLen(MyStringList) + strNum))==0)
      FrmCustomAlert(Error,"","","MemHandleNew");
  }
  else {
    if(MemHandleResize(hpacked, (StrLen(MyStringList) + strNum)))
      FrmCustomAlert(Error,"","","MemHandleResize");
  }
  ppacked = MemHandleLock(hpacked);
  StrCopy(ppacked,MyStringList);
  //substitute word space separators by NULLs
  for(i = 0; i < StrLen(MyStringList) ;i++) {
    if( ppacked[i] == ' ')
      ppacked[i] = '\0';
  }
  //draw the list
  if((hpoint = SysFormPointerArrayToStrings(ppacked, strNum)) == 0)
    FrmCustomAlert(Error,"Error allocating list","","");
  pp = MemHandleLock(hpoint);
  CtlSetUsable(getObject( frm,listID_cmd),true);
  LstSetListChoices( getObject( frm, listID_cmd), pp, strNum);
  //get user's selection
  select(LstPopupList(getObject( frm,listID_cmd)));
  CtlSetUsable(getObject( frm,listID_cmd),false); 
  MemHandleUnlock(hpacked);
}

/*
 * card compute talks to the card:
 *      calls password calculator
 *      gets output
 */
Int  card_compute(char buf[12]) {
  Word i;
  FieldPtr fld;  
  char engout[33];
  FormPtr frm = FrmGetActiveForm();
  i = openReader();
  if (!i)  
    return 1;
  if(i == 2)
    return 0;
  sevenbit(buf);
  i = scwrite(myfd, 0x03, INS, 0x00, 0x00, (unsigned char)(StrLen(&buf[2])+2),buf, &sw1p, &sw2p);
  if(i < 0) {
    FrmCustomAlert(Error,"Failed to execute command","","");
    return 1;
  }
  scread(myfd, class_byte, 0xc0, 0x00, 0x00, (unsigned char)sizeof(One_time_pswd), One_time_pswd, &sw1p, &sw2p);
  if((One_time_pswd[1] == 0x00) && (One_time_pswd[2] == 0x00)) {
    StrCopy(engout, "No password stored");
    fld =  getObject( frm, Reply);
    Output(engout, fld, false);
    return 1;
  }
  if((INS == 0x20) && (One_time_pswd[1] == 0xff) && (One_time_pswd[2] == 0xff)) {
    INS = 0x10;
    card_compute(buf);
  } 
  return 3;
}

/*
 * scOTP_compute assembles info for the card, sends it
 * outputs the result of card's computations
 */
Int scOTP_compute()
{
  VoidHand old;
  char s[11];
  Word i;
  FieldPtr fld;
  char engout[33];
  char engout_helper[20];	
  char buf[12];
  FormPtr frm = FrmGetActiveForm();

  //read input and create number|seed string
  if(!Store(s))
    return 1;
  else
    StrCopy(&buf[2], s);
  fld =  getObject( frm, Number);
  helper(fld, s);
  if( s && (s[0] != '\0') ) {
    i = StrAToI(s);
    buf[0] = i / 0x100;
    buf[1] = i % 0x100;
    i = 2;//whatever makes it i>1
  }
  else {
    FrmCustomAlert(Error,"Please, enter Number","","");
    return 1;
  }
  
  //perform computation on the number|seed string
  scOTP_clear(Hex);
  scOTP_clear(Reply);
  if((i = card_compute(buf)) != 3)
    return i;

  //generate pass phrase
  btoe (engout,One_time_pswd);
  fld =  getObject( frm, Reply);
  Output(engout, fld, false);
  for(i = 0; i < 8; i++)
    engout[i] = (unsigned char) One_time_pswd[i];
  engout[8] = '\0';
  for(i = 0; i < 8; i++)
    HexToAscii(engout, i);
  StrCopy(engout, &engout[8]);
  fld =  getObject( frm, Hex);
  Output(engout, fld, false);
  if(INS == 0x20) {
    INS = 0x10;
    card_compute(buf);
  }
  INS = 0x20;
  return 1;
}

/*
 * openReader opens connection to the card and determins 
 * card's type : 00 or f0 (class byte)
 * Returns:
 *        0 - fail
 *        1 - success
 */
int openReader() 
{
  int error;
  UInt i;
  char buf[] = { 0x01, 0x00, 0x61, 0x00}; 
  char engout[33];	

  //check if connection possible
  error = CT_init(1,0);
  if(error == -11)
    return 2;
  if(error == -10) {
    CT_close(0);
    return 2;
  }
  else {
    CT_close(0);
    myfd = scopen(0, 0, NULL);
    if (myfd < 0) 
      return 2;
    if(!screset(myfd, NULL, NULL)) {
      FrmCustomAlert(Error,"Please, insert your card in the reader","","");
      closeReader();
      return 0;
    }

    //search for a class byte
    error = scwrite(myfd, class_byte, 0x2a, 0, 0, sizeof AUT0, AUT0, &sw1p, &sw2p);
    if (error==-1) {
      FrmCustomAlert(Error,"Error found","","");
      closeReader();
      return 0;
    }
    if((sw1p!=0x90)&&(sw1p!=0x61)) {
#ifdef OO_CARD
      class_byte = 0xf0;
#else
      class_byte = 0x00;
#endif
      error = scwrite(myfd, class_byte, 0x2a, 0, 0, sizeof AUT0, AUT0, &sw1p, &sw2p);
      if (error==-1) {
	FrmCustomAlert(Error,"Error found","2","");
	closeReader();
	return 0;
      }
      if((sw1p!=0x90)&&(sw1p!=0x61)) {
	FrmCustomAlert(Error,"Error found while selecting CLA byte","","");
	closeReader(); 
	return 0;
      }
    }
    else 
      return 1;
  }
}

/*
 * closeReader closes connection to the card if the one is open
 */
void closeReader()
{
  if(myfd >= 0) {
    scclose(myfd);
    myfd = -1;
  }
}

/*
 *
 */
void card_save(char input[17]) {
  unsigned char buf[]={0x70, 0x77};
  scwrite(myfd, class_byte, 0xa4, 0x00, 0x00, 0x02, buf, &sw1p, &sw2p);
  if((scwrite(myfd, class_byte, 0xd6, 0x00, 0x00, (unsigned char)(StrLen(&input[11])+11), input, &sw1p, &sw2p)) == -1)
    FrmCustomAlert(Error,"Error found","","");
  if((sw1p==0x90)||(sw1p==0x61)) {
    FrmCustomAlert(Error,"Password saved","","");
    INS = 0x10;
  }
  else 
    FrmCustomAlert(Error,"Error found","file exists, but data not saved","");
}

/*
 * scOTP_save saves secret password in 70 77 file on card
 * Returns:
 *        0 - error opening connection to the card
 *        1 - connection opened
 */
Int scOTP_save()
{
  VoidHand h, old;
  CharPtr s; 
  char buf2[17];//max len of the field +2(len + \0)
  Word i = 0;
  FieldPtr fld;
  FormPtr frm;
  char engout[33];
  unsigned char buf[]={0x3f, 0x00};
  unsigned char buf1[] = {0x00, 0x50, 0x70, 0x77, 0x02, 0x01, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  frm = FrmGetActiveForm();
  fld =  getObject( frm, Pswd);
  //generate len|pswd string
  helper(fld, &buf2[11]);
  if((&buf2[11] != '\0') || (SpaceElim(&buf2[11])))
    buf2[10] = (unsigned char)StrLen(&buf2[11]); 
  else {
    FrmCustomAlert(Error,"Please enter Password","","");
    return 1;
  } 
  for(i = 0; i < 10; i++)
    buf2[i] = 0x0;

  //call the card
  i = openReader();
  if (!i) 
    return 1;
  if(i == 2)
    return 0;
  i = scwrite(myfd, class_byte, 0xa4, 0x00, 0x00, 0x02, buf, &sw1p, &sw2p);//select root
  if(i==-1)
    FrmCustomAlert(Error,"Error found","","");
  else {//no error opening the card
    if((sw1p==0x90)||(sw1p==0x61)) {
      buf[0] = 0x70;
      buf[1] = 0x77;
      i = scwrite(myfd, class_byte, 0xa4, 0x00, 0x00, 0x02, buf, &sw1p, &sw2p);//select pswd file
      if(i==-1)//password file exists
	FrmCustomAlert(Error,"Error found","","");
      else {
	if((sw1p==0x90)||(sw1p==0x61)) {
	  card_save(buf2);
	  return 1;
	}
	else {//create password file
	  i = scwrite(myfd, class_byte, 0xe0, 0x00, 0x00, 0x10, buf1, &sw1p, &sw2p);
	  if(i==-1)         
	    FrmCustomAlert(Error,"Error found","","");
	  else {
	    if((sw1p==0x90)||(sw1p==0x61)) //file created
	      card_save(buf2);
	    else 
	      FrmCustomAlert(Error,"Error found","file not created","");
	  }
	}
      }
    }
  }
  return 1;
}
/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
