/* $Id: pilotmain.c,v 1.7 2001/10/02 16:24:09 rees Exp $ */

/*
 * Smartcard commander.
 * Written by Jim Rees and others at the
 * Center for Information Technology Integration (CITI)
 * University of Michigan.
 */

/*
copyright 2001
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <System/Unix/sys_types.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/unix_string.h>
#include <string.h>

#include "sectok.h"
#include "field.h"
#include "resource.h"
#include "sc.h"

#define MAXTOKENS 300
#define MAXCOMMANDS 12

int port, fd = -1, cla;
FieldPtr cmdfield, printfield;
char *__progname = "sectok";

extern void IO_Close();
int StartApplication();
int StopApplication();
int EventLoop();
static Boolean sectok(EventPtr event);
void display_cmd_list();
int parse_and_dispatch();
int just_dispatch(char *cmd);

static char *lv1[] = {"apdu", "fid", "isearch", "csearch", "class", "read", "write", "challenge", NULL};
static char *lv2[] = {"acl", "create", "delete", "jdefault", "jatr", "jdata", "login",
			  "junload", NULL};
static char **lva[] = {lv1, lv2, NULL};

DWord
PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
    int err;

    if (cmd == sysAppLaunchCmdNormalLaunch) {
	err = StartApplication();
	if (err)
	    return err;
	EventLoop();
	StopApplication();
	return 0;
    } else
	return sysErrParamErr;
}

int
StartApplication()
{
    fd = -1;
    FrmGotoForm(formID_sectok);
    return 0;
}

int
StopApplication()
{
    dclose(0, NULL);
    IO_Close();
    FrmCloseAllForms();
    return 0;
}

int
EventLoop()
{
    short err;
    int formID;
    FormPtr form;
    EventType event;

    do {
	EvtGetEvent(&event, 200);

	if (SysHandleEvent(&event))
	    continue;
	if (MenuHandleEvent((void *)0, &event, &err))
	    continue;

	if (event.eType == frmLoadEvent) {
	    formID = event.data.frmLoad.formID;
	    form = FrmInitForm(formID);
	    FrmSetActiveForm(form);
	    switch (formID) {
	    case formID_sectok:
		FrmSetEventHandler(form, (FormEventHandlerPtr) sectok);
		break;
	    }
	}
	FrmDispatchEvent(&event);
    } while (event.eType != appStopEvent);
    return 0;
}

static Boolean
sectok(EventPtr event)
{
    FormPtr form = FrmGetActiveForm();
    Word item;
    FieldPtr field;
    int id, handled;
    char *cmd, cmdname[32], *av[2];

    item = FrmGetFocus(form);
    if (item == noFocus)
	field = printfield;
    else
	field = FrmGetObjectPtr(form, item);

    switch (event->eType) {
    case frmOpenEvent:
	switch (event->data.frmOpen.formID) {
	case formID_sectok:
	    cmdfield = FrmGetObjectPtr(form, FrmGetObjectIndex(form, fieldID_cmd));
	    printfield = FrmGetObjectPtr(form, FrmGetObjectIndex(form, fieldID_msg));
	    display_cmd_list();
	    FrmDrawForm(form);
	    break;
	default:
	    break;
	}
	handled = 1;
	break;

    case ctlSelectEvent:
	id = event->data.ctlEnter.controlID;
	handled = 1;
	switch (id) {
	case buttonID_Go:
	    parse_and_dispatch();
	    break;
	case buttonID_Clear:
	    setfield(cmdfield, NULL);
	    FrmSetFocus(form, FrmGetObjectIndex(form, fieldID_cmd));
	    break;
	case buttonID_Reset:
	    just_dispatch("reset -v");
	    break;
	case buttonID_ls:
	    just_dispatch("ls -l");
	    break;
	case buttonID_Close:
	    dclose(0, NULL);
	    break;
	default:
	    handled = 0;
	    break;
	}
	break;

    case popSelectEvent:
	cmd = lva[event->data.popSelect.listID - listID_cmd][event->data.popSelect.selection];
	av[0] = "help";
	av[1] = cmd;
	help(2, av);
	sprintf(cmdname, "%s ", cmd);
	setfield(cmdfield, cmdname);
	FrmSetFocus(form, FrmGetObjectIndex(form, fieldID_cmd));
	handled = 1;
	break;

    case keyDownEvent:
	if (field == cmdfield && event->data.keyDown.chr == '\n') {
	    parse_and_dispatch();
	    handled = 1;
	} else
	    handled = scrollfield(field, event->data.keyDown.chr);
	break;

    case menuEvent:
	switch (event->data.menu.itemID) {
	case menuitemID_help:
	    FrmHelp(textID_help);
	    break;
	case menuitemID_about:
	    FrmAlert(alertID_about);
	    break;
	case menuitemID_cut:
	    FldCut(field);
	    break;
	case menuitemID_copy:
	    FldCopy(field);
	    break;
	case menuitemID_paste:
	    FldPaste(field);
	    break;
	default:
	    break;
	}
	handled = 1;
	break;

    default:
	handled = 0;
	break;

    }
    return handled;
}

void
display_cmd_list()
{
    FormPtr form = FrmGetActiveForm();
    ListPtr lp;
    int li, lc;

    /* For each list */
    for (li = 0; lva[li]; li++) {
	/* Count how many entries in this list */
	for (lc = 0; lva[li][lc]; )
	    lc++;
	lp = (ListPtr) FrmGetObjectPtr(form, FrmGetObjectIndex(form, li + listID_cmd));
	LstSetListChoices(lp, lva[li], lc);
    }
}

int
parse_and_dispatch()
{
    if (fd < 0) {
	printf("reader not open\n");
	return -1;
    }

    if (FldGetTextLength(cmdfield) <= 0)
	return -1;

    return just_dispatch(FldGetTextPtr(cmdfield));
}

int
just_dispatch(char *cmd)
{
    int sw, tc;
    char *s, *tp, *tv[MAXTOKENS];

    s = strdup(cmd);

    for (tc = 0, tp = s; *tp; ) {
	/* skip blanks */
	while (*tp && *tp == ' ')
	    *tp++ = '\0';
	if (!*tp)
	    break;
	tv[tc++] = tp;
	/* skip non-blanks */
	while (*tp && *tp != ' ')
	    tp++;
    }
    tv[tc] = NULL;

    sw = dispatch(tc, tv);
    free(s);
    return sw;
}
