/*
 * The author of this software is Matt Blaze.
 *              Copyright (c) 1992, 1993, 1994, 1995 by AT&T.
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software is subject to United States export controls.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

/*
 * scfs verify key/pin

 Multiflex:
 sverify -n 1 47 46 58 49 32 56 78 40

 Cyberflex Access:
 sverify -n 0 ad 9f 61 fe fa 20 ce 63
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rpc/rpc.h>
#include <sys/time.h>
#ifdef irix
#include <sys/statfs.h>
#else
#ifndef BSD44
#ifdef	ultrix
#include <sys/param.h>
#include <sys/mount.h>
#else
#include <sys/vfs.h>
#endif	/* ultrix */
#else
#ifndef MAXHOSTNAMELEN
#include <sys/param.h>
#endif
#include <sys/mount.h>
#endif	/* BSD44 */
#endif
#include "nfsproto.h"
#include "admproto.h"
#include "cfs.h"

#ifdef SOLARIS2X
/* NOTE!  delete the #define statfs below if this won't compile on
  your solaris configuration */
#define statfs		statvfs
#endif

#ifndef TMOUT		/* default timeout; override in makefile */
#define TMOUT 0
#endif

#ifndef IDLE		/* default idle timer; override in makefile */
#define IDLE 0
#endif

#define KEY_LEN 8 /* key length is always 8. */
#define MAX_PIN 8 /* PIN length is up to 8. */

main(argc, argv)
     int argc;
     char *argv[];
{
        scfs_verify_args ap;
	int status, i;
	cfsstat ret;

#ifdef	ultrix
	struct fs_data sfb;
#define f_blocks  fd_req.btot
#else
	struct statfs sfb;
#endif
	FILE *fp;
	unsigned char ekey[128];
	static struct timeval tout = {60,0};
	CLIENT *cln;
	int timeout=TMOUT;
	int idle=IDLE;
	int type;
	char *keyarg = NULL;
	int offset = 0; 

	ap.keynum = 0; 
	type = SCFS_KEY; 

	for (i = 1 ; argv[i][0] == '-' ; i++) {
	    switch (argv[i][1]) {
	    case 'p':	/* input PIN */
		type = SCFS_PIN;
		break; 
	    case 'k':	/* input key */
		type = SCFS_KEY;
		break;
	    case 'n':   /* specify key number */
		i++;
		ap.keynum = atoi (argv[i]);
		if (ap.keynum < 0) goto out; 
		break;
	    default:
	    out:
		fprintf(stderr,"usage: verify [-p/k] [-n key_num] PIN/KEY\n");
		fprintf(stderr,"  by default it wants key.\n");
		exit(1);
	    }
	}
	offset = i; 

	if (type == SCFS_KEY && argc - offset != KEY_LEN) {
	    fprintf (stderr, "key length must be %d\n", KEY_LEN);
	    exit (1);
	}
	if (type == SCFS_PIN && (argc - offset < 1 || argc - offset> MAX_PIN)) {
	    fprintf (stderr, "PIN length must be 1 to %d byte\n", MAX_PIN);
	    exit (1);
	}

	printf ("offset =  %d, argc = %d\n", offset, argc);

	ap.type = type;
	ap.len = argc - offset; 
	bzero (ap.data, KEY_LEN);
	
	/* set values */
	for (i = offset ; i < argc ; i ++) {
	    sscanf (argv[i], "%x", &(ap.data[i - offset]));
	}

	if ((cln=clnt_create("localhost",ADM_PROGRAM,ADM_VERSION,"udp"))
	    == NULL) {
	    clnt_pcreateerror("adm");
	    exit(1);
	}
	cln->cl_auth = authunix_create_default();

	status = clnt_call(cln, ADMPROC_VERIFY, xdr_scfs_verify_args,
			   &ap, xdr_cfsstat, &ret, tout);
	if (status != RPC_SUCCESS) {
	    clnt_perrno(status);
	    exit(1);
	}
	if (ret != CFS_OK)
	    fprintf(stderr,"sverify: %s\n",admmsg(ret));
	if (ret == CFS_OK)
	    printf ("sverify succeeded. :)\n");
	exit(ret);
}

#ifdef NIXX
#define QS 5
struct {
        int data[QS];
        int head;
        int tail;
} argq = {{0},0,0};

enq(f)
     char f;
{
	argq.tail++;
	argq.tail %= QS;
	if (argq.head==argq.tail) {
		fprintf(stderr,"Can't deal with this\n");
		exit(-2);
	}
	argq.data[argq.tail]=f;
}

deq()
{
	if (argq.head==argq.tail)
		return -1;
	argq.head++;
	argq.head %= QS;
	return(argq.data[argq.head]);
}
#endif /* NIXX */
