/*
    fid.h

    FID related Macros and Constants
    
    Nov. 25, 2000
    Now SCFS is reimplemented as a NFS V2 daemon for better portability. 
    Naomaru Itoi (itoi@eecs.umich.edu)
*/

#ifndef _FID_H
#define _FID_H

#define FID_LEN 8
#define fidcpy(x, y) {\
  x[0] = y[0]; x[1] = y[1]; x[2] = y[2]; x[3] = y[3];\
						       x[4] = y[4]; x[5] = y[5]; x[6] = y[6]; x[7] = y[7];}
#define fidlet(x, y0, y1, y2, y3, y4, y5, y6, y7) {\
  x[0] = y0; x[1] = y1; x[2] = y2; x[3] = y3;\
					       x[4] = y4; x[5] = y5; x[6] = y6; x[7] = y7;}
#define fideq(x, y0, y1, y2, y3, y4, y5, y6, y7)\
(x[0] == y0 && x[1] == y1 &&\
 x[2] == y2 && x[3] == y3 &&\
 x[4] == y4 && x[5] == y5 &&\
 x[6] == y6 && x[7] == y7)
#define fidcmp(x, y)\
(x[0] == y[0] && x[1] == y[1] &&\
 x[2] == y[2] && x[3] == y[3] &&\
 x[4] == y[4] && x[5] == y[5] &&\
 x[6] == y[6] && x[7] == y[7])
#define fid2inode(x) (x[0] << (8*3)) + (x[1] << (8*2)) + (x[2] << (8*1)) + (x[3] << (8*0));

#endif /* _FID_H */
