/*
 * The author of this software is Matt Blaze.
 *              Copyright (c) 1992, 1993, 1994, 1995 by AT&T.
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software and in all copies of the supporting
 * documentation for such software.
 *
 * This software is subject to United States export controls.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

/*
 * client side attach - 1.3.2
 */
#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/time.h>
#ifdef irix
#include <sys/statfs.h>
#else
#ifndef BSD44
#ifdef	ultrix
#include <sys/param.h>
#include <sys/mount.h>
#else
#include <sys/vfs.h>
#endif	/* ultrix */
#else
#ifndef MAXHOSTNAMELEN
#include <sys/param.h>
#endif
#include <sys/mount.h>
#endif	/* BSD44 */
#endif
#include "nfsproto.h"
#include "admproto.h"
#include "cfs.h"

#ifdef SOLARIS2X
/* NOTE!  delete the #define statfs below if this won't compile on
  your solaris configuration */
#define statfs		statvfs
#endif

#ifndef TMOUT		/* default timeout; override in makefile */
#define TMOUT 0
#endif

#ifndef IDLE		/* default idle timer; override in makefile */
#define IDLE 0
#endif

main(argc,argv)
     int argc;
     char **argv;
{
	cfs_attachargs ap;
	int n;
	int status;
	cfsstat ret;
	char dir[1024]; char buf[1024];
	char ins[1024];
#ifdef	ultrix
	struct fs_data sfb;
#define f_blocks  fd_req.btot
#else
	struct statfs sfb;
#endif
	char *flg;
	FILE *fp;
	int cfmt=0;
	static struct timeval tout = {60,0};
	CLIENT *cln;
	int timeout=TMOUT;
	int idle=IDLE;

	ap.highsec=1;
	while (--argc) if (**++argv == '-') {
		for (flg= ++*argv; *flg; ++flg)
			switch (*flg) {
			    case 'l':
				ap.highsec=0;
				break;
			    case 't':	/* absolute timeout */
			    case 'i':	/* idle timer */
				enq(*flg);
				break;
			    default:
				fprintf(stderr,"usage: cattach [-l] [-t timeout] -i [idle]\n");
				exit(1);
			}
	} else {
		switch (deq()) {
		    case 't':
			timeout = atoi(*argv);
			break;
		    case 'i':
			idle = atoi(*argv);
			break;
		    default:	/* should never happen */
			fprintf(stderr,"cattach: internal error\n");
			exit(1);
		}
	}
#ifdef irix
/* or (I hope) more or less any system with the 4 parameter statfs */
    if ((statfs(".",&sfb,sizeof sfb,0)<0) || (sfb.f_blocks==0)) {
        fprintf(stderr,"Sorry, can't attach to a crypted directory\n");
        exit(1);
    }
#else
	if ((statfs(".",&sfb)<0) || (sfb.f_blocks==0)) {
		fprintf(stderr,"Sorry, can't attach to a crypted directory\n");
		exit(1);
	}
#endif
	ap.smsize = LARGESMSIZE;
	ap.idle = idle;
	ap.expire = timeout;
	ap.anon = ap.name[0]=='.';
	ap.uid=getuid();
	if ((cln=clnt_create("localhost",ADM_PROGRAM,ADM_VERSION,"udp"))
	    == NULL) {
		clnt_pcreateerror("adm");
		exit(1);
	}

#ifdef SMARTCARD
	printf ("clnt_call()\n"); 
#endif /* SMARTCARD */
	ap.dirname = "a";
	ap.name = "b";
	ap.key.cipher = 0;
	ap.key.cfs_admkey_u.deskey.pl = 0;
	memcpy (ap.key.cfs_admkey_u.deskey.primary, "aaaaaaaa", 8);
	memcpy (ap.key.cfs_admkey_u.deskey.secondary, "aaaaaaaa", 8);
	
	if ((status = clnt_call(cln,ADMPROC_ATTACH,xdr_cfs_attachargs,&ap,
				xdr_cfsstat,&ret,tout)) != RPC_SUCCESS) {
		clnt_perrno(status);
		exit(1);
	}
	if (ret!=CFS_OK)
		fprintf(stderr,"cattach: %s\n",admmsg(ret));
	exit(ret);
}

#define QS 5
struct {
        int data[QS];
        int head;
        int tail;
} argq = {{0},0,0};

enq(f)
     char f;
{
	argq.tail++;
	argq.tail %= QS;
	if (argq.head==argq.tail) {
		fprintf(stderr,"Can't deal with this\n");
		exit(-2);
	}
	argq.data[argq.tail]=f;
}

deq()
{
	if (argq.head==argq.tail)
		return -1;
	argq.head++;
	argq.head %= QS;
	return(argq.data[argq.head]);
}
