#ifndef _xfs_h
#define _xfs_h

#include <xfs_common.h>
#include <xfs_node.h>

#include <sys/types.h>

/*
 * Filesystem struct.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

struct xfs {
  u_int status;		/* Inited, opened or mounted */
#define XFS_MOUNTED	0x1
  struct vfs *vfsp;
  struct xfs_node *root;
  u_int nnodes;

  struct xfs_node *nodes;		/* replace with hash table */
  int fd;
};

#define VFS_TO_XFS(v)      ((struct xfs *) ((v)->vfs_data))
#define XFS_TO_VFS(x)      ((x)->vfsp)

#define XFS_FROM_VNODE(vp) VFS_TO_XFS((vp)->v_vfsp)
#define XFS_FROM_XNODE(xp) XFS_FROM_VNODE(XNODE_TO_VNODE(xp))

extern struct xfs xfs[];

extern struct vnodeops xfs_vnodeops;

struct xfs_node *xfs_node_find _PARAMS((struct xfs *, struct xfs_handle *));
struct xfs_node *new_xfs_node _PARAMS((struct xfs *, struct xfs_msg_node *));
void free_xfs_node _PARAMS((struct xfs_node *));
void free_all_xfs_nodes _PARAMS((struct xfs *xfsp));

extern int 
xfs_dnlc_enter _PARAMS((struct vnode *, char *, struct vnode *));
extern struct vnode *
xfs_dnlc_lookup _PARAMS((struct vnode *, char *));
extern void xfs_dnlc_purge _PARAMS((void));

void
xfs_attr2vattr _PARAMS((const struct xfs_attr *xa, struct vattr *va));

void
vattr2xfs_attr _PARAMS((const struct vattr *va, struct xfs_attr *xa));

#endif /* _xfs_h */
