
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

#ifndef _xfs_dev_h
#define _xfs_dev_h

#include <xfs_common.h>
#include <sys/uio.h>

extern int xfs_devopen _PARAMS((dev_t dev, int flags));
extern int xfs_devclose _PARAMS((dev_t dev, int flags));
extern int xfs_devread _PARAMS((dev_t dev, struct uio *uiop));
extern int xfs_devwrite _PARAMS((dev_t dev, struct uio *uiop));
extern int xfs_devioctl _PARAMS((dev_t dev, int cmd, caddr_t data, int flags));
extern int xfs_devselect _PARAMS((dev_t dev, int rw));

extern int xfs_install_device _PARAMS((void));
extern int xfs_uninstall_device _PARAMS((void));

extern int xfs_install_filesys _PARAMS((void));
extern int xfs_uninstall_filesys _PARAMS((void));

extern int xfs_install_syscalls _PARAMS((void));
extern int xfs_uninstall_syscalls _PARAMS((void));

extern int xfs_vdstat_filesys _PARAMS((void));
extern int xfs_vdstat_syscalls _PARAMS((void));
extern int xfs_vdstat_device _PARAMS((void));

extern int xfs_message_send _PARAMS((int fd,
				    struct xfs_message_header *message,
				    u_int size));

extern int xfs_message_rpc _PARAMS((int fd,
				    struct xfs_message_header *message,
				    u_int size));

extern int xfs_message_receive _PARAMS((int fd,
					struct xfs_message_header *message,
					u_int size));

extern int xfs_message_wakeup _PARAMS((int fd,
				       struct xfs_message_wakeup *message,
				       u_int size));

extern int
xfs_message_wakeup_data _PARAMS((int fd,
				 struct xfs_message_wakeup_data *message,
				 u_int size));

#endif /* _xfs_dev_h */
