/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mount.h>
#include <sys/mnttab.h>
#include <strings.h>

RCSID("$Id: mount_xfs.c,v 1.5 1998/09/08 09:07:32 assar Exp $");

static void
usage(char *progname)
{
    fprintf (stderr, "Usage: %s device path\n", progname);
    exit (1);
}

int
updatemnttab(char *mountp)
{
    int ret;
    int mnttablock;
    FILE *mnttabfd;
    struct mnttab mp;
    struct timeval tp;
    char timebuf[15];

    mnttablock=open("/etc/.mnttab.lock", O_WRONLY|O_CREAT, 0);
    if (mnttablock < 0) {
	perror("open mnttablock");
	exit(1);
    }

    ret = lockf(mnttablock, F_LOCK, 0);
    if (ret) {
	perror("lockf mnttablock");
	exit(1);
    }

    mnttabfd=fopen("/etc/mnttab", "a");
    if (mnttabfd == NULL) {
	perror("open mnttablock");
	exit(1);
    }

    ret = lockf(fileno(mnttabfd), F_LOCK, 0);
    if (ret) {
	perror("lockf mnttab");
	exit(1);
    }

    gettimeofday(&tp, NULL);
    snprintf(timebuf, 15, "%d", tp.tv_sec);

    mp.mnt_special="xfs";
    mp.mnt_mountp=mountp;
    mp.mnt_fstype="xfs";
    mp.mnt_mntopts="rw";
    mp.mnt_time=timebuf;

    ret = putmntent(mnttabfd, &mp);
    if (ret == EOF) {
	printf("putmntent returned %d\n", ret);
	return ret;
    }

    lockf(fileno(mnttabfd), F_ULOCK, 0);
    fclose(mnttabfd);

    lockf(mnttablock, F_ULOCK, 0);
    close(mnttablock);

    return 0;
}

int
main(int argc, char **argv)
{
    int ret;

    if (argc != 3)
	usage (argv[0]);
    

    ret = mount(argv[1], argv[2], MS_DATA, "xfs", NULL, 0);
    if (ret) {
	perror("mount");
	return ret;
    } else
	updatemnttab(argv[2]);

    return 0;
}
