/*	$OpenBSD: getmntopts.c,v 1.2 1996/06/23 14:31:10 deraadt Exp $	*/
/*	$NetBSD: getmntopts.c,v 1.3 1995/03/18 14:56:58 cgd Exp $	*/
/* $Id: getmntopts.c,v 1.2 1998/07/13 18:48:08 assar Exp $ */

/*-
 * Copyright (c) 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#include <sys/param.h>
#include <sys/mount.h>

#include <err.h>
#include <errno.h>
#include <fstab.h>
#include <stdlib.h>
#include <string.h>

#include "mntopts.h"

void
getmntopts(options, m0, flagp)
    const char *options;
    const struct mntopt *m0;
    int *flagp;
{
    const struct mntopt *m;
    int negative;
    char *opt, *optbuf, *p;

    /* Copy option string, since it is about to be torn asunder... */
    if ((optbuf = strdup(options)) == NULL)
	err(1, " ");

    for (opt = optbuf; (opt = strtok(opt, ",")) != NULL; opt = NULL) {
	/* Check for "no" prefix. */
	if (opt[0] == 'n' && opt[1] == 'o') {
	    negative = 1;
	    opt += 2;
	} else
	    negative = 0;

	/*
	 * for options with assignments in them (ie. quotas)
	 * ignore the assignment as it's handled elsewhere
	 */
	p = strchr(opt, '=');
	if (p)
	    *p = '\0';

	/* Scan option table. */
	for (m = m0; m->m_option != NULL; ++m)
	    if (strcasecmp(opt, m->m_option) == 0)
		break;

	/* Save flag, or fail if option is not recognised. */
	if (m->m_option) {
	    if (negative == m->m_inverse)
		*flagp |= m->m_flag;
	    else
		*flagp &= ~m->m_flag;
	} else
	    errx(1, "-o %s: option not supported", opt);
    }

    free(optbuf);
}
