/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 *
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#include "xfs_locl.h"

RCSID("$Id: xfs_vfsops-common.c,v 1.3 1999/02/20 19:39:42 itoi Exp itoi $");

/*
 * XFS vfs operations.
 */

#include <xfs_common.h>
#include <xfs_message.h>
#include <xfs_fs.h>
#include <xfs_dev.h>
#include <xfs_deb.h>
#include <xfs_syscalls.h>
#include <xfs_vfsops.h>
#include "xfs_scfs.h"
#include "scfs.h"

struct xfs xfs[NXFS];

/* Mount xfs.  Send XFS_MSG_MOUNT to scfsd to reset a smart card. */
  
int
xfs_mount_common(struct mount *mp,
		 const char *user_path,
		 caddr_t user_data,
		 struct nameidata *ndp,
		 struct proc *p)
{
    struct vnode *devvp;
    dev_t dev;
    int error;
    struct vattr vat;
    char path[MAXPATHLEN];
    char data[MAXPATHLEN];
    size_t len;

#ifdef NI
    struct xfs_message_mount msg;
    /*
    struct scfs_mount_data *scfs_md;

    scfs_md = (struct scfs_mount_data *)user_data;
    XFSDEB(XDEBVFOPS, ("xfs_mount called.  USER=%d.  DEVFILE=%s.\n",
		       (int)scfs_md->uid, (char *)scfs_md->devfile));
    */
    XFSDEB(XDEBVFOPS, ("xfs_mount called.\n"));
#endif

    error = copyinstr(user_path, path, MAXPATHLEN, &len);
    if (error)
	return error;

    error = copyinstr(user_data, data, MAXPATHLEN, &len);
    if (error)
	return error;

    XFSDEB(XDEBVFOPS, ("xfs_mount: "
		       "struct mount mp = %p path = '%s' data = '%s'\n",
		       mp, path, data));

#ifdef ARLA_KNFS
    XFSDEB(XDEBVFOPS, ("xfs_mount: mount flags = %x\n", mp->mnt_flag));

    /*
     * mountd(8) flushes all export entries when it starts
     * right now we ignore it (but should not)
     */

    if (mp->mnt_flag & MNT_UPDATE ||
	mp->mnt_flag & MNT_DELEXPORT) {

	XFSDEB(XDEBVFOPS, 
	       ("xfs_mount: ignoreing MNT_UPDATE or MNT_DELEXPORT\n"));
	return 0;
    }
#endif

    NDINIT(ndp, LOOKUP, FOLLOW | LOCKLEAF, UIO_SYSSPACE, data, p);
    error = namei(ndp);
    if (error) {
	XFSDEB(XDEBVFOPS, ("namei failed, errno = %d\n", error));
	return error;
    }

    devvp = ndp->ni_vp;

    if (devvp->v_type != VCHR) {
	vput(devvp);
	XFSDEB(XDEBVFOPS, ("not VCHR (%d)\n", devvp->v_type));
	return ENXIO;
    }
#ifdef __osf__
    VOP_GETATTR(devvp, &vat, ndp->ni_cred, error);
#else
    error = VOP_GETATTR(devvp, &vat, p->p_ucred, p);
#endif
    vput(devvp);
    if (error) {
	XFSDEB(XDEBVFOPS, ("VOP_GETATTR failed, error = %d\n", error));
	return error;
    }
    dev = vat.va_rdev;
    XFSDEB(XDEBVFOPS, ("dev = %d.%d\n", major(dev), minor(dev)));

    /* Check that this device really is an xfs_dev */
    if (major(dev) < 0 || major(dev) > nchrdev) {
	XFSDEB(XDEBVFOPS, ("major out of range (0 < %d < %d)\n", 
			   major(dev), nchrdev));
	return ENXIO;
    }
    if (minor(dev) < 0 || NXFS < minor(dev)) {
	XFSDEB(XDEBVFOPS, ("minor out of range (0 < %d < %d)\n", 
			   minor(dev), NXFS));
	return ENXIO;
    }
#if defined(__NetBSD__) || defined(__OpenBSD__)
    if(!xfs_func_is_devopen(cdevsw[major(dev)].d_open))
	return ENXIO;
#elif defined(__FreeBSD__)
    if (cdevsw[major(dev)] == NULL
	|| !xfs_func_is_devopen(cdevsw[major(dev)]->d_open))
	return ENXIO;
#endif

    if (xfs[minor(dev)].status & XFS_MOUNTED)
	return EBUSY;

    xfs[minor(dev)].status = XFS_MOUNTED;
    xfs[minor(dev)].mp = mp;
    xfs[minor(dev)].root = 0;
    xfs[minor(dev)].nnodes = 0;
    xfs[minor(dev)].fd = minor(dev);

    VFS_TO_XFS(mp) = &xfs[minor(dev)];

#if defined(HAVE_KERNEL_VFS_GETNEWFSID)
#if defined(HAVE_TWO_ARGUMENT_VFS_GETNEWFSID)
    vfs_getnewfsid(mp, MOUNT_AFS);
#else
    vfs_getnewfsid(mp);
#endif
#elif defined(__NetBSD__) || defined(__OpenBSD__)
    getnewfsid(mp, makefstype(MOUNT_AFS));
#elif defined(__FreeBSD__)
    getnewfsid(mp, MOUNT_AFS);
    mp->mnt_stat.f_type = MOUNT_AFS;
#endif

    mp->mnt_stat.f_bsize = DEV_BSIZE;
#ifndef __osf__
    mp->mnt_stat.f_iosize = DEV_BSIZE;
    mp->mnt_stat.f_owner = 0;
#endif
    mp->mnt_stat.f_blocks = 4711 * 4711;
    mp->mnt_stat.f_bfree = 4711 * 4711;
    mp->mnt_stat.f_bavail = 4711 * 4711;
    mp->mnt_stat.f_files = 4711;
    mp->mnt_stat.f_ffree = 4711;
    mp->mnt_stat.f_flags = mp->mnt_flag;

#ifdef __osf__
    mp->mnt_stat.f_fsid.val[0] = dev;
    mp->mnt_stat.f_fsid.val[1] = MOUNT_XFS;
	
    MALLOC(mp->m_stat.f_mntonname, char *, strlen(path) + 1, 
	   M_PATHNAME, M_WAITOK);
    strcpy(mp->m_stat.f_mntonname, path);

    MALLOC(mp->m_stat.f_mntfromname, char *, sizeof("arla"),
	   M_PATHNAME, M_WAITOK);
    strcpy(mp->m_stat.f_mntfromname, "arla");
#else /* __osf__ */
    strncpy(mp->mnt_stat.f_mntonname,
	    path,
	    sizeof(mp->mnt_stat.f_mntonname));

    strncpy(mp->mnt_stat.f_mntfromname,
	    /*"arla",*/
	    "scfs",
	    sizeof(mp->mnt_stat.f_mntfromname));

#if defined(__NetBSD__) || defined(__OpenBSD__)
    strncpy(mp->mnt_stat.f_fstypename,
	    "xfs",
	    sizeof(mp->mnt_stat.f_fstypename));
#endif
#endif /* __osf__ */

#ifdef NI
    XFSDEB(XDEBVFOPS, ("minor number=%d.\n", xfs[minor(dev)].fd));
    msg.header.opcode = XFS_MSG_MOUNT;
    error = xfs_message_rpc(xfs[minor(dev)].fd, &msg.header, sizeof(msg));
    XFSDEB(XDEBVFOPS, ("xfs_mount: xfs_message_rpc returns %d (ENODEV=%d, ENOMEM=%d\n", error, ENODEV, ENOMEM));
    if (error != 0) {
      XFSDEB(XDEBVFOPS, ("xfs_mount failed.  Call xfs_unmount_common()."));
      xfs_unmount_common_org(mp, MNT_FORCE);
      return ENXIO;
    }
#endif /* NI */

    return 0;
}

int
xfs_unmount_common_org(struct mount *mp, int mntflags)
{
    struct xfs *xfsp = VFS_TO_XFS(mp);
    int flags = 0;
    int error;

    if (mntflags & MNT_FORCE) {
#ifdef HAVE_KERNEL_DOFORCE
	extern int doforce;
	if (!doforce)
	    return EINVAL;
#endif
	flags |= FORCECLOSE;
    }

    error = free_all_xfs_nodes(xfsp, flags);
    if (error)
	return error;

    xfsp->status = 0;
    XFS_TO_VFS(xfsp) = NULL;
    return 0;
}

int
xfs_unmount_common(struct mount *mp, int mntflags)
{
    struct xfs *xfsp = VFS_TO_XFS(mp);
    int flags = 0;
    int error;
    struct xfs_message_unmount msg;

    XFSDEB(XDEBVFOPS, ("xfs_unmount_common is called\n"));

    /*if (XFS_TO_VFS(xfsp) != NULL){*/
    msg.header.opcode = XFS_MSG_UNMOUNT;
    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
    XFSDEB(XDEBVFOPS, ("xfs_unmount_common: xfs_message_rpc returns %d (ENODEV=%d, ENOMEM=%d\n", error, ENODEV, ENOMEM));
    if (error != 0) {
      XFSDEB(XDEBVFOPS, ("xfs_unmount failed.  Error %d.  Ignore ...",
			 error));
    }
    /*}*/
    
    if (mntflags & MNT_FORCE) {
#ifdef HAVE_KERNEL_DOFORCE
      extern int doforce;
      if (!doforce)
	return EINVAL;
#endif
      flags |= FORCECLOSE;
    }
    
    error = free_all_xfs_nodes(xfsp, flags);
    if (error)
	return error;

    xfsp->status = 0;
    XFS_TO_VFS(xfsp) = NULL;

    /*
    if (mntflags & SCFSMNT_MNTAGAIN) {
      struct xfs_message_unmount msg;
      
      XFSDEB(XDEBVFOPS, ("I will mount myself again\n"));
      
      msg.header.opcode = XFS_MSG_MNTAGAIN;
      error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
      XFSDEB(XDEBVFOPS, ("xfs_unmount_common: xfs_message_rpc returns %d (ENODEV=%d, ENOMEM=%d\n", error, ENODEV, ENOMEM));
      if (error != 0) {
	XFSDEB(XDEBVFOPS, ("xfs_unmount failed.  Error %d.  Ignore ...",
			   error));
      }
    }
    */

    return 0;
}

int
xfs_root_common(struct mount *mp, struct vnode **vpp, struct ucred *cred)
{
    struct xfs *xfsp = VFS_TO_XFS(mp);
    struct xfs_message_getroot msg;
    int error;

    XFSDEB(XDEBVFOPS, ("xfs_root_common is called\n"));

    do {
	if (xfsp->root != NULL) {
	    *vpp = XNODE_TO_VNODE(xfsp->root);
	    VREF(*vpp);
	    return 0;
	}
	msg.header.opcode = XFS_MSG_GETROOT;
	msg.cred.uid = cred->cr_uid;
	msg.cred.pag = xfs_get_pag(cred);
	error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
	if (error == 0)
	    error = ((struct xfs_message_wakeup *) & msg)->error;
    } while (error == 0);
    /*
     * Failed to get message through, need to pretend that all went well
     * and return a fake dead vnode to be able to unmount.
     */

    if ((error = make_dead_vnode(mp, vpp)))
	return error;

    (*vpp)->v_flag |= VROOT;
    return 0;
}
