/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 *
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#include "xfs_locl.h"

RCSID("$Id: xfs_vfsops-bsd.c,v 1.1 1998/12/30 19:38:46 itoi Exp itoi $");

/*
 * XFS vfs operations.
 */

#include <xfs_common.h>
#include <xfs_message.h>
#include <xfs_fs.h>
#include <xfs_dev.h>
#include <xfs_deb.h>
#include <xfs_vfsops.h>
#include <xfs_vnodeops.h>

static int
xfs_mount(struct mount * mp,
	  const char *user_path,
	  void *user_data,
	  struct nameidata * ndp,
	  struct proc * p)
{
    return xfs_mount_common(mp, user_path, user_data, ndp, p);
}

static int
xfs_start(struct mount * mp, int flags, struct proc * p)
{
    XFSDEB(XDEBVFOPS, ("xfs_start mp = %p, flags = %d, proc = %p\n", 
		       mp, flags, p));
    return 0;
}


static int
xfs_unmount(struct mount * mp, int mntflags, struct proc *p)
{
    XFSDEB(XDEBVFOPS, ("xfs_umount: mp = %p, mntflags = %d, proc = %p\n", 
		       mp, mntflags, p));
    return xfs_unmount_common(mp, mntflags);
}

static int
xfs_root(struct mount *mp, struct vnode **vpp)
{
    XFSDEB(XDEBVFOPS, ("xfs_root mp = %p\n", mp));
    return xfs_root_common(mp, vpp, curproc->p_ucred);
}

static int
xfs_quotactl(struct mount *mp, int cmd, uid_t uid, caddr_t arg, struct proc *p)
{
    XFSDEB(XDEBVFOPS, ("xfs_quotactl: mp = %p, cmd = %d, uid = %u, "
		       "arg = %p, proc = %p\n", 
		       mp, cmd, uid, arg, p));
    return EOPNOTSUPP;
}

static int
xfs_statfs(struct mount *mp, struct statfs *sbp, struct proc *p)
{
    XFSDEB(XDEBVFOPS, ("xfs_statfs: mp = %p, sbp = %p, proc = %p\n", 
		       mp, sbp, p));
    bcopy(&mp->mnt_stat, sbp, sizeof(*sbp));
    return 0;
}

static int
xfs_sync(struct mount *mp, int waitfor, struct ucred *cred, struct proc *p)
{
    XFSDEB(XDEBVFOPS, ("xfs_sync: mp = %p, waitfor = %d, "
		       "cred = %p, proc = %p\n",
		       mp, waitfor, cred, p));
    return 0;
}

static int
xfs_vget(struct mount * mp,
	 ino_t ino,
	 struct vnode ** vpp)
{
    XFSDEB(XDEBVFOPS, ("xfs_vget\n"));
    return EOPNOTSUPP;
}

/* fhtovp = file handle to vnode pointer?
   Anyway, I just leave it like this.  Maybe it should be NOTSUPP. */
   
static int
xfs_fhtovp(struct mount * mp,
	   struct fid * fhp,
	   struct mbuf * nam,
	   struct vnode ** vpp,
	   int *exflagsp,
	   struct ucred ** credanonp)
{
#ifdef ARLA_KNFS
    static struct ucred fhtovpcred;
    struct netcred *np = NULL;
    struct xfs_node *xn;
    struct vnode *vp;
    xfs_handle handle;
    int error;

    XFSDEB(XDEBVFOPS, ("xfs_fhtovp\n"));

    if (fhp->fid_len != 16) {
	printf("xfs_fhtovp: *PANIC* got a invalid length of a fid\n");
	return EINVAL;
    }

    /* XXX: Should see if we is exported to this client */
#if 0
    np = vfs_export_lookup(mp, &ump->um_export, nam);
    if (np == NULL)
	return EACCES;
#endif

    memcpy(&handle, fhp->fid_data, sizeof(handle));
    XFSDEB(XDEBVFOPS, ("xfs_fhtovp: fid: %d.%d.%d.%d\n", 
		       handle.a, handle.d, handle.c, handle.d));

    XFSDEB(XDEBVFOPS, ("xfs_fhtovp: xfs_vnode_find\n"));
    xn = xfs_node_find(&xfs[0], &handle); /* XXX: 0 */

    if (xn == NULL) {
	struct xfs_message_getattr msg;

        error = xfs_getnewvnode(xfs[0].mp, &vp, handle);
        if (error)
            return error;
	
	xfs_do_vget(vp, 0, current);

    } else {
	/* XXX access ? */
	vp = XNODE_TO_VNODE(xn);

	/* XXX wrong ? (we tell arla below) */
        if (vp->v_usecount <= 0) 
	    xfs_do_vget(vp, 0, current);
	else
	    VREF(vp);
	error = 0;
    }

    if (error == 0) {
	fhtovpcred.cr_uid = 0;
	fhtovpcred.cr_gid = 0;
	fhtovpcred.cr_ngroups = 0;
      
	*vpp = vp;
#ifdef MNT_EXPUBLIC
	*exflagsp = MNT_EXPUBLIC;
#else
	*exflagsp = 0;
#endif
	*credanonp = &fhtovpcred;

	XFSDEB(XDEBVFOPS, ("xfs_fhtovp done\n"));

	/* 
	 * XXX tell arla about this node is hold by nfsd.
	 * There need to be code in xfs_write too.
	 */
    } else
	XFSDEB(XDEBVFOPS, ("xfs_fhtovp failed (%d);", error));

    return error;
#else
    return EOPNOTSUPP;
#endif
}

/* vptofh = vnode ointer to file handle? 
   Anyway, I just leave it like this.  Maybe it should be NOTSUPP. */

static int
xfs_vptofh(struct vnode * vp,
	   struct fid * fhp)
{
#ifdef ARLA_KNFS
    struct xfs_node *xn;
    XFSDEB(XDEBVFOPS, ("xfs_vptofh\n"));

    if (MAXFIDSZ < 16)
	return EOPNOTSUPP;

    xn = VNODE_TO_XNODE(vp);

    if (xn == NULL)
	return EINVAL;

    fhp->fid_len = 16;
    memcpy(fhp->fid_data, &xn->handle,  16);

    return 0;
#else
    XFSDEB(XDEBVFOPS, ("xfs_vptofh\n"));
    return EOPNOTSUPP;
#endif
}

/* 
 * xfs complete dead vnodes implementaion.  
 *
 * this is because the dead_vnodeops_p is _not_ filesystem, but rather
 * a part of the vfs-layer.  
 */

static int
xfs_dead_lookup(struct vop_lookup_args * ap)
     /* struct vop_lookup_args {
	struct vnodeop_desc *a_desc;
	struct vnode *a_dvp;
	struct vnode **a_vpp;
	struct componentname *a_cnp;
}; */
{
    *ap->a_vpp = NULL;
    return ENOTDIR;
}

static vop_t **xfs_dead_vnodeop_p;

static struct vnodeopv_entry_desc xfs_dead_vnodeop_entries[] = {
    {&vop_default_desc, (vop_t *) xfs_eopnotsupp},
#ifdef HAVE_VOP_LOOKUP
    {&vop_lookup_desc,	(vop_t *) xfs_dead_lookup},
#endif
#ifdef HAVE_VOP_RECLAIM
    {&vop_reclaim_desc, (vop_t *) xfs_returnzero},
#endif
    {NULL, NULL}};


static struct vnodeopv_desc xfs_dead_vnodeop_opv_desc =
{&xfs_dead_vnodeop_p, xfs_dead_vnodeop_entries};

#ifdef VNODEOP_SET
VNODEOP_SET(xfs_dead_vnodeop_opv_desc);
#endif

#if defined(__NetBSD__) || defined(__OpenBSD__)

extern struct vnodeopv_desc xfs_vnodeop_opv_desc;

#ifdef HAVE_STRUCT_VFSOPS_VFS_OPV_DESCS
struct vnodeopv_desc *xfs_vnodeopv_descs[] = {
    &xfs_vnodeop_opv_desc,
    NULL,
};
#endif

static void
xfs_init(void)
{
    XFSDEB(XDEBVFOPS, ("xfs_init\n"));
#if defined(HAVE_KERNEL_VFS_OPV_INIT_DEFAULT) && \
    defined(HAVE_KERNEL_VFS_OPV_INIT_EXPLICIT) && \
    !defined(HAVE_STRUCT_VFSOPS_VFS_OPV_DESCS)
	    
    vfs_opv_init_explicit(&xfs_vnodeop_opv_desc);
    vfs_opv_init_default(&xfs_vnodeop_opv_desc);
    vfs_opv_init_explicit(&xfs_dead_vnodeop_opv_desc);
    vfs_opv_init_default(&xfs_dead_vnodeop_opv_desc);
#endif
}

/* I leave it like this. */

static struct vfsops xfs_vfsops = {
#ifdef HAVE_STRUCT_VFSOPS_VFS_NAME
    "xfs",
#endif
    xfs_mount,
    xfs_start,
    xfs_unmount,
    xfs_root,
    xfs_quotactl,
    xfs_statfs,
    xfs_sync,
    xfs_vget,
    xfs_fhtovp,
    xfs_vptofh,
    xfs_init,
#ifdef HAVE_STRUCT_VFSOPS_VFS_UNINIT
    xfs_uninit,
#endif
#ifdef HAVE_STRUCT_VFSOPS_VFS_OID
    NULL,
#endif
#ifdef HAVE_STRUCT_VFSOPS_VFS_OPV_DESCS
    0,
    0,
    xfs_vnodeopv_descs,
#endif
};

/*
 *
 */

/* ? So this is not doing anything? */

static int
xfs_uprintf_filsys(void)
{
#if 0
    {
	int i;

	uprintf("Currently loaded filesystems are:\n");
	for (i = 0; i < nvfssw; i++)
	    if (vfssw[i] != NULL)
		uprintf("vfssw[%d] = { \"%s\", %p}\n",
			i, vfssw[i]->vfs_name, vfssw[i]);
    }
#endif
#if 0
    {
	int i;
	struct vnode *t;

	for (i = 0; i < NXFS; i++) {
	    uprintf("Current xfs_nodes on xfs[%d] are:\n", i);

	    if (XFS_TO_VFS(&xfs[i]) == NULL)
		continue;

	    t = XFS_TO_VFS(&xfs[i])->mnt_vnodelist.lh_first;
	    while (t != NULL) {
		struct xfs_node *x = VNODE_TO_XNODE(t);

		uprintf("%d.%d.%d.%d(%d) ",
			x->handle.a,
			x->handle.b,
			x->handle.c,
			x->handle.d,
			x->vn->v_usecount);
		uprintf(" !\n");
		t = t->v_mntvnodes.le_next;
	    }
	}
    }
#endif
    return 0;
}

#elif defined(__FreeBSD__)

static int xfs_init (struct vfsconf *);
static int xfs_uninit (struct vfsconf *);

extern struct vnodeopv_desc xfs_vnodeop_opv_desc;

static struct vfsops xfs_vfsops = {
    xfs_mount,
    xfs_start,
    xfs_unmount,
    xfs_root,
    xfs_quotactl,
    xfs_statfs,
    xfs_sync,
    xfs_vget,
    xfs_fhtovp,
    xfs_vptofh,
    xfs_init,
#ifdef HAVE_STRUCT_VFSOPS_VFS_UNINIT
    xfs_uninit,
#endif
#ifdef HAVE_STRUCT_VFSOPS_VFS_OID
    NULL,
#endif
};

static struct vfsconf xfs_vfc = {
    &xfs_vfsops,
    "xfs",
    0,
    0,
    0
};

/*
 *
 */

static int
xfs_init(struct vfsconf *vfc)
{
    XFSDEB(XDEBVFOPS, ("xfs_init\n"));
#if __FreeBSD_version >= 300000
    vfs_opv_init (&xfs_vnodeop_opv_desc);
    vfs_opv_init (&xfs_dead_vnodeop_opv_desc);
#endif
    return 0;
}

/*
 *
 */

static int
xfs_uninit(struct vfsconf *vfc)
{
    XFSDEB(XDEBVFOPS, ("xfs_uninit\n"));
    return 0;
}

/*
 *
 */
static int
xfs_uprintf_filsys(void)
{
#if 0
    {
	int i;

	uprintf("Currently loaded filesystems are:\n");
	for (i = 0; i < MOUNT_MAXTYPE; i++)
	    if (vfsconf[i]->vfc_name)
		uprintf("vfsconf[%d] = { \"%s\", %p}\n",
			i, vfsconf[i]->vfc_name, vfssw[i]);
    }
#endif
#if 0
    {
	int i;

	struct vnode *t;

	for (i = 0; i < NXFS; i++) {
	    uprintf("Current xfs_nodes on xfs[%d] are:\n", i);

	    if (XFS_TO_VFS(&xfs[i]) == NULL)
		continue;

	    t = XFS_TO_VFS(&xfs[i])->mnt_vnodelist.lh_first;
	    while (t != NULL) {
		struct xfs_node *x = VNODE_TO_XNODE(t);

		uprintf("%d.%d.%d.%d(%d) ",
			x->handle.a,
			x->handle.b,
			x->handle.c,
			x->handle.d,
			x->vn->v_usecount);
		uprintf(" !\n");
		t = t->v_mntvnodes.le_next;
	    }
	}
    }
#endif
    return 0;
}

#endif

/*
 * Install and uninstall filesystem.
 */

#if defined(HAVE_KERNEL_VFS_ATTACH)

int
xfs_install_filesys(void)
{
    return vfs_attach(&xfs_vfsops);
}

int
xfs_uninstall_filesys(void)
{
    return vfs_detach(&xfs_vfsops);
}

#elif defined(HAVE_KERNEL_VFS_REGISTER)

int
xfs_install_filesys(void)
{
    return vfs_register(&xfs_vfc);
}

int
xfs_uninstall_filesys(void)
{
    return vfs_unregister(&xfs_vfc);
}

#elif defined(HAVE_VFSSW)
static int vfs_offset;

int
xfs_install_filesys(void)
{
    int i;

    XFSDEB(XDEBLKM, ("Got to begining of loading xfs_filesys\n"));
    XFSDEB(XDEBLKM, ("Checking for double loading of filesystem\n"));

    /* make sure there's no VFS in the table with this name */
    for (i = 0; i < nvfssw; i++)
	if (vfssw[i] != (struct vfsops *) 0 &&
	    strncmp(vfssw[i]->vfs_name,
		    xfs_vfsops.vfs_name,
		    MFSNAMELEN) == 0)
	    return (EEXIST);

    XFSDEB(XDEBLKM, ("Searching the last available slot\n"));

    /* pick the last available empty slot */
    for (i = nvfssw - 1; i >= 0; i--)
	if (vfssw[i] == (struct vfsops *) 0)
	    break;
    if (i < 0) {		       /* or if none, punt */
	return (EINVAL);
    }
    /*
     * Set up file system
     */
    XFSDEB(XDEBLKM, ("Setting up filesystem\n"));

    vfssw[i] = &xfs_vfsops;
    vfssw[i]->vfs_refcount = 0;

    /*
     * Call init function for this VFS...
     */
    XFSDEB(XDEBLKM, ("Doing vfs_init()\n"));
    (*(vfssw[i]->vfs_init)) ();

    /* done! */
    vfs_offset = i;

    XFSDEB(XDEBLKM, ("Using VFS slot %d\n", i));

    return 0;
}

int
xfs_uninstall_filesys(void)
{
    /* replace current slot contents with old contents */
    vfssw[vfs_offset] = (struct vfsops *) 0;

    return 0;
}

#elif defined(MOUNT_MAXTYPE)

extern struct vnodeopv_desc xfs_vnodeop_opv_desc;

int
xfs_install_filesys(void)
{
    int i;
    struct vnodeopv_desc *foo[] = {&xfs_vnodeop_opv_desc, NULL};
    struct vnodeopv_desc *dead_foo[] = {&xfs_dead_vnodeop_opv_desc, NULL};

    for (i = 0; i < MOUNT_MAXTYPE; i++)
	if (strcmp(vfsconf[i]->vfc_name, xfs_vfc.vfc_name) == 0)
	    return EEXIST;

    for (i = MOUNT_MAXTYPE - 1; i >= 0; --i)
	if (vfsconf[i] == &void_vfsconf)
	    break;
    if (i < 0) {
	uprintf("failed to find free VFS slot\n");
	return EINVAL;
    }
    XFSDEB(XDEBVFOPS, ("Using VFS slot %d\n", i));

    xfs_vfc.vfc_index = i;
    vfsconf[i] = &xfs_vfc;
    vfssw[i] = xfs_vfc.vfc_vfsops;

    *(foo[0]->opv_desc_vector_p) = NULL;
    vfs_opv_init(foo);
    *(dead_foo[0]->opv_desc_vector_p) = NULL;
    vfs_opv_init(dead_foo);

    (*(vfssw[xfs_vfc.vfc_index]->vfs_init)) ();
    return 0;
}

#if 0
int
xfs_may_uninstall_filesys (void)
{
    if (vfssw[vfs_offset]->vfc_refcount)
	return EBUSY;
    return 0;
}
#endif

int
xfs_uninstall_filesys(void)
{
    int i;

    /* Check for open, mounted and active vnodes */
    for (i = 0; i < NXFS; i++)
	if (xfs[i].nnodes)
	    printf("Warning (error really): There are active vnodes!\n");
    i = xfs_vfc.vfc_index;

    if (vfsconf[i]->vfc_refcount)
	printf("Warning: refcount != 0\n");

    vfsconf[i] = &void_vfsconf;
    vfssw[i] = NULL;
    return 0;
}

#else /* !HAVE_KERNEL_VFS_ATTACH && !HAVE_VFSSW && !MOUNT_MAXTYPE */

int
xfs_install_filesys(void)
{
    struct vfsconf *vfsp;
    struct vfsconf **vfspp;


    /* Check if filesystem already known */
    for (vfspp = &vfsconf, vfsp = vfsconf;
	 vfsp;
	 vfspp = &vfsp->vfc_next, vfsp = vfsp->vfc_next)
	if (strncmp(vfsp->vfc_name,
		    "xfs", MFSNAMELEN) == 0)
	    return (EEXIST);

    /* Allocate and initialize */
    vfsp = xfs_alloc (sizeof(struct vfsconf));

    vfsp->vfc_vfsops = &xfs_vfsops;
    strncpy(vfsp->vfc_name, "xfs", MFSNAMELEN);
    vfsp->vfc_typenum = 0;
    vfsp->vfc_refcount = 0;
    vfsp->vfc_flags = 0;
#ifdef HAVE_STRUCT_VFSCONF_VFC_MOUNTROOT
    vfsp->vfc_mountroot = 0;
#endif
    vfsp->vfc_next = NULL;

    maxvfsconf++;

    /* Add to the end of the list */
    *vfspp = vfsp;

    /* Call vfs_init() */
    XFSDEB(XDEBVFOPS, ("calling vfs_init\n"));
    (*(vfsp->vfc_vfsops->vfs_init)) (vfsp);

    /* done! */

    return 0;
}

int
xfs_uninstall_filesys(void)
{
    struct vfsconf *vfsp;
    struct vfsconf **vfspp;


    /* Find our vfsconf struct */
    for (vfspp = &vfsconf, vfsp = vfsconf;
	 vfsp;
	 vfspp = &vfsp->vfc_next, vfsp = vfsp->vfc_next)
	if (strncmp(vfsp->vfc_name,
		    "xfs",
		    MFSNAMELEN) == 0)
	    break;

    if (!vfsp)			       /* Not found */
	return (EEXIST);

    if (vfsp->vfc_refcount)	       /* In use */
	return (EBUSY);

    /* Remove from list and free  */
    *vfspp = vfsp->vfc_next;
    xfs_free(vfsp, sizeof(struct vfsconf));

    maxvfsconf--;

    return 0;
}
#endif /* HAVE_VFSSW */

int
xfs_stat_filesys(void)
{
    return xfs_uprintf_filsys();
}

#if 0
/*
 * Install and uninstall filesystem.
 */

int
xfs_install_filesys(void)
{
    struct vfsconf *vfsp;

    for(vfsp = vfsconf; vfsp != NULL; vfsp = vfsp->vfc_next)
	if(strcmp(vfsp->vfc_name, xfs_vfc.vfc_name) == 0)
	    return EEXIST;

    xfs_vfc.vfc_typenum = maxvfsconf++;

    vfsp->vfc_next   = &xfs_vfc;
    xfs_vfc.vfc_next = NULL;

    *(foo[0]->opv_desc_vector_p) = NULL;
    vfs_opv_init(foo);
    (*(xfs_vfc.vfc_vfsops->vfs_init))(&xfs_vfc);
    return 0;
}

int
xfs_uninstall_filesys(void)
{
    struct vfsconf *vfsp, *prev, *this;
    int i;
    int maxtypenum;

    /* Check for open, mounted and active vnodes */
    for (i = 0; i < NXFS; i++)
	if (xfs[i].nnodes)
	    printf("Warning (error really): There are active vnodes!\n");

    prev = NULL;
    this = NULL;
    maxtypenum = 0;
    for(vfsp = vfsconf; vfsp != NULL; vfsp = vfsp->vfc_next) {
	if(strcmp(vfsp->vfc_name, xfs_vfc.vfc_name) == 0) {
	    this = vfsp;
	    break;
	}
	if (maxtypenum <  vfsp->vfc_typenum)
	    maxtypenum = vfsp->vfc_typenum;
	prev = vfsp;
    }
    if (this == NULL)
	return EINVAL;

    if(vfsp->vfc_refcount)
	printf("Warning: refcount != 0\n");

    prev->vfc_next = xfs_vfc.vfc_next;

    maxvfsconf = maxtypenum + 1;
    return 0;
}

int
xfs_stat_filesys(void)
{
    return xfs_uprintf_filsys();
}

#endif

int
make_dead_vnode(struct mount *mp, struct vnode **vpp)
{
    int error;

    XFSDEB(XDEBNODE, ("make_dead_vnode mp = %p\n", mp));

    error = getnewvnode(VT_NON, mp, xfs_dead_vnodeop_p, vpp);
    if (error == 0)
	(*vpp)->v_data = NULL;

    return error;
}

int
xfs_may_uninstall_filesys(void)
{
    /* maybe brutal unloading would be better? */

#ifdef HAVE_STRUCT_VFSCONF_VFS_REFCOUNT
    if (vfssw[vfs_offset]->vfs_refcount != 0)
	return EBUSY;
#endif

#if 0
#if defined(HAVE_VFSSW)
    if (vfssw[vfs_offset]->vfs_refcount != 0)
	return EBUSY;
#else
    if (vfssw[vfs_offset]->vfs_refcount != 0)
	return EBUSY;
#endif
#endif
    return 0;
}

/*
 *
 */

int
xfs_fhlookup (struct proc *proc,
	      fsid_t fsid,
	      long fileid,
	      long gen,
	      struct vnode **vpp)
{
    int error;
    struct mount *mp;
    struct ucred *cred = proc->p_ucred;
    struct vattr vattr;

    XFSDEB(XDEBVFOPS, ("xfs_fhlookup: fileid = %ld\n",
		       fileid));

    error = suser (cred, NULL);
    if (error)
	return EPERM;

#ifdef HAVE_KERNEL_VFS_GETVFS
    mp = vfs_getvfs (&fsid);
#else
    mp = getvfs (&fsid);
#endif
    if (mp == NULL)
	return ENXIO;

    error = VFS_VGET(mp, fileid, vpp);

    if (error)
	return error;

    error = VOP_GETATTR(*vpp, &vattr, cred, proc);
    if (error) {
	vput(*vpp);
	return error;
    }

    if (vattr.va_gen != gen) {
	vput(*vpp);
	return ENOENT;
    }

#ifdef HAVE_KERNEL_VFS_OBJECT_CREATE
    if ((*vpp)->v_type == VREG && (*vpp)->v_object == NULL)
	vfs_object_create (*vpp, proc, proc->p_ucred, TRUE);
#endif
    return 0;
}

/*
 *
 */

int
xfs_fhopen (struct proc *proc,
	    fsid_t fsid,
	    long fileid,
	    long gen,
	    int user_flags,
	    int *retval)
{
    int error;
    struct vnode *vp;
    struct ucred *cred = proc->p_ucred;
    int flags = FFLAGS(user_flags);
    int index;
    struct file *fp;
    extern struct fileops vnops;

    XFSDEB(XDEBVFOPS, ("xfs_fhopen: fileid = %ld, flags = %d\n",
		       fileid, user_flags));

    error = xfs_fhlookup (proc, fsid, fileid, gen, &vp);
    if (error)
	return error;

    error = VOP_OPEN(vp, flags, cred, proc);
    if (error)
	goto out;

    error = falloc(proc, &fp, &index);
    if (error)
	goto out;

    if (flags & FWRITE)
        vp->v_writecount++;

#if __FreeBSD_version >= 300000
    if (vp->v_type == VREG) {
	if ((error = vfs_object_create(vp, proc, proc->p_cred->pc_ucred, 1)) != 0)
	    goto out;
    }
#endif

    fp->f_flag = flags & FMASK;
    fp->f_type = DTYPE_VNODE;
    fp->f_ops  = &vnops;
    fp->f_data = (caddr_t)vp;
    xfs_vfs_unlock(vp, proc);
    *retval = index;
    return 0;
out:
    vput(vp);
    return error;
}
