/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 *
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#include "mount_locl.h"

RCSID("$Id: mount_xfs.c,v 1.12 1998/10/31 15:16:56 lha Exp $");

static const struct mntopt mopts[] = {
    MOPT_STDOPTS,
    MOPT_ASYNC,
    MOPT_SYNC,
    MOPT_UPDATE,
    MOPT_RELOAD,
    {NULL}
};

static void
usage(void)
{
    fprintf(stderr, "Usage: %s [-o options] [-F flags] device path\n", __progname);
    exit(1);
}

#if defined(HAVE_GETVFSBYNAME) && defined(HAVE_VFSISLOADABLE) && defined(HAVE_VFSLOAD)

/*
 * Try to load the kernel module if we have getvfsbyname (currently
 * only FreeBSD)
 */

#ifdef HAVE_GETVFSBYNAME_TWO_ARGS

static int
get_vfc_index (const char *vfc_name)
{
    int ret;
    struct vfsconf vfc;
    
    ret = getvfsbyname (vfc_name, &vfc);
    if (ret != 0 && errno == ENOENT && vfsisloadable (vfc_name)) {
	if (vfsload (vfc_name))
	    err (1, "vfsload(%s)", vfc_name);
	endvfsent ();
	ret = getvfsbyname (vfc_name, &vfc);
    }
    if (ret != 0)
	err (1, "%s filesystem not available", vfc_name);
    return vfc.vfc_typenum;
}

#else

static int
get_vfc_index (const char *vfc_name)
{
    struct vfsconf *vfc;

    vfc = getvfsbyname (vfc_name);
    if (vfc == NULL && vfsisloadable (vfc_name)) {
	if (vfsload (vfc_name))
	    err (1, "vfsload(%s)", vfc_name);
	endvfsent ();
	vfc = getvfsbyname (vfc_name);
    }
    if (vfc == NULL)
	err (1, "%s filesystem not available", vfc_name);
    return vfc->vfc_index;
}

#endif

#else /* HAVE_GETVFSBYNAME */

#define get_vfc_index(x) MOUNT_XFS 

#endif

int
main(int argc, char **argv)
{
    int error;
    int ch, mntflags = 0;

    optind = 1;
#ifdef HAVE_OPTRESET
    optreset = 1;
#endif
    set_progname(argv[0]);
    while ((ch = getopt(argc, argv, "o:F:")) != -1)
	switch (ch) {
	case 'o':
	    getmntopts(optarg, mopts, &mntflags);
	    break;
	case 'F':
	    mntflags = atoi(optarg);
	    break;
	case '?':
	default:
	    usage();
	}

    argc -= optind;
    argv += optind;

    if (argc != 2)
	usage();

    /*printf("mount(%s, %s, %d, %s)\n",
      get_vfc_index ("xfs"), argv[1], mntflags, argv[0]);*/
    
    error = mount(get_vfc_index ("xfs"), argv[1], mntflags, argv[0]);

    if (error != 0)
	err(1, "mount");

    return 0;
}
