/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 *
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/*
 * XFS operations.
 */

#include "xfs_locl.h"
#include <xfs_message.h>
#include <xfs_common.h>
#include <xfs_fs.h>
#include <xfs_dev.h>
#include <xfs_deb.h>
#include <xfs_syscalls.h>
#include <xfs_vnodeops.h>

RCSID("$Id: xfs_vnodeops-common.c,v 1.9 1999/01/18 22:03:02 itoi Exp itoi $");

int
xfs_open_valid(struct vnode * vp, struct ucred * cred, u_int tok)
{
  XFSDEB(XDEBVFOPS, ("xfs_open_valid just returns success.\n"));
  return 0;
#ifdef NIXX
    struct xfs *xfsp = XFS_FROM_VNODE(vp);
    struct xfs_node *xn = VNODE_TO_XNODE(vp);
    int error = 0;

    XFSDEB(XDEBVFOPS, ("xfs_open_valid\n"));

    do {
	if (!XFS_TOKEN_GOT(xn, tok)) {
	    struct xfs_message_open msg;

	    msg.header.opcode = XFS_MSG_OPEN;
	    /*
	    msg.cred.uid = cred->cr_uid;
	    msg.cred.pag = xfs_get_pag(cred);
	    */
	    fidcpy(msg.handle, xn->handle);
	    msg.tokens = tok;
	    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
	    if (error == 0)
		error = ((struct xfs_message_wakeup *) & msg)->error;
	} else {
	    goto done;
	}
    } while (error == 0);

done:
    XFSDEB(XDEBVFOPS, ("xfs_open_valid: error = %d\n", error));

    return error;
#endif /* NIXX */
}

int
xfs_attr_valid(struct vnode * vp, struct ucred * cred, u_int tok)
{
    struct xfs *xfsp = XFS_FROM_VNODE(vp);
    struct xfs_node *xn = VNODE_TO_XNODE(vp);
    int error = 0;

    (xn)->tokens &= ~XFS_ATTR_R;  /* huh? */
    XFSDEB(XDEBVNOPS, ("xfs_attr_valid.  USER=%d\n", curproc->p_ucred->cr_uid));
    /*CHECK_UID;*/
    do {
	if (!XFS_TOKEN_GOT(xn, tok)) {
	    struct xfs_message_getattr msg;

	    msg.header.opcode = XFS_MSG_GETATTR;
	    /*msg.cred.uid = cred->cr_uid;
	    msg.cred.pag = pag;*/
	    fidcpy(msg.handle, xn->handle);
	    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
	    if (error == 0)
		error = ((struct xfs_message_wakeup *) & msg)->error;
	} else {
	    goto done;
	}
    } while (error == 0);

done:
    return error;
}

int
xfs_fetch_rights(struct vnode * vp, struct ucred * cred)
{
    struct xfs *xfsp = XFS_FROM_VNODE(vp);
    struct xfs_node *xn = VNODE_TO_XNODE(vp);
    int error = 0;

    pag_t pag = xfs_get_pag(cred);

    do {
	if (!xfs_has_pag(xn, pag)) {
	    struct xfs_message_getattr msg;

	    msg.header.opcode = XFS_MSG_GETATTR;
	    msg.cred.uid = cred->cr_uid;
	    msg.cred.pag = pag;
	    fidcpy(msg.handle, xn->handle);
	    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
	    if (error == 0)
		error = ((struct xfs_message_wakeup *) & msg)->error;
	} else {
	    goto done;
	}
    } while (error == 0);

done:

    return error;
}

int
xfs_data_valid(struct vnode * vp, struct ucred * cred, u_int tok)
{
  XFSDEB(XDEBVNOPS, ("NI : xfs_data_valid is NOOP.\n")); 
  return EOPNOTSUPP;;
}
/*  
    struct xfs *xfsp = XFS_FROM_VNODE(vp);
    struct xfs_node *xn = VNODE_TO_XNODE(vp);
    int error = 0;

    do {
	if (!XFS_TOKEN_GOT(xn, tok)) {
	    struct xfs_message_getdata msg;

	    msg.header.opcode = XFS_MSG_GETDATA;
	    msg.cred.uid = cred->cr_uid;
	    msg.cred.pag = xfs_get_pag(cred);
	    fidcpy(msg.handle, xn->handle);
	    msg.tokens = tok;
	    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
	    if (error == 0)
		error = ((struct xfs_message_wakeup *) & msg)->error;
	} else {
	    goto done;
	}
    } while (error == 0);

done:
    return error;
}
*/

static int
do_fsync(struct xfs * xfsp,
	 struct xfs_node * xn,
	 struct ucred * cred,
	 u_int flag)
{
    int error;
    struct xfs_message_putdata msg;

    msg.header.opcode = XFS_MSG_PUTDATA;
    if (cred != NOCRED) {
	msg.cred.uid = cred->cr_uid;
	msg.cred.pag = xfs_get_pag(cred);
    } else {
	msg.cred.uid = 0;
	msg.cred.pag = XFS_ANONYMOUSID;
    }
    fidcpy(msg.handle, xn->handle);

    msg.flag = flag;
    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
    if (error == 0)
	error = ((struct xfs_message_wakeup *) & msg)->error;

    if (error == 0)
	xn->flags &= ~XFS_DATA_DIRTY;

    return error;
}

int
xfs_fsync_common(struct vnode *vp, struct ucred *cred)
{
    struct xfs *xfsp = XFS_FROM_VNODE(vp);
    struct xfs_node *xn = VNODE_TO_XNODE(vp);
    int error = 0;

    XFSDEB(XDEBVNOPS, ("xfs_fsync: %p\n", vp));

    /*
     * It seems that fsync is sometimes called after reclaiming a node.
     * In that case we just look happy.
     */

    if (xn == NULL) {
	printf("XFS PANIC WARNING! xfs_fsync called after reclaiming!\n");
	return 0;
    }
    
    if (xn->flags & XFS_DATA_DIRTY)
	error = do_fsync(xfsp, xn, cred, XFS_WRITE);

    return error;
}

int
xfs_close_common(struct vnode *vp, int fflag, struct ucred *cred)
{
    struct xfs *xfsp = XFS_FROM_VNODE(vp);
    struct xfs_node *xn = VNODE_TO_XNODE(vp);
    int error = 0;
    
    XFSDEB(XDEBVNOPS, ("xfs_close cred = %p\n", cred));

    if (fflag & FWRITE && xn->flags & XFS_DATA_DIRTY)
	error = do_fsync(xfsp, xn, cred, XFS_WRITE);

    return error;
}

int
xfs_read_common(struct vnode *vp, struct uio *uio, int ioflag, struct ucred *cred)
{
  char *buf;
  int rv, error;
  struct xfs_message_readsc msg;
  struct xfs_node *xn = VNODE_TO_XNODE(vp);
  u_int sc_error, sc_length;
  
  XFSDEB(XDEBVNOPS, ("xfs_read.  USER=%d.  t_dev=%d.\n",
		     curproc->p_ucred->cr_uid,
		     (int)curproc->p_session->s_ttyp->t_dev));
  /*CHECK_UID;*/
  
  buf = xfs_alloc(SCMaxDataLen);
  
  msg.header.opcode = XFS_MSG_READSC;
  msg.buf = buf;
  msg.sc_error = &sc_error; 
  msg.sc_length = &sc_length; /* length returned by scfsd */
  msg.size = uio->uio_iov->iov_len;
  msg.offset = uio->uio_offset;
  msg.rec_flag = xn->rec_flag;
  msg.t_dev = curproc->p_session->s_ttyp->t_dev; /* controlling terminal */
  fidcpy (msg.parent_fid, xn->parent_handle);
  /*
    msg.fid[0] = xn->handle.a;
    msg.fid[1] = xn->handle.b;
  */
  fidcpy (msg.fid, xn->handle);
  /*fidcpy (msg.parent_fid, xn->parent_handle);*/
  
  error = xfs_message_rpc(0 /* fd set to 0 */, &msg.header, sizeof(msg));
  /*XFSDEB(XDEBVNOPS, ("xfs_readsc: xfs_message_rpc returns %d (ENODEV=%d, ENOMEM=%d\n", error, ENODEV, ENOMEM));*/
  
  if (sc_error == 0) {
    XFSDEB(XDEBVNOPS, ("xfs_read: can read it. :)\n"));
  } else {
    XFSDEB(XDEBVNOPS, ("xfs_read: can't read it. :(\n"));
    return EIO;
  }
  XFSDEB(XDEBVNOPS, ("xfs_read: 4 bytes : %02x %02x %02x %02x\n",
		     buf[0], buf[1], buf[2], buf[3]));
  /*
  uio->uio_rw = UIO_READ;
  uio->uio_segflg = UIO_USERSPACE;
  uio->uio_iov->iov_len = msg.size;
  */
  
  XFSDEB(XDEBVNOPS, ("xfs_read: uiomove.  sc_length=%d, iov_len=%d, msg.size=%d\n",
		     sc_length, (int)uio->uio_iov->iov_len, msg.size));
  
  
  rv = uiomove(buf, sc_length, uio);
  return rv;
}

int
xfs_write_common(struct vnode *vp, struct uio *uiop, int ioflag, struct ucred *cred)
{
  struct xfs_message_writesc msg;
  struct xfs_node *xn = VNODE_TO_XNODE(vp);
  int error = 0, i;
  int tmp_length, tmp_offset;

  XFSDEB(XDEBVNOPS, ("xfs_write.  USER=%d\n", curproc->p_ucred->cr_uid));
  /*CHECK_UID;*/

  /*  XFSDEB(XDEBVNOPS, ("length=%d, offset=%d\n",
		     uiop->uio_iov->iov_len, (int)uiop->uio_offset));
  XFSDEB(XDEBVNOPS, ("uio_rw=%d (UIO_READ=%d, UIO_WRITE=%d)\n",
		     uiop->uio_rw, UIO_READ, UIO_WRITE));  */
  /*XFSDEB(XDEBVNOPS, ("uio_seg=%d(u->k %d, k->u %d)\n", 
    uiop->uio_segflg, UIO_USERSPACE, UIO_SYSSPACE));
    XFSDEB(XDEBVNOPS, ("GO! %s\n", uiop->uio_iov->iov_base));*/
  
  msg.header.opcode = XFS_MSG_WRITESC;
  tmp_length = uiop->uio_iov->iov_len;
  tmp_offset = uiop->uio_offset;
  
  /*bcopy(uiop->uio_iov->iov_base, msg.data, tmp_length);*/
  uiomove(msg.data, uiop->uio_iov->iov_len, uiop);
  
  /*XFSDEB(XDEBVNOPS, ("data in uio: "));
  for (i=0; i<tmp_length; i++)
    XFSDEB(XDEBVNOPS, ("%02x ", uiop->uio_iov->iov_base[i]));
  XFSDEB(XDEBVNOPS, ("\n"));
  XFSDEB(XDEBVNOPS, ("data bcopied: "));
  for (i=0; i<tmp_length; i++)
    XFSDEB(XDEBVNOPS, ("%02x ", msg.data[i]));
  XFSDEB(XDEBVNOPS, ("\n"));
  XFSDEB(XDEBVNOPS, ("data uiomoved: "));
  for (i=0; i<tmp_length; i++)
    XFSDEB(XDEBVNOPS, ("%02x ", tmp[i]));
    XFSDEB(XDEBVNOPS, ("\n"));*/

  msg.size = tmp_length;
  msg.offset = tmp_offset;
  /*
  msg.fid[0] = xn->handle.a;
  msg.fid[1] = xn->handle.b;
  */
  fidcpy (msg.fid, xn->handle);
  msg.rec_flag = xn->rec_flag;
  XFSDEB(XDEBVNOPS, ("xfs_write, parent_handle: %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x\n",
		     xn->parent_handle[0], xn->parent_handle[1],
		     xn->parent_handle[2], xn->parent_handle[3],
		     xn->parent_handle[4], xn->parent_handle[5],
		     xn->parent_handle[6], xn->parent_handle[7]));
  fidcpy (msg.parent_fid, xn->parent_handle);
  XFSDEB(XDEBVNOPS, ("xfs_write, parent_fid: %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x\n",
		     msg.parent_fid[0], msg.parent_fid[1],
		     msg.parent_fid[2], msg.parent_fid[3],
		     msg.parent_fid[4], msg.parent_fid[5],
		     msg.parent_fid[6], msg.parent_fid[7]));
  msg.t_dev = curproc->p_session->s_ttyp->t_dev; /* controlling terminal */

  error = xfs_message_rpc(0 /* fd set to 0 */, &msg.header, sizeof(msg));

  if (error != 0) return error;
  else error = ((struct xfs_message_wakeup *) & msg)->error;
  
  XFSDEB(XDEBVNOPS, ("xfs_write : received %d\n", error));
  /*uiop->uio_iov->iov_len = ((struct xfs_message_wakeup *) & msg)->error;*/
  return error;
}

int
xfs_getattr_common(struct vnode *vp, struct vattr *vap, struct ucred *cred)
{
    int error = 0;

    struct xfs_node *xn = VNODE_TO_XNODE(vp);

    XFSDEB(XDEBVNOPS, ("xfs_getattr\n"));

    error = xfs_attr_valid(vp, cred, XFS_ATTR_R);
    if (error == 0)
	*vap = xn->attr;
    return error;
}

int
xfs_setattr_common(struct vnode *vp, struct vattr *vap, struct ucred *cred)
{
  struct xfs_message_setattr msg;
  struct xfs *xfsp = XFS_FROM_VNODE(vp);
  struct xfs_node *xn = VNODE_TO_XNODE(vp);
  u_int sc_error;
  int error = 0;

  XFSDEB(XDEBVNOPS, ("xfs_setattr is called.  USER=%d\n",
		     curproc->p_ucred->cr_uid));
  /*CHECK_UID;*/
	
  msg.header.opcode = XFS_MSG_SETATTR;
  fidcpy (msg.parent_fid, xn->parent_handle);
  fidcpy (msg.fid, xn->handle);
  vattr2xfs_attr(vap, &(msg.attr));
    
  error = xfs_message_rpc(0 /* fd set to 0 */, &msg.header, sizeof(msg));
  XFSDEB(XDEBVNOPS, ("xfs_setattr: xfs_message_rpc returns %d (ENODEV=%d, ENOMEM=%d\n", error, ENODEV, ENOMEM));
    
  return error;
}

static int
check_rights (u_char rights, int mode)
{
    int error = 0;

    if (mode & VREAD)
	if ((rights & XFS_RIGHT_R) == 0)
	    error = EACCES;
    if (mode & VWRITE)
	if ((rights & XFS_RIGHT_W) == 0)
	    error = EACCES;
    if (mode & VEXEC)
	if ((rights & XFS_RIGHT_X) == 0)
	    error = EACCES;
    return error;
}

int
xfs_access_common(struct vnode *vp, int mode, struct ucred *cred)
{
#ifdef NI
  XFSDEB(XDEBVNOPS, ("xfs_access.  I don't restrict any access.\n"));
  return 0;
#else /* NI */
    int error = 0;
    pag_t pag = xfs_get_pag(cred);

    XFSDEB(XDEBVNOPS, ("xfs_access mode = 0%o\n", mode));

    error = xfs_attr_valid(vp, cred, XFS_ATTR_R);
    if (error == 0) {
	struct xfs_node *xn = VNODE_TO_XNODE(vp);
	int i;

	error = check_rights (xn->anonrights, mode);

	if (error == 0)
	    goto done;

	XFSDEB(XDEBVNOPS, ("xfs_access anonaccess failed\n"));

	xfs_fetch_rights(vp, cred); /* ignore error */

	error = EACCES;		/* default to EACCES if pag isn't in xn->id */

	for (i = 0; i < MAXRIGHTS; i++)
	    if (xn->id[i] == pag) {
		error = check_rights (xn->rights[i], mode);
		break;
	    }
    }

done:
    XFSDEB(XDEBVNOPS, ("xfs_access(0%o) = %d\n", mode, error));

    return error;
#endif /* NI */
}

/* Lookup.  Send a message to scfsd. */

int
xfs_lookup_common(struct vnode *dvp, 
		  xfs_componentname *cnp, 
		  struct vnode **vpp)
{
    struct xfs_message_getnode msg;
    struct xfs *xfsp = XFS_FROM_VNODE(dvp);
    struct xfs_node *d = VNODE_TO_XNODE(dvp);
    int error = 0;
    struct proc *proc  = xfs_cnp_to_proc(cnp);
    struct ucred *cred = xfs_proc_to_cred(proc);

    *vpp = NULL;

    if (dvp->v_type != VDIR)
	return ENOTDIR;
    
 again:

    do {
      /* I think I can comment out this ACCESS stuff. */
      /*
#ifdef __osf__
	VOP_ACCESS(dvp, VEXEC, cred, error);
#else
	error = VOP_ACCESS(dvp, VEXEC, cred, xfs_cnp_to_proc(cnp));
#endif
	if (error != 0)
	    goto done;
      */

	error = xfs_dnlc_lookup(dvp, cnp, vpp);
	if (error == 0) {

	    /*
	     * Doesn't quite work.
	     */

	    msg.header.opcode = XFS_MSG_GETNODE;
	    /* Don't need it. 
	    if (cnp->cn_cred != NOCRED) {
		msg.cred.uid = cnp->cn_cred->cr_uid;
		msg.cred.pag = xfs_get_pag(cnp->cn_cred);
	    } else {
		msg.cred.uid = 0;
		msg.cred.pag = XFS_ANONYMOUSID;
	    }
	    */
	    fidcpy(msg.parent_handle, d->handle);

	    bcopy(cnp->cn_nameptr, msg.name, cnp->cn_namelen);
	    msg.name[cnp->cn_namelen] = '\0';

	    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));

	    if (error == 0)
		error = ((struct xfs_message_wakeup *) & msg)->error;
	    if(error == ENOENT && cnp->cn_nameiop != CREATE) {
		XFSDEB(XDEBVNOPS, ("xfs_lookup: neg cache %p (%s, %ld)\n",
				   dvp,
				   cnp->cn_nameptr, cnp->cn_namelen));
		xfs_dnlc_enter (dvp, cnp, NULL);
	    }
	} else if (error == -1) {
	    if (xfs_do_vget(*vpp, 0, xfs_cnp_to_proc(cnp)))
		    goto again;
	    error = 0;
	    goto done;
	}
    } while (error == 0);

done:
    return error;
}

int
xfs_lookup_name(struct vnode *dvp, 
		const char *name,
		struct proc *proc,
		struct ucred *cred,
		struct vnode **vpp)
{
    xfs_componentname cn;

    xfs_cnp_init (&cn, name, NULL, dvp, proc, cred, CREATE);
    return xfs_lookup_common (dvp, &cn, vpp);
}    

int
xfs_create_common(struct vnode *dvp,
		  const char *name,
		  struct vattr *vap, 
		  struct ucred *cred)
{
  XFSDEB(XDEBVNOPS, ("xfs_create is NOOP\n"));
  return EOPNOTSUPP;
}

int
xfs_remove_common(struct vnode *dvp,
		  struct vnode *vp,
		  const char *name,
		  struct ucred *cred)
{
    struct xfs *xfsp  = XFS_FROM_VNODE(dvp);
    struct xfs_node *xn = VNODE_TO_XNODE(dvp);
    struct xfs_message_remove msg;
    int error;

    XFSDEB(XDEBVNOPS, ("xfs_remove: %s\n", name));

    msg.header.opcode = XFS_MSG_REMOVE;
    fidcpy(msg.parent_handle, xn->handle);
    strncpy(msg.name, name, 256);
    msg.cred.uid = cred->cr_uid;
    msg.cred.pag = xfs_get_pag(cred);
    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
    XFSDEB(XDEBVNOPS, ("xfs_remove: rpc returns %d.\n", error));
    if (error == 0)
	error = ((struct xfs_message_wakeup *) &msg)->error;

    if (error == 0)
	xfs_dnlc_purge (vp);

#if !defined(__FreeBSD__) || __FreeBSD_version < 300000
    if (dvp == vp)
	vrele(vp);
    else
	vput(vp);
    vput(dvp);
#endif
    
    return error;
}

int
xfs_rename_common(struct vnode *fdvp, 
		  struct vnode *fvp,
		  const char *fname,
		  struct vnode *tdvp,
		  struct vnode *tvp,
		  const char *tname,
		  struct ucred *cred)
{
    XFSDEB(XDEBVNOPS, ("xfs_rename: %s %s is NOOP.\n", fname, tname));
    return EOPNOTSUPP;
    /*
    if ((fvp->v_mount != tdvp->v_mount)
	|| (tvp && (fvp->v_mount != tvp->v_mount))) {
	return  EXDEV;
    }

    if (tvp) {
	struct xfs_message_remove msg;

	msg.header.opcode = XFS_MSG_REMOVE;
	fidcpy(msg.parent_handle, VNODE_TO_XNODE(tdvp)->handle);
	strncpy(msg.name, tname, 256);
	msg.cred.uid = cred->cr_uid;
	msg.cred.pag = xfs_get_pag(cred);
	error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
	if (error == 0)
	    error = ((struct xfs_message_wakeup *) &msg)->error;

	if (error)
	    return error;
    }

    {
	struct xfs_message_rename msg;

	msg.t_dev = curproc->p_session->s_ttyp->t_dev; 
	msg.header.opcode = XFS_MSG_RENAME;
	fidcpy(msg.old_parent_handle, VNODE_TO_XNODE(fdvp)->handle);
	strncpy(msg.old_name, fname, 256);
	fidcpy(msg.new_parent_handle, VNODE_TO_XNODE(tdvp)->handle);
	strncpy(msg.new_name, tname, 256);
	msg.cred.uid = cred->cr_uid;
	msg.cred.pag = xfs_get_pag(cred);
	error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
	if (error == 0)
	    error = ((struct xfs_message_wakeup *) &msg)->error;

    }

    XFSDEB(XDEBVNOPS, ("xfs_rename: error = %d\n", error));

    return error;
    */
}

int
xfs_mkdir_common(struct vnode *dvp, 
		 const char *name,
		 struct vattr *vap, 
		 struct ucred *cred)
{
  XFSDEB(XDEBVNOPS, ("xfs_mkdir is NOOP\n"));
  return EOPNOTSUPP;
}

int
xfs_rmdir_common(struct vnode *dvp,
		 struct vnode *vp,
		 const char *name,
		 struct ucred *cred)
{
    struct xfs *xfsp  = XFS_FROM_VNODE(dvp);
    struct xfs_node *xn = VNODE_TO_XNODE(dvp);
    struct xfs_message_rmdir msg;
    int error;

    XFSDEB(XDEBVNOPS, ("xfs_rmdir: %s\n", name));

    msg.header.opcode = XFS_MSG_RMDIR;
    fidcpy(msg.parent_handle, xn->handle);
    strncpy(msg.name, name, 256);
    msg.cred.uid = cred->cr_uid;
    msg.cred.pag = xfs_get_pag(cred);
    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
    if (error == 0)
	error = ((struct xfs_message_wakeup *) &msg)->error;

    if (error == 0)
	xfs_dnlc_purge (vp);

#if !defined(__FreeBSD__) || __FreeBSD_version < 300000
    if (dvp == vp)
	vrele(vp);
    else
	vput(vp);
    vput(dvp);
#endif

    return error;
}

int
xfs_readdir_common(struct vnode *vp, 
		   struct uio *uiop, 
		   struct ucred *cred,
		   int *eofflag)
{
  XFSDEB(XDEBVNOPS, ("xfs_readdir is NOOP.\n"));
  return EOPNOTSUPP;
}
/*
    int error = 0;

    XFSDEB(XDEBVNOPS, ("xfs_readdir\n"));

    if(eofflag)
	*eofflag = 0;
    error = xfs_data_valid(vp, cred, XFS_DATA_R);
    if (error == 0) {
	struct vnode *t = DATA_FROM_VNODE(vp);

	xfs_vfs_readlock(t, xfs_uio_to_proc(uiop));
#ifdef __osf__
	VOP_READ(t, uiop, 0, cred, error);
#else
	error = VOP_READ(t, uiop, 0, cred);
#endif
	if(eofflag)
	    *eofflag = VNODE_TO_XNODE(vp)->attr.va_size <= uiop->uio_offset;
	xfs_vfs_unlock(t, xfs_uio_to_proc(uiop));
    }
    return error;
}
*/
int
xfs_link_common(struct vnode *dvp, 
		struct vnode *vp, 
		const char *name,
		struct ucred *cred)
{
  XFSDEB(XDEBVNOPS, ("xfs_link is NOOP\n"));
  return EOPNOTSUPP;
}
/*
    struct xfs *xfsp = XFS_FROM_VNODE(dvp);
    struct xfs_node *xn = VNODE_TO_XNODE(dvp);
    struct xfs_node *xn2 = VNODE_TO_XNODE(vp);
    struct xfs_message_link msg;
    int error = 0;

    XFSDEB(XDEBVNOPS, ("xfs_link: %s\n", name));
    
    msg.header.opcode = XFS_MSG_LINK;
    fidcpy(msg.parent_handle, xn->handle);
    fidcpy(msg.from_handle, xn2->handle);
    strncpy(msg.name, name, 256);
    msg.cred.uid = cred->cr_uid;
    msg.cred.pag = xfs_get_pag(cred);

    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
    if (error == 0)
	error = ((struct xfs_message_wakeup *) & msg)->error;
    
    return error;
}
*/

int
xfs_symlink_common(struct vnode *dvp,
		   struct vnode **vpp,
		   const char *name,
		   struct proc *proc,
		   struct ucred *cred,
		   struct vattr *vap,
		   char *target)
{
    struct xfs *xfsp = XFS_FROM_VNODE(dvp);
    struct xfs_node *xn = VNODE_TO_XNODE(dvp);
    struct xfs_message_symlink msg;
    int error = 0;

    XFSDEB(XDEBVNOPS, ("xfs_symlink: %s\n", name));

    msg.header.opcode = XFS_MSG_SYMLINK;
    fidcpy(msg.parent_handle, xn->handle);
    strncpy(msg.name, name, sizeof(msg.name));
    msg.name[sizeof(msg.name) - 1] = '\0';
    vattr2xfs_attr(vap, &msg.attr);
    msg.cred.uid = cred->cr_uid;
    msg.cred.pag = xfs_get_pag(cred);
    strncpy (msg.contents, target, sizeof(msg.contents));
    msg.contents[sizeof(msg.contents) - 1] = '\0';

    error = xfs_message_rpc(xfsp->fd, &msg.header, sizeof(msg));
    if (error == 0)
	error = ((struct xfs_message_wakeup *) & msg)->error;

    if (error == 0)
	error = xfs_lookup_name(dvp, name, proc, cred, vpp);

#if !defined(__FreeBSD__) || __FreeBSD_version < 300000
    vput(dvp);
#endif

    return error;
}

int
xfs_readlink_common(struct vnode *vp, struct uio *uiop, struct ucred *cred)
{
    int error = 0;

    XFSDEB(XDEBVNOPS, ("xfs_readlink\n"));

    error = xfs_data_valid(vp, cred, XFS_DATA_R);
    if (error == 0) {
	struct vnode *t = DATA_FROM_VNODE(vp);

	xfs_vfs_readlock(t, xfs_uio_to_proc(uiop));
#ifdef __osf__
	VOP_READ(t, uiop, 0, cred, error);
#else
	error = VOP_READ(t, uiop, 0, cred);
#endif
	xfs_vfs_unlock(t, xfs_uio_to_proc(uiop));
    }
    return error;
}

int
xfs_inactive_common(struct vnode *vp, struct proc *p)
{
  XFSDEB(XDEBVNOPS, ("xfs_inactive just returns success\n"));
  return 0;
}

int
xfs_reclaim_common(struct vnode *vp)
{
    struct xfs_message_inactivenode msg;
    struct xfs *xfsp = XFS_FROM_VNODE(vp);
    struct xfs_node *xn = VNODE_TO_XNODE(vp);

    XFSDEB(XDEBVNOPS, ("xfs_reclaim: %p\n", vp));
#ifdef NIXX
    msg.header.opcode = XFS_MSG_INACTIVENODE;
    fidcpy(msg.handle, xn->handle);
    msg.flag   = XFS_NOREFS | XFS_DELETE;
    xfs_message_send(xfsp->fd, &msg.header, sizeof(msg));
#endif

    xfs_dnlc_purge(vp);
    free_xfs_node(xn);

    return 0;
}
