/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 *
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */


#include "xfs_locl.h"

RCSID("$Id: xfs_syscalls-bsd.c,v 1.2 1999/01/05 18:21:43 itoi Exp itoi $");

/*
 * XFS system calls.
 */

#include <xfs_syscalls.h>
#include <xfs_message.h>
#include <xfs_fs.h>
#include <xfs_dev.h>
#include <xfs_node.h>
#include <xfs_deb.h>

#include <kafs.h>

/*
 * the syscall entry point
 */

static int
xfs_syscall(struct proc *proc, void *varg, int *return_value)
{
    struct sys_pioctl_args *arg = (struct sys_pioctl_args *) varg;
    int error = EINVAL;

    switch (SCARG(arg, operation)) {
    case AFSCALL_PIOCTL:
	error = xfs_pioctl_call(proc, varg, return_value);
	break;
    case AFSCALL_SETPAG:
	error = xfs_setpag_call(&proc->p_cred->pc_ucred);
	break;
    default:
	uprintf("Unimplemeted call: %d\n", SCARG(arg, operation));
	error = EINVAL;
	break;
    }

    return error;
}

static int syscall_offset;

static struct sysent old_syscallent;

static struct sysent xfs_syscallent = {
    5,				       /* number of args */
    sizeof(struct sys_pioctl_args),    /* size of args */
    xfs_syscall			       /* function pointer */
};

/* XXX really defined in kern/kern_lkm.c */
extern int
sys_lkmnosys(struct proc *p, void *v, register_t *retval);

/*
 *
 */

static int
try_install_syscall (int offset,
		     struct sysent new_sysent,
		     struct sysent *old_sysent)
{
    if (sysent[offset].sy_call == sys_lkmnosys) {
	*old_sysent = sysent[offset];
	sysent[offset] = new_sysent;
	return 0;
    }
    return EBUSY;
}

/*
 *
 */

static int
install_first_free_syscall (int *offset,
			    struct sysent sysent,
			    struct sysent *old_sysent)
{
    int i;

    for (i = 1; i < SYS_MAXSYSCALL; ++i)
	if (try_install_syscall (i, sysent, old_sysent)) {
	    *offset = i;
	    return 0;
	}
    return ENFILE;
}

/*
 * Try SCFS_SYSCALL first, if that fails, any free slot
 */

/* XXX */

#define SCFS_SYSCALL 211

int
xfs_install_syscalls(void)
{
    int ret = ENOENT;

    XFSDEB(XDEBSYS, ("xfs_install_syscalls() is called.  SCFS_SYSCALL=%d.\n",
		     SCFS_SYSCALL));
    
#ifdef SCFS_SYSCALL
	   XFSDEB(XDEBSYS, ("try install_syscall().\n"));
    if (ret != 0) {
	ret = try_install_syscall(SCFS_SYSCALL,
				  xfs_syscallent,
				  &old_syscallent);
	if (ret == 0)
	    syscall_offset = SCFS_SYSCALL;
    }
#endif
    if (ret != 0)
	ret = install_first_free_syscall (&syscall_offset,
					  xfs_syscallent,
					  &old_syscallent);
    if (ret == 0)
	XFSDEB(XDEBSYS, ("xfs_syscall installed at %d\n", syscall_offset));
    else
	XFSDEB(XDEBSYS, ("failed installing xfs_syscall\n"));
    return ret;
}

int
xfs_uninstall_syscalls(void)
{
    if (syscall_offset)
	sysent[syscall_offset] = old_syscallent;
    return 0;
}

int
xfs_stat_syscalls(void)
{
    return 0;
}
