
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <time.h>
#include <unistd.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <err.h>

#ifdef RCSID
RCSID("$Id: read-vs-mmap2.c,v 1.2 1998/12/05 22:45:51 assar Exp $");
#endif

static void
generate_random_file (const char *filename, size_t sz)
{
    int fd;
    char *buf;
    int i;

    buf = malloc (sz);
    if (buf == NULL)
	err (1, "malloc %u", sz);

    fd = open (filename, O_WRONLY | O_CREAT, 0666);
    if (fd < 0)
	err (1, "open %s", filename);

    for (i = 0; i < sz; ++i)
	buf[i] = rand();

    if (write (fd, buf, sz) != sz)
	err (1, "write");
    if (close (fd))
	err (1, "close");
    free (buf);
}

static char *
read_file (int fd, size_t sz)
{
    char *buf;

    buf = malloc (sz);
    if (buf == NULL)
	err (1, "malloc %u", sz);
    if (read (fd, buf, sz) != sz)
	err (1, "read");
    return buf;
}

#ifndef MAP_FAILED
#define MAP_FAILED ((void *)-1)
#endif

static void *
mmap_file (int fd, size_t sz)
{
    void *ret;

    ret = mmap (0, sz, PROT_READ, MAP_SHARED, fd, 0);
    if (ret == MAP_FAILED)
	err (1, "mmap");
    return ret;
}

int
main (int argc, char **argv)
{
    const char *file = "foo";
    const size_t sz  = 16384;

    char *malloc_buf;
    void *mmap_buf;
    int fd;

    srand (time(NULL));

    generate_random_file (file, sz);

    fd = open (file, O_RDONLY, 0);
    if (fd < 0)
	err (1, "open %s", file);

    malloc_buf = read_file (fd, sz);
    mmap_buf   = mmap_file (fd, sz);
    close (fd);
    unlink (file);
    if (memcmp (malloc_buf, mmap_buf, sz) != 0)
	return 1;
    return 0;
}
