
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>

#include <err.h>
#include <roken.h>

#ifdef RCSID
RCSID("$Id: large-dir.c,v 1.4 1998/12/02 04:59:26 assar Exp $");
#endif

static int
creat_files (const char *dirname, int count)
{
    struct stat sb;
    int i;
    DIR *d;
    struct dirent *dp;
    
    if (mkdir (dirname, 0777) < 0)
	err (1, "mkdir %s", dirname);

    if (chdir (dirname) < 0)
	err (1, "chdir %s", dirname);
    if (stat (".", &sb) < 0)
	err (1, "stat .");
    if (sb.st_size != 2048)
	errx (1, "size != 2048");
    for (i = 0; i < count; ++i) {
	char num[17];
	int fd;

	snprintf (num, sizeof(num), "%d", i);
	
	fd = open (num, O_CREAT | O_EXCL, 0777);
	if (fd < 0)
	    err (1, "open %s", num);
	if (close (fd) < 0)
	    err (1, "close %s", num);
    }
    if (stat (".", &sb) < 0)
	err (1, "stat .");

    d = opendir (".");
    if (d == NULL)
	err (1, "opendir .");
    for (i = -2; i < count; ++i) {
	char num[17];

	dp = readdir (d);
	if (dp == NULL)
	    errx (1, "out of entries at %d?", i);
	if (i == -2)
	    strcpy (num, ".");
	else if (i == -1)
	    strcpy (num, "..");
	else
	    snprintf (num, sizeof(num), "%d", i);
	if (strcmp (num, dp->d_name) != 0)
	    errx (1, "'%s' != '%s'", num, dp->d_name);
    }
    if (readdir (d) != NULL)
	errx (1, "more entries?");
    closedir (d);
    for (i = 0; i < count; ++i) {
	char num[17];

	snprintf (num, sizeof(num), "%d", i);
	
	if (unlink (num) < 0)
	    err (1, "unlink %s", num);
    }
    d = opendir (".");
    if (d == NULL)
	err (1, "opendir .");
    dp = readdir (d);
    if (dp == NULL || strcmp (dp->d_name, ".") != 0)
	errx (1, "where's .?");
    dp = readdir (d);
    if (dp == NULL || strcmp (dp->d_name, "..") != 0)
	errx (1, "where's ..?");
    if (readdir (d) != NULL)
	errx (1, "even more entries?");
    closedir (d);
    if (stat (".", &sb) < 0)
	err (1, "stat .");
    if (sb.st_size != 2048)
	errx (1, "size != 2048");
    return 0;
}

static void
usage (int ret)
{
    fprintf (stderr, "%s directory number-of-files\n", __progname);
    exit (ret);
}

int
main(int argc, char **argv)
{
    char *ptr;
    int count;

    set_progname (argv[0]);

    if (argc != 3)
	usage (1);

    count = strtol (argv[2], &ptr, 0);
    if (count == 0 && ptr == argv[2])
	errx (1, "'%s' not a number", argv[2]);

    return creat_files (argv[1], count);
}
