
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

/*#include <sys/ioctl.h>*/
/*#include "scfs_ioctl.h"*/
#include <kafs.h>

/* Macros */
#ifdef NIPERF
#include <sys/time.h>
#define PrintTime(x) {struct timeval tv;gettimeofday(&tv, NULL);fprintf(stderr, "%d.%06d: %s\n", tv.tv_sec, tv.tv_usec, x);}
#else
#define PrintTime(x)
#endif /* NIPERF */

main(int argc, char *argv[])
{
  char buf[256], buf2[256];
  char buf_io[8];
  int fd;
  struct stat s;
  int rv, i, j, r;
  int size;
  struct timeval tv, uv, vv;
    
  if (argc > 2) {
    strcpy (buf, argv[1]);
    size = atoi(argv[2]);
  } else {
    fprintf(stderr, "Usage:\twritex filename numbytes\n");
    fprintf(stderr, "Example:\twritex /arla/7777/7701 8\n");
    exit (-1);
  }
  /*if ((fd = open(buf, O_RDWR, 777)) == -1) {*/
  if ((fd = open(buf, O_WRONLY | O_TRUNC, 777)) == -1) {
    printf("opening error %d\n", errno);
    warn("opening error %s", buf);
    exit (-1);
  }
  printf("opened %s\n", buf);
  printf("input %d bytes\n", size);
  for (i=0; i<size; i++) {
    scanf("%x", &r);
    buf2[i] = r & 0xff;
  }
  
  /*buf2[0] = (argv[2])[0];*/
  PrintTime("Writex: Call write()");
#ifdef NIPERF
  gettimeofday(&tv, NULL);
#endif /* NIPERF */
  rv = write(fd, buf2, size);
#ifdef NIPERF
  gettimeofday(&uv, NULL);
  timersub(&uv, &tv, &vv);
  printf("%d.%06d:\n", tv.tv_sec, tv.tv_usec);
  printf("%d.%06d:\n", vv.tv_sec, vv.tv_usec);
#endif /* NIPERF */
  printf("rv=%d, errno=%d\n", rv, errno);
  if (errno) perror("write error");
}
