
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* verify key */
#include <errno.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/syscall.h>
#include <kafs.h>
#include <setjmp.h>
#include "scfs_pioctl.h"

#define AFS_SYSCALL 211
#define AFS_PIOCTL 20

#define syscallarg(x)   union { x datum; register_t pad; }

main(int argc, char *argv[])
{
  struct ViceIoctl parms;
  struct scfs_verifykey_arg verifykey_arg;

  if (argc != 1 && argc != 9){
    fprintf(stderr, "Usage: %s (key[0] key[1] ... key[7])\n", argv[0]);
    exit (1);
  }
    
  /* verify key */
  printf("syscall verifykey.\n");
  memset(&parms, 0, sizeof(parms));
  verifykey_arg.keynum = 0;
  verifykey_arg.keysize = 8;
  if (argc == 1){
    verifykey_arg.key[0] = (char)0xad;
    verifykey_arg.key[1] = (char)0x9f;
    verifykey_arg.key[2] = (char)0x61;
    verifykey_arg.key[3] = (char)0xfe;
    verifykey_arg.key[4] = (char)0xfa;
    verifykey_arg.key[5] = (char)0x20;
    verifykey_arg.key[6] = (char)0xce;
    verifykey_arg.key[7] = (char)0x63;
  } else {
    sscanf(argv[1], "%0x", &(verifykey_arg.key[0]));
    sscanf(argv[2], "%0x", &(verifykey_arg.key[1]));
    sscanf(argv[3], "%0x", &(verifykey_arg.key[2]));
    sscanf(argv[4], "%0x", &(verifykey_arg.key[3]));
    sscanf(argv[5], "%0x", &(verifykey_arg.key[4]));
    sscanf(argv[6], "%0x", &(verifykey_arg.key[5]));
    sscanf(argv[7], "%0x", &(verifykey_arg.key[6]));
    sscanf(argv[8], "%0x", &(verifykey_arg.key[7]));
  }
  parms.in = (void *)(&verifykey_arg);
  parms.out = NULL;
  parms.in_size = sizeof(verifykey_arg);
  parms.out_size = 0;
  syscall(AFS_SYSCALL, AFSCALL_PIOCTL,
	  ".", SCFS_VERIFYKEY, &parms, 0);

  if (errno) {
    if (errno == EINVAL)
      {
	printf("EINVAL :<\n");
	goto done;
      }
    perror("syscall error: ");
  }
  else printf("syscall succeeded :)\n");
  
  
 done:
}

