
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "scfs.h"
#include "scrw.h"

/* global variables */
struct scconfig scconfig;

/* extenal variables */
extern int fd;

/* usage : scdir [filename] */

int scdir_init(char *atr, char *filename)
{
  FILE *cnfg_fd;
  char buf[256], *tmp=NULL;
  int found_field = 0, found = 0, line = 0, i, same=1, x1;

  scconfig.num_nodes = 0;

  arla_warnx (ADEBMSG, "scdir_init() is called.\n");
  /*printf("looking for ATR %x.%x.%x.%x\n",
    atr[0], atr[1], atr[2], atr[3]);*/
  

  if (filename) {
    strcpy (buf, filename);
  } else {
    strcpy (buf, SCDFILE);
  }
  
  if ((cnfg_fd = fopen(buf, "r")) == NULL) {
    arla_warnx (ADEBERROR, "cannot open %s\n", buf);
    exit (-1);
  }

  /* find correct smartcard type */
  /* find "ATR" field */
  found_field = 0; found = 0;
  while (1) {
    found_field = 0;
    
    if (fgets(buf, 255, cnfg_fd) == NULL) {
      break;
    }
    line++;
    
    /*printf("%d: %s", line, buf);*/
    tmp = strtok(buf, Separator);
    /* Look for "ATR" field */
    while (tmp) {
      if (strcasecmp (tmp, STR_ATR) == 0) {
	found_field = 1;
	break;
      }
      tmp = strtok(NULL, Separator);
    }
    if (found_field == 1) {
      /* Check ATR */
      same = 1;
      
      for (i=0; i<4; i++) {
	tmp=strtok(NULL, Separator);
	/*printf("%s\n", tmp);*/
	sscanf (tmp, "%x", &x1);
	if (atr[i] != x1) {
	  /*printf("atr[%d]=%x, x1=%x\n", i, atr[i], x1);*/
	  same = 0;
	}
      }
      
      if (same == 1) {
	/*printf("set found=1\n");*/
	found = 1;
	break;
      }
    }
  }
  
  if (found == 1) {
    /*printf("found correct ATR :)\n");*/
    return config_smartcard(cnfg_fd, &line);
  } 
  
  if (found == 0) {
    /*fprintf(stderr, "No correct ATR found\n");*/
    return -1;
  }

  arla_warnx (ADEBERROR, "scdir_init() : Should not be here ...\n");
  return -1;  
}

int config_smartcard(FILE *cnfg_fd, int *line)
{
  char buf[256], *tmp;
  int cla;
  
  scconfig_setdefault(&scconfig);

  for (;;) {
    if (fgets(buf, 255, cnfg_fd) == NULL) {
      /*printf("line %d : requires \"}\" here.\n", *line);*/
      return -1;
    }
    (*line)++;
    /*printf("buf=%s", buf);*/
    tmp = strtok(buf, Separator) ; /* Get the first token */
    if (tmp[0] == '#') continue;
    /*printf("tmp=%s  strncasecmp=%d\n", tmp, strncasecmp (tmp, STR_CARDNAME, strlen(STR_CARDNAME)));*/

    /*if (strncasecmp (tmp, STR_CARDNAME, strlen(STR_CARDNAME)) == 0) {*/
    if (strcasecmp (tmp, STR_CARDNAME) == 0) {
      strncpy (scconfig.name, strtok(NULL, Separator), 255);
    }
    else if (strcasecmp (tmp, STR_MULTIFLEXPIN) == 0) {
      scconfig.multiflexpin = isyes(strtok(NULL, Separator));
    }
    else if (strcasecmp (tmp, STR_MULTIFLEXGETRES) == 0) {
      scconfig.multiflexgetres = isyes(strtok(NULL, Separator));
    }
    else if (strcasecmp (tmp, STR_DEFAULT) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_default = cla;
    }
    else if (strcasecmp (tmp, STR_VERIFYKEY) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_verifykey = cla;
    }
    else if (strcasecmp (tmp, STR_VERIFYPIN) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_verifypin = cla;
    }
    else if (strcasecmp (tmp, STR_SELECT) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_select = cla;
    }
    else if (strcasecmp (tmp, STR_READBINARY) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_readbinary = cla;
    }
    else if (strcasecmp (tmp, STR_UPDATEBINARY) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_updatebinary = cla;
    }
    else if (strcasecmp (tmp, STR_READRECORD) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_readrecord = cla;
    }
    else if (strcasecmp (tmp, STR_UPDATERECORD) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_updaterecord = cla;
    }
    /*else if (strcasecmp (tmp, STR_DIR) == 0) {
      tmp = strtok(NULL, "\n");
      printf("GO DIR %s\n", tmp);
      parse_dir(tmp, line);
      }*/
    else if (strcasecmp (tmp, STR_INAUTH) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_inauth = cla;
    }
    else if (strcasecmp (tmp, STR_EXAUTH) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_exauth = cla;
    }
    else if (strcasecmp (tmp, STR_GETRESPONSE) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_getresponse = cla;
    }
    else if (strcasecmp (tmp, STR_GETCHALLENGE) == 0) {
      tmp = strtok(NULL, Separator);
      sscanf (tmp, "%x", &cla);
      scconfig.cla_getchallenge = cla;
    }
    
    else if (strcasecmp (tmp, "}") == 0) {
      /*printf("owari :)\n");*/
      break;
    }
  }

  if (scconfig.cla_verifykey == CLA_UNDEFINED)
    scconfig.cla_verifykey = scconfig.cla_default;
  if (scconfig.cla_verifypin == CLA_UNDEFINED)
    scconfig.cla_verifypin = scconfig.cla_default;
  if (scconfig.cla_select == CLA_UNDEFINED)
    scconfig.cla_select = scconfig.cla_default;
  if (scconfig.cla_readbinary == CLA_UNDEFINED)
    scconfig.cla_readbinary = scconfig.cla_default;
  if (scconfig.cla_updatebinary == CLA_UNDEFINED)
    scconfig.cla_updatebinary = scconfig.cla_default;
  if (scconfig.cla_readrecord == CLA_UNDEFINED)
    scconfig.cla_readrecord = scconfig.cla_default;
  if (scconfig.cla_updaterecord == CLA_UNDEFINED)
    scconfig.cla_updaterecord = scconfig.cla_default;
  if (scconfig.cla_inauth == CLA_UNDEFINED)
    scconfig.cla_inauth = scconfig.cla_default;
  if (scconfig.cla_exauth == CLA_UNDEFINED)
    scconfig.cla_exauth = scconfig.cla_default;
  if (scconfig.cla_getresponse == CLA_UNDEFINED)
    scconfig.cla_getresponse = scconfig.cla_default;
  if (scconfig.cla_getchallenge == CLA_UNDEFINED)
    scconfig.cla_getchallenge = scconfig.cla_default;
  
  /*print_scconfig(&scconfig);*/
  return 0;
}

void print_scconfig(struct scconfig *scc)
{
  printf("Print out scconfig structure:\n");
  printf("\tname=%s\n", scc->name);
  printf("\tmultiflexpin=%d\n", scc->multiflexpin);
  printf("\tmultiflexgetres=%d\n", scc->multiflexgetres);
  printf("\tcla_default=%x\n", scc->cla_default);
  printf("\tcla_verifykey=%x\n", scc->cla_verifykey);
  printf("\tcla_verifypin=%x\n", scc->cla_verifypin);
  printf("\tcla_select=%x\n", scc->cla_select);
  printf("\tcla_readbinary=%x\n", scc->cla_readbinary);
  printf("\tcla_updatebinary=%x\n", scc->cla_updatebinary);
  printf("\tcla_readrecord=%x\n", scc->cla_readrecord);
  printf("\tcla_updaterecord=%x\n", scc->cla_updaterecord);
  printf("\tcla_inauth=%x\n", scc->cla_inauth);
  printf("\tcla_exauth=%x\n", scc->cla_exauth);
  printf("\tcla_getresponse=%x\n", scc->cla_getresponse);
  printf("\tcla_getchallenge=%x\n", scc->cla_getchallenge);
}  

void scconfig_setdefault(struct scconfig *scc)
{
  scc->cla_default = 0xc0;
  scc->cla_select = CLA_UNDEFINED;
  scc->cla_verifykey = CLA_UNDEFINED;
  scc->cla_verifypin = CLA_UNDEFINED;
  scc->cla_readbinary = CLA_UNDEFINED;
  scc->cla_updatebinary = CLA_UNDEFINED;
  scc->cla_readrecord = CLA_UNDEFINED;
  scc->cla_updaterecord = CLA_UNDEFINED;
  scc->cla_inauth = CLA_UNDEFINED;
  scc->cla_exauth = CLA_UNDEFINED;
  scc->cla_getresponse = CLA_UNDEFINED;
  scc->cla_getchallenge = CLA_UNDEFINED;
  scc->multiflexpin = 0;
  scc->multiflexgetres = 0;
}


void read_couple(char *child, char *parent)
{
  struct scdnode *parent_node;
  struct scdnode *new_node = (struct scdnode *)malloc(sizeof(*new_node));
  unsigned char child_fid[FID_LEN], parent_fid[FID_LEN];
  int recnum_child, recnum_parent;
  
  /*printf("read_couple (%s,%s)\n", child, parent);*/

  name2fid(child, child_fid, &recnum_child);
  name2fid(parent, parent_fid, &recnum_parent);

  /*
    arla_warnx (ADEBMSG, "read_couple : child %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x\n",
    child_fid[0], child_fid[1], child_fid[2], child_fid[3],
    child_fid[4], child_fid[5], child_fid[6], child_fid[7]);
    
    arla_warnx (ADEBMSG, "read_couple : parent %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x\n",
    parent_fid[0], parent_fid[1], parent_fid[2], parent_fid[3],
    parent_fid[4], parent_fid[5], parent_fid[6], parent_fid[7]);
  */
  if (get_scdnode (child_fid) != NULL) {
    arla_warnx (ADEBERROR, "child already exists ... ignore\n");
    return;
  }

  if ((parent_node = get_scdnode (parent_fid)) == (struct scdnode *)NULL) {
    arla_warnx (ADEBERROR, "parent does not exist ... ignore\n");
    return;
  }

  new_scdnode(child_fid, parent_node, 0);
  return;
}

struct scdnode *new_scdnode(unsigned char *fid, struct scdnode *parent, u_int8_t type)
{
  struct scdnode *new_node;
  new_node = (struct scdnode *)malloc(sizeof(*new_node));
  fidcpy (new_node->fileent.fid, fid);
  new_node->fileent.d_type = type;
  new_node->fileent.p_size = 256;
  new_node->fileent.l_size = 256;
  new_node->parent = parent;
  new_node->num_children = 0;
  scconfig.scdnodes[scconfig.num_nodes++] = new_node;

  /*
    if (parent != NULL) {
    parent->child[parent->num_children] = new_node;
    (parent->num_children)++;
    parent->fileent.d_type = SCFS_TYPE_DIR;
    }
  */
  arla_warnx (ADEBMSG, "new_scdnode : %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x\n",
	      new_node->fileent.fid[0], new_node->fileent.fid[1],
	      new_node->fileent.fid[2], new_node->fileent.fid[3],
	      new_node->fileent.fid[4], new_node->fileent.fid[5],
	      new_node->fileent.fid[6], new_node->fileent.fid[7]);
  return new_node;
}

struct scdnode *get_scdnode(unsigned char *fid)
{
  int i;

  arla_warnx (ADEBMSG, "get_csdnode called for %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x, num_nodes = %d\n",
	      fid[0], fid[1], fid[2], fid[3],
	      fid[4], fid[5], fid[6], fid[7], scconfig.num_nodes);
  
  for (i=0; i<scconfig.num_nodes; i++) {
    if (fidcmp (fid, scconfig.scdnodes[i]->fileent.fid)) {
      return scconfig.scdnodes[i];
    }
  }
  return NULL;
}


int name2fid (char *name, unsigned char *fid, int *recnum)
{
  unsigned int tmp[FID_LEN], tmp2;
  /*if (strlen(name) != 2*FID_LEN) goto bad;*/

  if (sscanf(name, "%02x%02x%02x%02x%02x%02x%02x%02xr%02x",
	     &(tmp[0]), &(tmp[1]), &(tmp[2]), &(tmp[3]),
	     &(tmp[4]), &(tmp[5]), &(tmp[6]), &(tmp[7]), &tmp2)
      == FID_LEN+1) {
    /*fprintf(stderr, "name2fid : record file %02x.%02x\n", tmp[0], tmp[1]);*/
    *recnum = tmp2;
    goto success;
  }
  else if (sscanf(name, "%02x%02x%02x%02x%02x%02x%02x%02x",
	     &(tmp[0]), &(tmp[1]), &(tmp[2]), &(tmp[3]),
	     &(tmp[4]), &(tmp[5]), &(tmp[6]), &(tmp[7]))
      == FID_LEN) {
    /*fprintf(stderr, "name2fid : non-record file %02x.%02x\n", tmp[0], tmp[1]);*/
    *recnum = 0;
    goto success;
  } else {
    goto bad;
  }

 success:
  fid[0] = (unsigned char)(tmp[0] & 0xff);
  fid[1] = (unsigned char)(tmp[1] & 0xff);
  fid[2] = (unsigned char)(tmp[2] & 0xff);
  fid[3] = (unsigned char)(tmp[3] & 0xff);
  fid[4] = (unsigned char)(tmp[4] & 0xff);
  fid[5] = (unsigned char)(tmp[5] & 0xff);
  fid[6] = (unsigned char)(tmp[6] & 0xff);
  fid[7] = (unsigned char)(tmp[7] & 0xff);
  return 0;

 bad:
  arla_warnx (ADEBERROR, "name2fid failed.\n");
  return -1;
}

void print_path (struct scdnode *node)
{
  struct scdnode *tmp;
  int path[MaxDepth][2], i;

  for (tmp = node, i=0; tmp != NULL; tmp = tmp->parent, i++) {
    path[i][0] = tmp->fileent.fid[0];
    path[i][1] = tmp->fileent.fid[1];
  }
  /*printf("path to %02x.%02x\n", node->fid[0], node->fid[1]);
    for (j=i-1; j>=0; j--) printf("%02x.%02x ", path[j][0], path[j][1]);
    printf("\n\n");*/
}

int scfs_getdirent(unsigned char *fid, unsigned char *parent_fid, char *dirent)
{
  struct scdnode *node, *child;
  struct dirent dire[MaxNumChildren];
  int i, j;

  if ((node = get_scdnode (fid)) == NULL) {
    /*fprintf(stderr, "fid %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x does not exist.\n",
	    fid[0], fid[1], fid[2], fid[3],
	    fid[4], fid[5], fid[6], fid[7]);*/
    return -1;
  }

  if (node->fileent.d_type == SCFS_TYPE_ELFILE) {
    /*fprintf(stderr, "fid %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x is an elementary file.\n",
	    fid[0], fid[1], fid[2], fid[3],
	    fid[4], fid[5], fid[6], fid[7]);*/
    return -1;
  }

  dire[0].d_fileno = fid2inode(fid);
  dire[0].d_reclen = 12;
  dire[0].d_type = DT_DIR;
  dire[0].d_namlen = 1;
  strncpy(dire[0].d_name, ".\0\0\0", 4);
  
  dire[1].d_fileno = fid2inode(parent_fid);
  dire[1].d_reclen = 12;
  dire[1].d_type = DT_DIR;
  dire[1].d_namlen = 2;
  strncpy(dire[1].d_name, "..\0\0", 4);
  
  if (node->fileent.d_type == SCFS_TYPE_DIR) {
    for (i=0; i<node->num_children; i++) {
      child = node->child[i];
      dire[i+2].d_fileno = fid2inode(child->fileent.fid);
      dire[i+2].d_reclen = 12;
      /* type ? */
      if (child->fileent.d_type == SCFS_TYPE_ELFILE) 
	dire[i+2].d_type = DT_REG;
      else
	dire[i+2].d_type = DT_DIR;
      dire[i+2].d_namlen = 4;
      /* name ? */
      dire[i+2].d_name[0] = (unsigned char)(((child->fileent.fid[0] >> 4) & 0x0f)+ '0');
      dire[i+2].d_name[1] = (unsigned char)((child->fileent.fid[0] & 0x0f) + '0');

      dire[i+2].d_name[2] = (unsigned char)(((child->fileent.fid[1] >> 4) & 0x0f)+ '0');
      dire[i+2].d_name[3] = (unsigned char)((child->fileent.fid[1] & 0x0f) + '0');      
      /*fprintf(stderr, "name=%02x.%02x.%02x.%02x\n",
	      dire[i+2].d_name[0], dire[i+2].d_name[1],
	      dire[i+2].d_name[2], dire[i+2].d_name[3]);*/
    }
  }
  else if (node->fileent.d_type == SCFS_TYPE_RECFILE) {
    for (i=0; i<node->num_children; i++) {
      dire[i+2].d_fileno = 1;
      dire[i+2].d_reclen = 12;
      /* type ? */
      dire[i+2].d_type = DT_REG;
      dire[i+2].d_namlen = 4;
      /* name ? */
      dire[i+2].d_name[0] = (unsigned char)'0';
      dire[i+2].d_name[1] = (unsigned char)'0';
      dire[i+2].d_name[2] = (unsigned char)'0';
      dire[i+2].d_name[3] = (unsigned char)(i+1+'0');
    }
  }
  /* i = numchildren */
  dire[i-1+2].d_reclen = 1012 - 12*i;

  for (j=0; j<i+2; j++) {
    bcopy (&(dire[j]), dirent+12*j, 12);
  }
  
  /*fprintf(stderr, "scfs_getdirent: ");
  for (i=0; i<64; i++) fprintf(stderr, "%d:%02x ", i, (unsigned char)dirent[i]);
  fprintf(stderr, "\n");*/
  
  
  return 0;
}

int isyes(char *str)
{
  if (strncasecmp (str, "yes", 3) == 0) return 1;
  if (strncasecmp (str, "1", 1) == 0) return 1;
  return 0;
}

int parse_dir(char *str, int *line)
{
#ifdef NIXX
  unsigned char root_fid[FID_LEN];
  char *child, *parent;


  fidlet (root_fid, 0x3f, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff);
  
  new_scdnode(root_fid, NULL, SCFS_TYPE_DIR);
  child = strtok(str, Separator) ;
  parent = strtok(NULL, Separator) ;
  read_couple(child, parent);
  while ((child = strtok(NULL, Separator))) {
    if (strlen(child) < 4) break;
    parent = strtok(NULL, Separator) ;
    read_couple (child, parent);
  }
  
  /*printf("\nnow print out all the stuff ... \n");
  for (i=0; i<scconfig.num_nodes; i++) {
    int j;
    struct scdnode* node = scconfig.scdnodes[i];
    printf("node %02x.%02x ", node->fid[0], node->fid[1]);
    if (node->parent != NULL)
      printf("is a child of %02x.%02x\n",
	     node->parent->fid[0], node->parent->fid[1]);
    if (node->num_children > 0) {
      printf("has children: ");
      if (node->type == SCFS_TYPE_DIR) {
	for (j=0; j<node->num_children; j++) 
	  printf("%02x.%02x ",
		 node->child[j]->fid[0],
		 node->child[j]->fid[1]);
	printf("\n");
      }
    }
    print_path(node);
    printf("\n");
    }
  */
#endif
  return 0;
}

int new_dir(struct scdnode *node)
{
  int offset = 0, rv, sw1, sw2, i;
  char *buf;
  struct fileent *fe;
  assert(node);

  if (godown(node)){
    arla_warnx(ADEBERROR, "Cannot go down to %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x.\n",
	       node->fileent.fid[0], node->fileent.fid[1],
	       node->fileent.fid[2], node->fileent.fid[3],
	       node->fileent.fid[4], node->fileent.fid[5],
	       node->fileent.fid[6], node->fileent.fid[7]);
    return -1;
  }
  
  if (open_file(fd, DIRENT_FILE0, DIRENT_FILE1)) {
    arla_warnx(ADEBERROR, "Cannot open file %02x.%02x.\n",
	       DIRENT_FILE0, DIRENT_FILE1);
    return -1;
  }

  buf = (char *)malloc(sizeof(struct fileent));
  for (i=0; ; i++) {
    rv = scread(fd, scconfig.cla_readbinary, 0xb0, (offset >> 8) & 0xff,
		offset & 0xff, sizeof(struct fileent), buf, &sw1, &sw2);
    if (rv <= 0) break;
    /*
    arla_warnx(ADEBMSG, "dirent : %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x\n",
	       buf[0], buf[1], buf[2], buf[3],
	       buf[4], buf[5], buf[6], buf[7]);
    arla_warnx(ADEBMSG, "(cont) : %02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x\n",
	       buf[8], buf[9], buf[10], buf[11],
	       buf[12], buf[13], buf[14], buf[15]);
    */
    fe = (struct fileent *)buf;
    if (fe->d_type == SCFS_TYPE_NULL) break;
    /* there is file entry */
    arla_warnx(ADEBMSG, "found directory entry of %02x.%02x.\n",
	       fe->fid[0], fe->fid[1]);
    /* put the new node to child node */
    node->num_children++;
    node->child[i] = (struct scdnode *)malloc(sizeof(struct scdnode));
    node->child[i]->fileent = *fe;
    node->child[i]->parent = node;
    node->child[i]->num_children = 0;
    offset += sizeof(struct fileent);
  }
  free(buf);

  return 0;
}

int scdir_installroot()
{
  unsigned char root_fid[FID_LEN];
  struct scdnode *root_node;
  
  fidlet (root_fid, 0x3f, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff);
  root_node = new_scdnode(root_fid, NULL, SCFS_TYPE_DIR);
  
  if (new_dir(root_node)) {
    arla_warnx (ADEBERROR, "new_dir for %02x.%02x failed.\n",
		root_fid[0], root_fid[1]);
    return -1;
  }
  return 0;
}
