
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/syscall.h>
#include <kafs.h>
#include "scfs_pioctl.h"

#define AFS_SYSCALL 211
#define AFS_PIOCTL 20

#define syscallarg(x)   union { x datum; register_t pad; }

main(int argc, char *argv[])
{
  struct ViceIoctl parms;
  struct scfs_creat_arg creat_arg;

  /* args check */
  if (argc != 3 && argc != 6) {
    fprintf(stderr, "Usage: %s path size-decimal (ACL0 ACL1 ACL2)\n", argv[0]);
    exit (1);
  }
  
  /* create */

  memset(&parms, 0, sizeof(parms));

  creat_arg.path[0] = argv[1][0];
  creat_arg.path[1] = argv[1][1];
  sscanf(argv[2], "%d", &(creat_arg.size));
  if (argc == 6) {/* set ACL from stdin */
    sscanf(argv[3], "%0x", &(creat_arg.acl[0]));
    sscanf(argv[4], "%0x", &(creat_arg.acl[1]));
    sscanf(argv[5], "%0x", &(creat_arg.acl[2]));
  } else {/* set ACL to default */
    creat_arg.acl[0] = 0x0;
    creat_arg.acl[1] = 0x0;
    creat_arg.acl[2] = 0x0;
  }
    
  printf("pioctl create %c%c size=0x%x, ACL=%x %x %x.\n",
	 creat_arg.path[0], creat_arg.path[1], creat_arg.size,
	 creat_arg.acl[0], creat_arg.acl[1],creat_arg.acl[2]);
  parms.in = (void *)(&creat_arg);
  parms.out = NULL;
  parms.in_size = sizeof(creat_arg);
  parms.out_size = 0;
  syscall(AFS_SYSCALL, AFSCALL_PIOCTL,
		  ".", SCFS_CREAT, &parms, 0);
  if (errno) {
    if (errno == EINVAL)
      {
	printf("EINVAL :<\n");
	exit (1);
      }
    perror("syscall error: ");
  }
  else printf("syscall succeeded :)\n");
}
