
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* verify key */
#include <stdio.h>
#include "scrw.h"

/* remove path */
main(int argc, char *argv[])
{
  int r1, r2, fd, n, err;
  char buf[8];
  char file0[20]; /* = {0x03, 0x01};*/
  char file1[20]; /* = {0x03, 0x01};*/
  char key[8] = {0x47, 0x46, 0x58, 0x49, 0x32, 0x56, 0x78, 0x40};


  /* args check */
  if (argc != 2 && argc != 3) {
    fprintf(stderr, "Usage: %s path1 (path2)\n", argv[0]);
    exit (1);
  }

  sscanf(argv[1], "%c%c", &(file0[0]), &(file0[1]));
  printf("%x %x\n", file0[0], file0[1]);
  if (argc == 3) sscanf(argv[2], "%c%c", &(file1[0]), &(file1[1]));
    
  fd = scopen(1, SCODSR, NULL);
  n = screset(fd, buf, &err);

  scwrite(fd, 0xf0, 0x2a, 0x00, 0x01, 0x08, key, &r1, &r2);
  printf("verifykey: smartcard returns %x %x\n", r1, r2);

  if (argc == 2) {
    scwrite(fd, 0xf0, 0xe4, 0x00, 0x00, 0x02, file0, &r1, &r2);
    printf("remove 3f.00/%02x.%02x: smartcard returns %x %x\n",
	   file0[0], file0[1], r1, r2);
  } else {
    scwrite(fd, 0xc0, 0xa4, 0x00, 0x00, 0x02, file0, &r1, &r2);
    scwrite(fd, 0xf0, 0xe4, 0x00, 0x00, 0x02, file1, &r1, &r2);
    printf("remove 3f.00/%02x.%02x/%02x.%02x: smartcard returns %x %x\n",
	   file0[0], file0[1], file1[0], file1[1], r1, r2);
    
  }
  scclose(fd);
}
