
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/syscall.h>
#include <kafs.h>
#include "scfs_pioctl.h"
#include <sys/time.h>

#define AFS_SYSCALL 211
#define AFS_PIOCTL 20

#define syscallarg(x)   union { x datum; register_t pad; }

#include <sys/time.h>

/* global */
struct timeval tv0, tv1, tv2;
/*
#define PrintTime(x) gettimeofday(&tv0, NULL);printf("%d.%06d: %s\n", tv0.tv_sec, tv0.tv_usec, x);
#define PrintTime2(x)\
 gettimeofday(&tv1, NULL);\
 timersub(&tv1, &tv0, &tv0);\
 printf("%d.%06d: %s (%d.%06d)\n",\
  tv1.tv_sec, tv1.tv_usec, x, tv0.tv_sec, tv0.tv_usec);
*/
#define GetTime gettimeofday(&tv0, NULL);
#define PrintTime(x) \
 gettimeofday(&tv1, NULL);\
 timersub(&tv1, &tv0, &tv2);\
 printf("%d.%06d: %s (%d.%06d)\n", tv0.tv_sec, tv0.tv_usec, x, \
	 tv2.tv_sec, tv2.tv_usec);

int fd;
unsigned char buf[256];
unsigned char buf2[64];

void dowrite(int i);
void doread(int i);

main(int argc, char *argv[])
{
  struct ViceIoctl parms;
  struct scfs_creat_arg creat_arg;
  struct scfs_verifykey_arg verifykey_arg;
  int i, rv; 

  /* args check */
  if (argc != 3 && argc != 6) {
    fprintf(stderr, "Usage: %s path size-decimal (ACL0 ACL1 ACL2)\n", argv[0]);
    exit (1);
  }
  

  for (i=0; i<256; i++) buf[i] = 0x00; 

  /* veryify key */
  memset(&parms, 0, sizeof(parms));
  verifykey_arg.keynum = 0;
  verifykey_arg.keysize = 8;
  verifykey_arg.key[0] = (char)0xad;
  verifykey_arg.key[1] = (char)0x9f;
  verifykey_arg.key[2] = (char)0x61;
  verifykey_arg.key[3] = (char)0xfe;
  verifykey_arg.key[4] = (char)0xfa;
  verifykey_arg.key[5] = (char)0x20;
  verifykey_arg.key[6] = (char)0xce;
  verifykey_arg.key[7] = (char)0x63;
  
  parms.in = (void *)(&verifykey_arg);
  parms.out = NULL;
  parms.in_size = sizeof(verifykey_arg);
  parms.out_size = 0;

  GetTime
  syscall(AFS_SYSCALL, AFSCALL_PIOCTL,
	  ".", SCFS_VERIFYKEY, &parms, 0);
  PrintTime("Verifykey");

  if (errno) {
    if (errno == EINVAL)
      {
	printf("verifykey EINVAL :<\n");
	exit (1);
      }
    perror("verifykey syscall error: ");
  }
  
  /* create */
  memset(&parms, 0, sizeof(parms));
  creat_arg.path[0] = argv[1][0];
  creat_arg.path[1] = argv[1][1];
  sscanf(argv[2], "%d", &(creat_arg.size));
  if (argc == 6) {/* set ACL from stdin */
    sscanf(argv[3], "%0x", &(creat_arg.acl[0]));
    sscanf(argv[4], "%0x", &(creat_arg.acl[1]));
    sscanf(argv[5], "%0x", &(creat_arg.acl[2]));
  } else {/* set ACL to default */
    creat_arg.acl[0] = 0x0;
    creat_arg.acl[1] = 0x0;
    creat_arg.acl[2] = 0x0;
  }
    
  printf("pioctl create %c%c size=0x%x, ACL=%x %x %x.\n",
	 creat_arg.path[0], creat_arg.path[1], creat_arg.size,
	 creat_arg.acl[0], creat_arg.acl[1],creat_arg.acl[2]);
  parms.in = (void *)(&creat_arg);
  parms.out = NULL;
  parms.in_size = sizeof(creat_arg);
  parms.out_size = 0;

  GetTime
  syscall(AFS_SYSCALL, AFSCALL_PIOCTL,
		  ".", SCFS_CREAT, &parms, 0);
  if (errno) {
    if (errno == EINVAL)
      {
	printf("EINVAL :<\n");
	exit (1);
      }
    perror("syscall error: ");
    exit (1); 
  }
  PrintTime("create end");
  
  GetTime
  /*printf("open file %s\n", argv[1]);*/
  if ((fd = open(argv[1], O_RDWR, 777)) == -1) {
      printf("Cannot open %s : %s\n", argv[1], strerror(errno));
      exit (-1);
  }
  PrintTime("open end");

  dowrite(1);
  dowrite(8);
  dowrite(64);
  dowrite(128);
  dowrite(196);
  dowrite(254);

  doread(1);
  doread(8);
  doread(64);
  doread(128);
  doread(196);
  doread(254);

  GetTime
  if ((rv = remove(argv[1])) < 0){
      printf("cannot remove %s.  errno=%d\n", argv[1], errno);
      exit (-1);
  }
  PrintTime("remove end");
  
}

void dowrite(int i)
{
  sprintf(buf2, "write %d ", i);
  GetTime
  if (write(fd, buf, i) <= 0) {
    printf("cannot write.  errno=%d\n", errno);
    exit (-1);
  }
  PrintTime(buf2);
  lseek(fd, 0, SEEK_SET);
}

void doread(int i)
{
  sprintf(buf2, "read %d ", i);
  GetTime
  if (read(fd, buf, i) <= 0) {
    printf("cannot read.  errno=%d\n", errno);
    exit (-1);
  }
  PrintTime(buf2);
  lseek(fd, 0, SEEK_SET);
}
