
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

/*#include <sys/ioctl.h>*/
#include "scfs_ioctl.h"
#include <kafs.h>

/* Macros */
#ifdef NIPERF
#include <sys/time.h>
#define PrintTime(x) {struct timeval tv;gettimeofday(&tv, NULL);fprintf(stderr, "%d.%06d: %s\n", tv.tv_sec, tv.tv_usec, x);}
#else
#define PrintTime(x)
#endif /* NIPERF */
/*
#define timersub(tvp, uvp, vvp)                                         \
        do {                                                            \
                (vvp)->tv_sec = (tvp)->tv_sec - (uvp)->tv_sec;          \
                (vvp)->tv_usec = (tvp)->tv_usec - (uvp)->tv_usec;       \
                if ((vvp)->tv_usec < 0) {                               \
                        (vvp)->tv_sec--;                                \
                        (vvp)->tv_usec += 1000000;                      \
                }                                                       \
		        } while (0)
*/

main(int argc, char *argv[])
{
  char buf[256];
  unsigned char *buf2;
  char buf_io[8];
  int fd;
  struct stat s;
  int rv, i, j;
  int size;
  struct timeval tv, uv, vv;
    
  if (argc > 2) {
    strcpy (buf, argv[1]);
    size = atoi(argv[2]);
  } else {
    fprintf(stderr, "Usage: getc filename numbytes\n");
    fprintf(stderr, "Example: getc /arla/7777/7701 8\n");
    exit (-1);
  }
  if ((fd = open(buf, O_RDWR, 777)) == -1) {
    printf("%s: %s\n", argv[1], strerror(errno));
    exit (-1);
  }
  buf2 = (char *)malloc(size);
#ifdef NIPERF 
  PrintTime("Readx: Call read()");
  gettimeofday(&tv, NULL);
#endif /* NIPERF */
  for (i=0;
  if ((rv = read(fd, buf2, size)) <= 0) {
    printf("can't read.  errno=%d\n", errno);
    exit (-1);
  }
  /*PrintTime("Readx: read returns()");*/
#ifdef NIPERF
  gettimeofday(&uv, NULL);
  timersub(&uv, &tv, &vv);
  printf("%d.%06d:\n", tv.tv_sec, tv.tv_usec);
  printf("%d.%06d:\n", vv.tv_sec, vv.tv_usec);
#endif /* NIPERF */

#ifndef NIPERF
  printf("rv=%d\n", rv);
  for (i=0; i<rv; i++) {
    printf("%02x ", buf2[i]);
  }
  printf("\n");
#endif /* NIPERF */
  /*
  strcpy (buf, "hello, world! :)");
  if ((rv=write(fd, buf, strlen(buf))) < 0) {
    printf("can't write? rv=%d, errno=%d\n", rv, errno);
    exit (-1);
  }

  if (read(fd, buf2, 50) <= 0) {
    printf("can't read? %d\n", errno);
    exit (-1);
  }
  
  printf("%s\n", buf2);
  */

  /*
    if (rv = fstat(fd, &s)) {
    printf("can't fstat  rv=%d, errno=%d\n", rv, errno);
    }
    else {
    printf("stat goes o.k. %d: ", s.st_mode);
    if (S_ISREG(s.st_mode)) printf("Regular File\n");
    if (S_ISDIR(s.st_mode)) printf("Directory\n");
    }
  */
}
