
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

void VOLSER_AFSVolCreateVolume_print(char *ptr, size_t *total_len)
{
int found = 0;
int32_t partition;
char name;
int32_t type;
int32_t parent;
int32_t volid;
int32_t trans;

{ int32_t tmp = htonl(partition); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(name); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(type); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(parent); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(volid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(trans); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
fail:
printf("{");if (found > 0)

{ --found;
printf(" partition = %d", partition);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" name = %d", name);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" type = %d", type);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" parent = %d", parent);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" volid = %d", volid);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" trans = %d", trans);} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolTransCreate_print(char *ptr, size_t *total_len)
{
int found = 0;
int32_t volume;
int32_t partition;
int32_t flags;
int32_t trans;

{ int32_t tmp = htonl(volume); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(partition); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(trans); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
fail:
printf("{");if (found > 0)

{ --found;
printf(" volume = %d", volume);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" partition = %d", partition);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" flags = %d", flags);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" trans = %d", trans);} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolEndTrans_print(char *ptr, size_t *total_len)
{
int found = 0;
int32_t trans;
int32_t rcode;

{ int32_t tmp = htonl(trans); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(rcode); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
fail:
printf("{");if (found > 0)

{ --found;
printf(" trans = %d", trans);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" rcode = %d", rcode);} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolGetFlags_print(char *ptr, size_t *total_len)
{
int found = 0;
int32_t trans;
int32_t flags;

{ int32_t tmp = htonl(trans); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
fail:
printf("{");if (found > 0)

{ --found;
printf(" trans = %d", trans);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" flags = %d", flags);} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolSetFlags_print(char *ptr, size_t *total_len)
{
int found = 0;
int32_t trans;
int32_t flags;

{ int32_t tmp = htonl(trans); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
fail:
printf("{");if (found > 0)

{ --found;
printf(" trans = %d", trans);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" flags = %d", flags);} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolGetName_print(char *ptr, size_t *total_len)
{
int found = 0;
int32_t tid;
char tname[256];

{ int32_t tmp = htonl(tid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{
unsigned len = strlen(tname);
if (*total_len < len) goto fail;
*total_len -= len;
{ int32_t tmp = htonl(len); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
strncpy (ptr, tname, len);
ptr += len + (4 - (len % 4) % 4);
*total_len -= len + (4 - (len % 4) % 4);
}
++found;
fail:
printf("{");if (found > 0)

{ --found;
printf(" tid = %d", tid);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
/* printing TSTRING tname */
printf(" tname = %s", tname);} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolSetDate_print(char *ptr, size_t *total_len)
{
int found = 0;
int32_t tid;
int32_t newDate;

{ int32_t tmp = htonl(tid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(newDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
fail:
printf("{");if (found > 0)

{ --found;
printf(" tid = %d", tid);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" newDate = %d", newDate);} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolListPartitions_print(char *ptr, size_t *total_len)
{
int found = 0;
struct pIDs partIDs;

{
int i0;
for(i0 = 0; i0 < 26;++i0){
{ int32_t tmp = htonl(partIDs.partIds[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
++found;
fail:
printf("{");if (found > 0)

{ --found;
/* printing TSTRUCT partIDs */
{ 
unsigned int i0;
/* printing ARRAY partIDs.partIds */
for (i0 = 0; i0 < 26; ++i0) {
printf("  = %d", partIDs.partIds[i0]);
if (i0 != 26 - 1) printf(",");
}
}

} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolPartitionInfo_print(char *ptr, size_t *total_len)
{
int found = 0;
char name[256];
struct diskPartition partition;

{
unsigned len = strlen(name);
if (*total_len < len) goto fail;
*total_len -= len;
{ int32_t tmp = htonl(len); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
strncpy (ptr, name, len);
ptr += len + (4 - (len % 4) % 4);
*total_len -= len + (4 - (len % 4) % 4);
}
++found;
{
int i0;
for(i0 = 0; i0 < 32;++i0){
{ int32_t tmp = htonl(partition.name[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{
int i0;
for(i0 = 0; i0 < 32;++i0){
{ int32_t tmp = htonl(partition.devName[i0]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl(partition.lock_fd); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(partition.totalUsable); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(partition.free); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(partition.minFree); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
fail:
printf("{");if (found > 0)

{ --found;
/* printing TSTRING name */
printf(" name = %s", name);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
/* printing TSTRUCT partition */
{ 
unsigned int i0;
/* printing ARRAY partition.name */
for (i0 = 0; i0 < 32; ++i0) {
printf("  = %d", partition.name[i0]);
if (i0 != 32 - 1) printf(",");
}
}

{ 
unsigned int i0;
/* printing ARRAY partition.devName */
for (i0 = 0; i0 < 32; ++i0) {
printf("  = %d", partition.devName[i0]);
if (i0 != 32 - 1) printf(",");
}
}

printf(" .lock_fd = %d", partition.lock_fd);
printf(" .totalUsable = %d", partition.totalUsable);
printf(" .free = %d", partition.free);
printf(" .minFree = %d", partition.minFree);
} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolListVolumes_print(char *ptr, size_t *total_len)
{
int found = 0;
int32_t partID;
int32_t flags;
volEntries resultEntries;

{ int32_t tmp = htonl(partID); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(resultEntries.len); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < resultEntries.len;++i0){
{
int i1;
for(i1 = 0; i1 < 32;++i1){
{ int32_t tmp = htonl(resultEntries.val[i0].name[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl(resultEntries.val[i0].volid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].type); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].backupID); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].parentID); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].cloneID); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].status); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].copyDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].inUse); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].needsSalvaged); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].destroyMe); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].creationDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].accessDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].updateDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].backupDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].dayUse); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].filecount); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].maxquota); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].size); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].spare0); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].spare1); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].spare2); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].spare3); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
++found;
fail:
printf("{");if (found > 0)

{ --found;
printf(" partID = %d", partID);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" flags = %d", flags);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
/* printing TVARRAY resultEntries */
unsigned int i0;
for (i0 = 0; i0 < resultEntries.len; ++i0) {
/* printing TSTRUCT resultEntries.val[i0]resultEntries */
{ 
unsigned int i1;
/* printing ARRAY resultEntries.val[i0]resultEntries.name */
for (i1 = 0; i1 < 32; ++i1) {
printf("  = %d", resultEntries.val[i0]resultEntries.name[i1]);
if (i1 != 32 - 1) printf(",");
}
}

printf(" .volid = %d", resultEntries.val[i0]resultEntries.volid);
printf(" .type = %d", resultEntries.val[i0]resultEntries.type);
printf(" .backupID = %d", resultEntries.val[i0]resultEntries.backupID);
printf(" .parentID = %d", resultEntries.val[i0]resultEntries.parentID);
printf(" .cloneID = %d", resultEntries.val[i0]resultEntries.cloneID);
printf(" .status = %d", resultEntries.val[i0]resultEntries.status);
printf(" .copyDate = %d", resultEntries.val[i0]resultEntries.copyDate);
printf(" .inUse = %d", resultEntries.val[i0]resultEntries.inUse);
printf(" .needsSalvaged = %d", resultEntries.val[i0]resultEntries.needsSalvaged);
printf(" .destroyMe = %d", resultEntries.val[i0]resultEntries.destroyMe);
printf(" .creationDate = %d", resultEntries.val[i0]resultEntries.creationDate);
printf(" .accessDate = %d", resultEntries.val[i0]resultEntries.accessDate);
printf(" .updateDate = %d", resultEntries.val[i0]resultEntries.updateDate);
printf(" .backupDate = %d", resultEntries.val[i0]resultEntries.backupDate);
printf(" .dayUse = %d", resultEntries.val[i0]resultEntries.dayUse);
printf(" .filecount = %d", resultEntries.val[i0]resultEntries.filecount);
printf(" .maxquota = %d", resultEntries.val[i0]resultEntries.maxquota);
printf(" .size = %d", resultEntries.val[i0]resultEntries.size);
printf(" .flags = %d", resultEntries.val[i0]resultEntries.flags);
printf(" .spare0 = %d", resultEntries.val[i0]resultEntries.spare0);
printf(" .spare1 = %d", resultEntries.val[i0]resultEntries.spare1);
printf(" .spare2 = %d", resultEntries.val[i0]resultEntries.spare2);
printf(" .spare3 = %d", resultEntries.val[i0]resultEntries.spare3);

if (i0 != resultEntries.len - 1) printf(",");
}
} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolListOneVolume_print(char *ptr, size_t *total_len)
{
int found = 0;
int32_t partID;
int32_t volid;
volEntries resultEntries;

{ int32_t tmp = htonl(partID); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(volid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
++found;
{ int32_t tmp = htonl(resultEntries.len); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < resultEntries.len;++i0){
{
int i1;
for(i1 = 0; i1 < 32;++i1){
{ int32_t tmp = htonl(resultEntries.val[i0].name[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl(resultEntries.val[i0].volid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].type); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].backupID); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].parentID); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].cloneID); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].status); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].copyDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].inUse); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].needsSalvaged); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].destroyMe); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].creationDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].accessDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].updateDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].backupDate); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].dayUse); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].filecount); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].maxquota); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].size); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].flags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].spare0); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].spare1); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].spare2); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(resultEntries.val[i0].spare3); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
++found;
fail:
printf("{");if (found > 0)

{ --found;
printf(" partID = %d", partID);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
printf(" volid = %d", volid);printf(",");
} else
goto failandquit;
if (found > 0)

{ --found;
/* printing TVARRAY resultEntries */
unsigned int i0;
for (i0 = 0; i0 < resultEntries.len; ++i0) {
/* printing TSTRUCT resultEntries.val[i0]resultEntries */
{ 
unsigned int i1;
/* printing ARRAY resultEntries.val[i0]resultEntries.name */
for (i1 = 0; i1 < 32; ++i1) {
printf("  = %d", resultEntries.val[i0]resultEntries.name[i1]);
if (i1 != 32 - 1) printf(",");
}
}

printf(" .volid = %d", resultEntries.val[i0]resultEntries.volid);
printf(" .type = %d", resultEntries.val[i0]resultEntries.type);
printf(" .backupID = %d", resultEntries.val[i0]resultEntries.backupID);
printf(" .parentID = %d", resultEntries.val[i0]resultEntries.parentID);
printf(" .cloneID = %d", resultEntries.val[i0]resultEntries.cloneID);
printf(" .status = %d", resultEntries.val[i0]resultEntries.status);
printf(" .copyDate = %d", resultEntries.val[i0]resultEntries.copyDate);
printf(" .inUse = %d", resultEntries.val[i0]resultEntries.inUse);
printf(" .needsSalvaged = %d", resultEntries.val[i0]resultEntries.needsSalvaged);
printf(" .destroyMe = %d", resultEntries.val[i0]resultEntries.destroyMe);
printf(" .creationDate = %d", resultEntries.val[i0]resultEntries.creationDate);
printf(" .accessDate = %d", resultEntries.val[i0]resultEntries.accessDate);
printf(" .updateDate = %d", resultEntries.val[i0]resultEntries.updateDate);
printf(" .backupDate = %d", resultEntries.val[i0]resultEntries.backupDate);
printf(" .dayUse = %d", resultEntries.val[i0]resultEntries.dayUse);
printf(" .filecount = %d", resultEntries.val[i0]resultEntries.filecount);
printf(" .maxquota = %d", resultEntries.val[i0]resultEntries.maxquota);
printf(" .size = %d", resultEntries.val[i0]resultEntries.size);
printf(" .flags = %d", resultEntries.val[i0]resultEntries.flags);
printf(" .spare0 = %d", resultEntries.val[i0]resultEntries.spare0);
printf(" .spare1 = %d", resultEntries.val[i0]resultEntries.spare1);
printf(" .spare2 = %d", resultEntries.val[i0]resultEntries.spare2);
printf(" .spare3 = %d", resultEntries.val[i0]resultEntries.spare3);

if (i0 != resultEntries.len - 1) printf(",");
}
} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

void VOLSER_AFSVolMonitor_print(char *ptr, size_t *total_len)
{
int found = 0;
transDebugEntries result;

{ int32_t tmp = htonl(result.len); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i0;
for(i0 = 0; i0 < result.len;++i0){
{ int32_t tmp = htonl(result.val[i0].tid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].time); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].creationTime); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].returnCode); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].volid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].partition); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].iflags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].vflags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].tflags); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{
int i1;
for(i1 = 0; i1 < 30;++i1){
{ int32_t tmp = htonl(result.val[i0].lastProcName[i1]); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
{ int32_t tmp = htonl(result.val[i0].callValid); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].readNext); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].transmitNext); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].lastSendTime); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
{ int32_t tmp = htonl(result.val[i0].lastReceiveTime); if (*total_len < sizeof(int32_t)) goto fail;
bcopy ((char*)&tmp, ptr, sizeof(int32_t)); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
}
}
++found;
fail:
printf("{");if (found > 0)

{ --found;
/* printing TVARRAY result */
unsigned int i0;
for (i0 = 0; i0 < result.len; ++i0) {
/* printing TSTRUCT result.val[i0]result */
printf(" .tid = %d", result.val[i0]result.tid);
printf(" .time = %d", result.val[i0]result.time);
printf(" .creationTime = %d", result.val[i0]result.creationTime);
printf(" .returnCode = %d", result.val[i0]result.returnCode);
printf(" .volid = %d", result.val[i0]result.volid);
printf(" .partition = %d", result.val[i0]result.partition);
printf(" .iflags = %d", result.val[i0]result.iflags);
printf(" .vflags = %d", result.val[i0]result.vflags);
printf(" .tflags = %d", result.val[i0]result.tflags);
{ 
unsigned int i1;
/* printing ARRAY result.val[i0]result.lastProcName */
for (i1 = 0; i1 < 30; ++i1) {
printf("  = %d", result.val[i0]result.lastProcName[i1]);
if (i1 != 30 - 1) printf(",");
}
}

printf(" .callValid = %d", result.val[i0]result.callValid);
printf(" .readNext = %d", result.val[i0]result.readNext);
printf(" .transmitNext = %d", result.val[i0]result.transmitNext);
printf(" .lastSendTime = %d", result.val[i0]result.lastSendTime);
printf(" .lastReceiveTime = %d", result.val[i0]result.lastReceiveTime);

if (i0 != result.len - 1) printf(",");
}
} else
goto failandquit;
printf("}\n");
return ptr;
failandquit:
printf("Error decoding paket");
return NULL;}

/* generated by $Id: output.c,v 1.43 1998/12/13 16:52:04 assar Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <VOLSER_.h>
#ifdef HAVE_ATYPES_H
#include <atypes.h>
#endif /* HAVE_ATYPES_H */

VOLSER_tcpdump_print(const unsigned char *ptr,unsigned int len,unsigned char *bp2)
{
u_int32_t opcode
size_t *total_len = len;
char *ret;
{ int32_t tmp; if (*total_len < sizeof(int32_t)) goto fail;bcopy (ptr, (char *)&tmp, sizeof(int32_t)); opcode = ntohl(tmp); ptr += sizeof(int32_t); *total_len -= sizeof(int32_t);}
switch(opcode) {
case 100:
printf("VOLSER_AFSVolCreateVolume(");
ret = VOLSER_AFSVolCreateVolume_print(ptr, &total_len);
break;
case 108:
printf("VOLSER_AFSVolTransCreate(");
ret = VOLSER_AFSVolTransCreate_print(ptr, &total_len);
break;
case 104:
printf("VOLSER_AFSVolEndTrans(");
ret = VOLSER_AFSVolEndTrans_print(ptr, &total_len);
break;
case 107:
printf("VOLSER_AFSVolGetFlags(");
ret = VOLSER_AFSVolGetFlags_print(ptr, &total_len);
break;
case 106:
printf("VOLSER_AFSVolSetFlags(");
ret = VOLSER_AFSVolSetFlags_print(ptr, &total_len);
break;
case 112:
printf("VOLSER_AFSVolGetName(");
ret = VOLSER_AFSVolGetName_print(ptr, &total_len);
break;
case 123:
printf("VOLSER_AFSVolSetDate(");
ret = VOLSER_AFSVolSetDate_print(ptr, &total_len);
break;
case 115:
printf("VOLSER_AFSVolListPartitions(");
ret = VOLSER_AFSVolListPartitions_print(ptr, &total_len);
break;
case 119:
printf("VOLSER_AFSVolPartitionInfo(");
ret = VOLSER_AFSVolPartitionInfo_print(ptr, &total_len);
break;
case 116:
printf("VOLSER_AFSVolListVolumes(");
ret = VOLSER_AFSVolListVolumes_print(ptr, &total_len);
break;
case 121:
printf("VOLSER_AFSVolListOneVolume(");
ret = VOLSER_AFSVolListOneVolume_print(ptr, &total_len);
break;
case 118:
printf("VOLSER_AFSVolMonitor(");
ret = VOLSER_AFSVolMonitor_print(ptr, &total_len);
break;
default:
printf ("Unknown opcode %s->%d\n", package, opcode);
}
fail:
printf("Error decoding packet\n");
}

