
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from volumeserver.xg */
#include "volumeserver.h"

#include "volumeserver.ss.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <roken.h>
#ifndef HAVE_BCOPY
#define bcopy(a,b,c) memcpy((b),(a),(c))
#endif /* !HAVE_BCOPY */

#ifdef RCSID
RCSID("volumeserver.ss.c generated from volumeserver.xg with $Id: output.c,v 1.43 1998/12/13 16:52:04 assar Exp $");
#endif

int _VOLSER_AFSVolCreateVolume(
struct rx_call *call)
{
int _result;
int32_t partition;
char name;
int32_t type;
int32_t parent;
int32_t volid;
int32_t trans;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
partition = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
name = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
type = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
parent = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
volid = ntohl (u);
}
_result = VOLSER_AFSVolCreateVolume(call, partition, &name, type, parent, &volid, &trans);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (trans);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolTransCreate(
struct rx_call *call)
{
int _result;
int32_t volume;
int32_t partition;
int32_t flags;
int32_t trans;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
volume = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
partition = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
flags = ntohl (u);
}
_result = VOLSER_AFSVolTransCreate(call, volume, partition, flags, &trans);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (trans);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolEndTrans(
struct rx_call *call)
{
int _result;
int32_t trans;
int32_t rcode;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
trans = ntohl (u);
}
_result = VOLSER_AFSVolEndTrans(call, trans, &rcode);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (rcode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolGetFlags(
struct rx_call *call)
{
int _result;
int32_t trans;
int32_t flags;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
trans = ntohl (u);
}
_result = VOLSER_AFSVolGetFlags(call, trans, &flags);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolSetFlags(
struct rx_call *call)
{
int _result;
int32_t trans;
int32_t flags;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
trans = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
flags = ntohl (u);
}
_result = VOLSER_AFSVolSetFlags(call, trans, flags);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolGetName(
struct rx_call *call)
{
int _result;
int32_t tid;
char tname[256];

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
tid = ntohl (u);
}
_result = VOLSER_AFSVolGetName(call, tid, tname);
if (_result) goto funcfail;
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(tname);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, tname, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolSetDate(
struct rx_call *call)
{
int _result;
int32_t tid;
int32_t newDate;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
tid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
newDate = ntohl (u);
}
_result = VOLSER_AFSVolSetDate(call, tid, newDate);
if (_result) goto funcfail;
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolListPartitions(
struct rx_call *call)
{
int _result;
struct pIDs partIDs;

_result = VOLSER_AFSVolListPartitions(call, &partIDs);
if (_result) goto funcfail;
{
int i0;
for(i0 = 0; i0 < 26;++i0){
{ u_int32_t u;
u = htonl (partIDs.partIds[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolPartitionInfo(
struct rx_call *call)
{
int _result;
char name[256];
struct diskPartition partition;

{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, name, len) != len)
goto fail;
name[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
_result = VOLSER_AFSVolPartitionInfo(call, name, &partition);
if (_result) goto funcfail;
{
int i0;
for(i0 = 0; i0 < 32;++i0){
{ u_int32_t u;
u = htonl (partition.name[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{
int i0;
for(i0 = 0; i0 < 32;++i0){
{ u_int32_t u;
u = htonl (partition.devName[i0]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (partition.lock_fd);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (partition.totalUsable);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (partition.free);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (partition.minFree);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return _result;
fail:
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolListVolumes(
struct rx_call *call)
{
int _result;
int32_t partID;
int32_t flags;
volEntries resultEntries;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
partID = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
flags = ntohl (u);
}
_result = VOLSER_AFSVolListVolumes(call, partID, flags, &resultEntries);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (resultEntries.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < resultEntries.len;++i0){
{
int i1;
for(i1 = 0; i1 < 32;++i1){
{ u_int32_t u;
u = htonl (resultEntries.val[i0].name[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].type);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].backupID);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].parentID);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].cloneID);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].status);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].copyDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].inUse);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].needsSalvaged);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].destroyMe);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].creationDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].accessDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].updateDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].backupDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].dayUse);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].filecount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].maxquota);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].size);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].spare0);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
free(resultEntries.val);
return _result;
fail:
free(resultEntries.val);
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolListOneVolume(
struct rx_call *call)
{
int _result;
int32_t partID;
int32_t volid;
volEntries resultEntries;

{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
partID = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
volid = ntohl (u);
}
_result = VOLSER_AFSVolListOneVolume(call, partID, volid, &resultEntries);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (resultEntries.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < resultEntries.len;++i0){
{
int i1;
for(i1 = 0; i1 < 32;++i1){
{ u_int32_t u;
u = htonl (resultEntries.val[i0].name[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].type);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].backupID);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].parentID);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].cloneID);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].status);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].copyDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].inUse);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].needsSalvaged);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].destroyMe);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].creationDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].accessDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].updateDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].backupDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].dayUse);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].filecount);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].maxquota);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].size);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].spare0);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].spare1);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].spare2);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (resultEntries.val[i0].spare3);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
free(resultEntries.val);
return _result;
fail:
free(resultEntries.val);
return rx_Error(call);
funcfail:
return _result;
}

int _VOLSER_AFSVolMonitor(
struct rx_call *call)
{
int _result;
transDebugEntries result;

_result = VOLSER_AFSVolMonitor(call, &result);
if (_result) goto funcfail;
{ u_int32_t u;
u = htonl (result.len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < result.len;++i0){
{ u_int32_t u;
u = htonl (result.val[i0].tid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].time);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].creationTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].returnCode);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].partition);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].iflags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].vflags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].tflags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i1;
for(i1 = 0; i1 < 30;++i1){
{ u_int32_t u;
u = htonl (result.val[i0].lastProcName[i1]);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
{ u_int32_t u;
u = htonl (result.val[i0].callValid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].readNext);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].transmitNext);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].lastSendTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (result.val[i0].lastReceiveTime);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
}
}
free(result.val);
return _result;
fail:
free(result.val);
return rx_Error(call);
funcfail:
return _result;
}

int VOLSER_ExecuteRequest(struct rx_call *call)
{
unsigned opcode;
int _result;
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
opcode = ntohl (u);
}
switch(opcode) {
case 100: {
_result = _VOLSER_AFSVolCreateVolume(call);
break;
}
case 108: {
_result = _VOLSER_AFSVolTransCreate(call);
break;
}
case 104: {
_result = _VOLSER_AFSVolEndTrans(call);
break;
}
case 107: {
_result = _VOLSER_AFSVolGetFlags(call);
break;
}
case 106: {
_result = _VOLSER_AFSVolSetFlags(call);
break;
}
case 112: {
_result = _VOLSER_AFSVolGetName(call);
break;
}
case 123: {
_result = _VOLSER_AFSVolSetDate(call);
break;
}
case 115: {
_result = _VOLSER_AFSVolListPartitions(call);
break;
}
case 119: {
_result = _VOLSER_AFSVolPartitionInfo(call);
break;
}
case 116: {
_result = _VOLSER_AFSVolListVolumes(call);
break;
}
case 121: {
_result = _VOLSER_AFSVolListOneVolume(call);
break;
}
case 118: {
_result = _VOLSER_AFSVolMonitor(call);
break;
}
default:
fprintf (stderr, "Ignoring %d\n", opcode);
}
return _result;
fail:
return rx_Error(call);
}

