
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from volumeserver.xg */
#ifndef _VOLUMESERVER_
#define _VOLUMESERVER_

#include <atypes.h>
#include <rx/rx.h>
#include <rx/rx_null.h>
#include <arlad/fs_errors.h>
#define VLDB_MAXSERVER 80

#define VOLSERVICE_PORT 7005

#define VOLSERVICE_ID 4

#define INVALID_BID 0

#define VOLSER_MAXVOLNAME 65

#define VOLSER_OLDMAXVOLNAME 32

#define VOLSER_MAX_REPSITES 7

#define VNAMESIZE 32

#define VOLCREATEVOLUME 100

#define VOLDELETEVOLUME 101

#define VOLRESTORE 102

#define VOLFORWARD 103

#define VOLENDTRANS 104

#define VOLCLONE 105

#define VOLSETFLAGS 106

#define VOLGETFLAGS 107

#define VOLTRANSCREATE 108

#define VOLDUMP 109

#define VOLGETNTHVOLUME 110

#define VOLSETFORWARDING 111

#define VOLGETNAME 112

#define VOLGETSTATUS 113

#define VOLSIGRESTORE 114

#define VOLLISTPARTITIONS 115

#define VOLLISTVOLS 116

#define VOLSETIDTYPES 117

#define VOLMONITOR 118

#define VOLDISKPART 119

#define VOLRECLOSE 120

#define VOLLISTONEVOL 121

#define VOLNUKE 122

#define VOLSETDATE 123

#define PARTVALID 1

#define VOK 2

#define VBUSY 110

#define VOLSERTRELE_ERROR 1492325120

#define VOLSERNO_OP 1492325121

#define VOLSERREAD_DUMPERROR 1492325122

#define VOLSERDUMPERROR 1492325123

#define VOLSERATTACH_ERROR 1492325124

#define VOLSERILLEGAL_PARTITION 1492325125

#define VOLSERDETACH_ERROR 1492325126

#define VOLSERBAD_ACCESS 1492325127

#define VOLSERVLDB_ERROR 1492325128

#define VOLSERBADNAME 1492325129

#define VOLSERVOLMOVED 1492325130

#define VOLSERBADOP 1492325131

#define VOLSERBADRELEASE 1492325132

#define VOLSERVOLBUSY 1492325133

#define VOLSERNO_MEMORY 1492325134

#define VOLSERNOVOL 1492325135

#define VOLSERMULTIRWVOL 1492325136

#define VOLSERFAILEDOP 1492325137

struct volser_trans {
     struct volser_trans *next;
     int32_t tid;
     int32_t time;
     int32_t creationTime;
     int32_t returnCode;
     int32_t volid;
     int32_t partition;
     int32_t dumpTransId;
     int32_t dumpSeq;
     int16_t refCount;
     int16_t iflags;
     char vflags;
     char tflags;
     char incremental;
     char lastProcName[ 30 ];
};
typedef struct volser_trans volser_trans;

char *ydr_encode_volser_trans(volser_trans *o, char *ptr, size_t *total_len);
char *ydr_decode_volser_trans(volser_trans *o, char *ptr, size_t *total_len);
void ydr_print_volser_trans(volser_trans *o);
struct volDescription {
     char volName[ 65 ];
     int32_t volId;
     int32_t volSize;
     int32_t volFlags;
     int32_t volCloneId;
};
typedef struct volDescription volDescription;

#define VOLDESCRIPTION_SIZE 276
char *ydr_encode_volDescription(volDescription *o, char *ptr, size_t *total_len);
char *ydr_decode_volDescription(volDescription *o, char *ptr, size_t *total_len);
void ydr_print_volDescription(volDescription *o);
struct partList {
     int32_t partId[ 26 ];
     int32_t partFlags[ 26 ];
};
typedef struct partList partList;

#define PARTLIST_SIZE 208
char *ydr_encode_partList(partList *o, char *ptr, size_t *total_len);
char *ydr_decode_partList(partList *o, char *ptr, size_t *total_len);
void ydr_print_partList(partList *o);
struct volser_status {
     int32_t volID;
     int32_t nextUnique;
     int32_t type;
     int32_t parentID;
     int32_t cloneID;
     int32_t backupID;
     int32_t restoredFromID;
     int32_t maxQuota;
     int32_t minQuota;
     int32_t owner;
     int32_t creationDate;
     int32_t accessDate;
     int32_t updateDate;
     int32_t exprirationDate;
     int32_t backupDate;
     int32_t copyDate;
};
typedef struct volser_status volser_status;

#define VOLSER_STATUS_SIZE 64
char *ydr_encode_volser_status(volser_status *o, char *ptr, size_t *total_len);
char *ydr_decode_volser_status(volser_status *o, char *ptr, size_t *total_len);
void ydr_print_volser_status(volser_status *o);
struct destServer {
     int32_t destHost;
     int32_t destPort;
     int32_t destSSID;
};
typedef struct destServer destServer;

#define DESTSERVER_SIZE 12
char *ydr_encode_destServer(destServer *o, char *ptr, size_t *total_len);
char *ydr_decode_destServer(destServer *o, char *ptr, size_t *total_len);
void ydr_print_destServer(destServer *o);
struct volintInfo {
     char name[ 32 ];
     int32_t volid;
     int32_t type;
     int32_t backupID;
     int32_t parentID;
     int32_t cloneID;
     int32_t status;
     int32_t copyDate;
     char inUse;
     char needsSalvaged;
     char destroyMe;
     int32_t creationDate;
     int32_t accessDate;
     int32_t updateDate;
     int32_t backupDate;
     int32_t dayUse;
     int32_t filecount;
     int32_t maxquota;
     int32_t size;
     int32_t flags;
     int32_t spare0;
     int32_t spare1;
     int32_t spare2;
     int32_t spare3;
};
typedef struct volintInfo volintInfo;

#define VOLINTINFO_SIZE 220
char *ydr_encode_volintInfo(volintInfo *o, char *ptr, size_t *total_len);
char *ydr_decode_volintInfo(volintInfo *o, char *ptr, size_t *total_len);
void ydr_print_volintInfo(volintInfo *o);
struct transDebugInfo {
     int32_t tid;
     int32_t time;
     int32_t creationTime;
     int32_t returnCode;
     int32_t volid;
     int32_t partition;
     int16_t iflags;
     char vflags;
     char tflags;
     char lastProcName[ 30 ];
     int32_t callValid;
     int32_t readNext;
     int32_t transmitNext;
     int32_t lastSendTime;
     int32_t lastReceiveTime;
};
typedef struct transDebugInfo transDebugInfo;

#define TRANSDEBUGINFO_SIZE 176
char *ydr_encode_transDebugInfo(transDebugInfo *o, char *ptr, size_t *total_len);
char *ydr_decode_transDebugInfo(transDebugInfo *o, char *ptr, size_t *total_len);
void ydr_print_transDebugInfo(transDebugInfo *o);
struct pIDs {
     int32_t partIds[ 26 ];
};
typedef struct pIDs pIDs;

#define PIDS_SIZE 104
char *ydr_encode_pIDs(pIDs *o, char *ptr, size_t *total_len);
char *ydr_decode_pIDs(pIDs *o, char *ptr, size_t *total_len);
void ydr_print_pIDs(pIDs *o);
struct diskPartition {
     char name[ 32 ];
     char devName[ 32 ];
     int32_t lock_fd;
     int32_t totalUsable;
     int32_t free;
     int32_t minFree;
};
typedef struct diskPartition diskPartition;

#define DISKPARTITION_SIZE 272
char *ydr_encode_diskPartition(diskPartition *o, char *ptr, size_t *total_len);
char *ydr_decode_diskPartition(diskPartition *o, char *ptr, size_t *total_len);
void ydr_print_diskPartition(diskPartition *o);
struct restoreCookie {
     char name[ 32 ];
     int32_t type;
     int32_t clone;
     int32_t parent;
};
typedef struct restoreCookie restoreCookie;

#define RESTORECOOKIE_SIZE 140
char *ydr_encode_restoreCookie(restoreCookie *o, char *ptr, size_t *total_len);
char *ydr_decode_restoreCookie(restoreCookie *o, char *ptr, size_t *total_len);
void ydr_print_restoreCookie(restoreCookie *o);
typedef struct {
unsigned len;
struct transDebugInfo *val;
} transDebugEntries;

char *ydr_encode_transDebugEntries(transDebugEntries *o, char *ptr, size_t *total_len);
char *ydr_decode_transDebugEntries(transDebugEntries *o, char *ptr, size_t *total_len);
void ydr_print_transDebugEntries(transDebugEntries *o);
typedef struct {
unsigned len;
struct volintInfo *val;
} volEntries;

char *ydr_encode_volEntries(volEntries *o, char *ptr, size_t *total_len);
char *ydr_decode_volEntries(volEntries *o, char *ptr, size_t *total_len);
void ydr_print_volEntries(volEntries *o);

#endif /* VOLUMESERVER */
