
/* copyright (c) 2000 
   the regents of the university of michigan 
   all rights reserved 
   
   permission is granted to use, copy, create derivative works and  
   redistribute this software and such derivative works for any purpose,  
   so long as the name of the university of michigan is not used in any  
   advertising or publicity pertaining to the use or distribution of this  
   software without specific, written prior authorization.  if the above  
   copyright notice or any other identification of the university of  
   michigan is included in any copy of any portion of this software, then  
   the disclaimer below must also be included. 
   
   this software is provided as is, without representation from the  
   university of michigan as to its fitness for any purpose, and without  
   warranty by the university of michigan of any kind, either express or  
   implied, including without limitation the implied warranties of  
   merchantability and fitness for a particular purpose.  the regents of  
   the university of michigan shall not be liable for any damages,  
   including special, indirect, incidental, or consequential damages, with  
   respect to any claim arising out or in connection with the use of the  
   software, even if it has been or is hereafter advised of the  
   possibility of such damages. */

/* Generated from volumeserver.xg */
#include "volumeserver.h"

#include "volumeserver.cs.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <roken.h>
#include <arlad/fs_errors.h>
#ifndef HAVE_BCOPY
#define bcopy(a,b,c) memcpy((b),(a),(c))
#endif /* !HAVE_BCOPY */

#ifdef RCSID
RCSID("volumeserver.cs.c generated from volumeserver.xg with $Id: output.c,v 1.43 1998/12/13 16:52:04 assar Exp $");
#endif

int VOLSER_AFSVolCreateVolume(
struct rx_connection *connection
, const int32_t partition
, const char *name
, const int32_t type
, const int32_t parent
, int32_t *volid
, int32_t *trans
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (100);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (partition);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*name));
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (type);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (parent);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl ((*volid));
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*volid) = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*trans) = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolTransCreate(
struct rx_connection *connection
, const int32_t volume
, const int32_t partition
, const int32_t flags
, int32_t *trans
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (108);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (volume);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (partition);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*trans) = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolEndTrans(
struct rx_connection *connection
, const int32_t trans
, int32_t *rcode
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (104);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (trans);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*rcode) = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolGetFlags(
struct rx_connection *connection
, const int32_t trans
, int32_t *flags
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (107);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (trans);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*flags) = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolSetFlags(
struct rx_connection *connection
, const int32_t trans
, const int32_t flags
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (106);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (trans);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolGetName(
struct rx_connection *connection
, const int32_t tid
, char tname[256]
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (112);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (tid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
unsigned padlen;
char zero[4] = {0, 0, 0, 0};
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
len = ntohl (u);
}
if (len >= 256)
abort();
if(rx_Read(call, tname, len) != len)
goto fail;
tname[len] = '\0';
padlen = (4 - (len % 4)) % 4;
if(rx_Read(call, zero, padlen) != padlen)
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolSetDate(
struct rx_connection *connection
, const int32_t tid
, const int32_t newDate
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (123);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (tid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (newDate);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolListPartitions(
struct rx_connection *connection
, struct pIDs *partIDs
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (115);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 26;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*partIDs).partIds[i0] = ntohl (u);
}
}
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolPartitionInfo(
struct rx_connection *connection
, const char name[256]
, struct diskPartition *partition
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (119);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ unsigned len;
char zero[4] = {0, 0, 0, 0};
unsigned padlen;
len = strlen(name);
padlen = (4 - (len % 4)) % 4;
{ u_int32_t u;
u = htonl (len);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
if(rx_Write(call, name, len) != len)
goto fail;
if(rx_Write(call, zero, padlen) != padlen)
goto fail;
}
{
int i0;
for(i0 = 0; i0 < 32;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*partition).name[i0] = ntohl (u);
}
}
}
{
int i0;
for(i0 = 0; i0 < 32;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*partition).devName[i0] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*partition).lock_fd = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*partition).totalUsable = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*partition).free = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*partition).minFree = ntohl (u);
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolListVolumes(
struct rx_connection *connection
, const int32_t partID
, const int32_t flags
, volEntries *resultEntries
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (116);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (partID);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (flags);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).len = ntohl (u);
}
(*resultEntries).val = (struct volintInfo *)malloc(sizeof(struct volintInfo ) * (*resultEntries).len);
{
int i0;
for(i0 = 0; i0 < (*resultEntries).len;++i0){
{
int i1;
for(i1 = 0; i1 < 32;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].name[i1] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].volid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].type = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].backupID = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].parentID = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].cloneID = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].status = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].copyDate = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].inUse = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].needsSalvaged = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].destroyMe = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].creationDate = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].accessDate = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].updateDate = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].backupDate = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].dayUse = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].filecount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].maxquota = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].size = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].spare0 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].spare3 = ntohl (u);
}
}
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolListOneVolume(
struct rx_connection *connection
, const int32_t partID
, const int32_t volid
, volEntries *resultEntries
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (121);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (partID);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
u = htonl (volid);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).len = ntohl (u);
}
(*resultEntries).val = (struct volintInfo *)malloc(sizeof(struct volintInfo ) * (*resultEntries).len);
{
int i0;
for(i0 = 0; i0 < (*resultEntries).len;++i0){
{
int i1;
for(i1 = 0; i1 < 32;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].name[i1] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].volid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].type = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].backupID = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].parentID = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].cloneID = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].status = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].copyDate = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].inUse = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].needsSalvaged = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].destroyMe = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].creationDate = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].accessDate = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].updateDate = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].backupDate = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].dayUse = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].filecount = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].maxquota = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].size = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].flags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].spare0 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].spare1 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].spare2 = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*resultEntries).val[i0].spare3 = ntohl (u);
}
}
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
int VOLSER_AFSVolMonitor(
struct rx_connection *connection
, transDebugEntries *result
)
{
struct rx_call *call;
int ret = 0;
call = rx_NewCall (connection);
{ u_int32_t u;
u = htonl (118);
if(rx_Write(call, &u, sizeof(u)) != sizeof(u))
goto fail;
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).len = ntohl (u);
}
(*result).val = (struct transDebugInfo *)malloc(sizeof(struct transDebugInfo ) * (*result).len);
{
int i0;
for(i0 = 0; i0 < (*result).len;++i0){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].tid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].time = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].creationTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].returnCode = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].volid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].partition = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].iflags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].vflags = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].tflags = ntohl (u);
}
{
int i1;
for(i1 = 0; i1 < 30;++i1){
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].lastProcName[i1] = ntohl (u);
}
}
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].callValid = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].readNext = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].transmitNext = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].lastSendTime = ntohl (u);
}
{ u_int32_t u;
if(rx_Read(call, &u, sizeof(u)) != sizeof(u))
goto fail;
(*result).val[i0].lastReceiveTime = ntohl (u);
}
}
}
return rx_EndCall (call,0);
fail:
ret = conv_to_arla_errno(rx_Error(call));
rx_EndCall (call, 0);
return ret;
}
